/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.appcheck.AppCheckProvider;
import com.google.firebase.appcheck.AppCheckProviderFactory;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.FirebaseAppCheck;
import com.google.firebase.appcheck.internal.DefaultAppCheckTokenResult;
import com.google.firebase.appcheck.internal.StorageHelper;
import com.google.firebase.appcheck.internal.TokenRefreshManager;
import com.google.firebase.appcheck.internal.util.Clock;
import com.google.firebase.appcheck.interop.AppCheckTokenListener;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.inject.Provider;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.util.ArrayList;
import java.util.List;

public class DefaultFirebaseAppCheck
extends FirebaseAppCheck {
    private static final long BUFFER_TIME_MILLIS = 300000L;
    private static final String HEART_BEAT_STORAGE_TAG = "fire-app-check";
    private final FirebaseApp firebaseApp;
    private final Provider<UserAgentPublisher> userAgentPublisherProvider;
    private final Provider<HeartBeatInfo> heartBeatInfoProvider;
    private final List<AppCheckTokenListener> appCheckTokenListenerList;
    private final List<FirebaseAppCheck.AppCheckListener> appCheckListenerList;
    private final StorageHelper storageHelper;
    private final TokenRefreshManager tokenRefreshManager;
    private final Clock clock;
    private AppCheckProviderFactory appCheckProviderFactory;
    private AppCheckProvider appCheckProvider;
    private AppCheckToken cachedToken;

    public DefaultFirebaseAppCheck(@NonNull FirebaseApp firebaseApp, @NonNull Provider<UserAgentPublisher> userAgentPublisherProvider, @NonNull Provider<HeartBeatInfo> heartBeatInfoProvider) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull(userAgentPublisherProvider);
        Preconditions.checkNotNull(heartBeatInfoProvider);
        this.firebaseApp = firebaseApp;
        this.userAgentPublisherProvider = userAgentPublisherProvider;
        this.heartBeatInfoProvider = heartBeatInfoProvider;
        this.appCheckTokenListenerList = new ArrayList<AppCheckTokenListener>();
        this.appCheckListenerList = new ArrayList<FirebaseAppCheck.AppCheckListener>();
        this.storageHelper = new StorageHelper(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey());
        this.tokenRefreshManager = new TokenRefreshManager(firebaseApp.getApplicationContext(), this);
        this.clock = new Clock.DefaultClock();
        this.setCachedToken(this.storageHelper.retrieveAppCheckToken());
    }

    @Override
    public void installAppCheckProviderFactory(@NonNull AppCheckProviderFactory factory) {
        this.installAppCheckProviderFactory(factory, this.firebaseApp.isDataCollectionDefaultEnabled());
    }

    @Override
    public void installAppCheckProviderFactory(@NonNull AppCheckProviderFactory factory, boolean isTokenAutoRefreshEnabled) {
        Preconditions.checkNotNull((Object)factory);
        this.appCheckProviderFactory = factory;
        this.appCheckProvider = factory.create(this.firebaseApp);
        this.tokenRefreshManager.setIsAutoRefreshEnabled(isTokenAutoRefreshEnabled);
    }

    @VisibleForTesting
    @Nullable
    public AppCheckProviderFactory getInstalledAppCheckProviderFactory() {
        return this.appCheckProviderFactory;
    }

    @Override
    public void setTokenAutoRefreshEnabled(boolean isTokenAutoRefreshEnabled) {
        this.tokenRefreshManager.setIsAutoRefreshEnabled(isTokenAutoRefreshEnabled);
    }

    @VisibleForTesting
    public void resetAppCheckState() {
        this.appCheckProviderFactory = null;
        this.appCheckProvider = null;
        this.cachedToken = null;
        this.storageHelper.clearSharedPrefs();
    }

    public void addAppCheckTokenListener(@NonNull AppCheckTokenListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.appCheckTokenListenerList.add(listener);
        this.tokenRefreshManager.onListenerCountChanged(this.appCheckTokenListenerList.size() + this.appCheckListenerList.size());
        if (this.hasValidToken()) {
            listener.onAppCheckTokenChanged((AppCheckTokenResult)DefaultAppCheckTokenResult.constructFromAppCheckToken(this.cachedToken));
        }
    }

    public void removeAppCheckTokenListener(@NonNull AppCheckTokenListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.appCheckTokenListenerList.remove(listener);
        this.tokenRefreshManager.onListenerCountChanged(this.appCheckTokenListenerList.size() + this.appCheckListenerList.size());
    }

    @Override
    public void addAppCheckListener(@NonNull FirebaseAppCheck.AppCheckListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.appCheckListenerList.add(listener);
        this.tokenRefreshManager.onListenerCountChanged(this.appCheckTokenListenerList.size() + this.appCheckListenerList.size());
        if (this.hasValidToken()) {
            listener.onAppCheckTokenChanged(this.cachedToken);
        }
    }

    @Override
    public void removeAppCheckListener(@NonNull FirebaseAppCheck.AppCheckListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.appCheckListenerList.remove(listener);
        this.tokenRefreshManager.onListenerCountChanged(this.appCheckTokenListenerList.size() + this.appCheckListenerList.size());
    }

    @NonNull
    public Task<AppCheckTokenResult> getToken(boolean forceRefresh) {
        if (!forceRefresh && this.hasValidToken()) {
            return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromAppCheckToken(this.cachedToken)));
        }
        if (this.appCheckProvider == null) {
            return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromError(new FirebaseException("No AppCheckProvider installed."))));
        }
        return this.fetchTokenFromProvider().continueWithTask((Continuation)new Continuation<AppCheckToken, Task<AppCheckTokenResult>>(){

            public Task<AppCheckTokenResult> then(@NonNull Task<AppCheckToken> task) {
                if (task.isSuccessful()) {
                    return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromAppCheckToken((AppCheckToken)task.getResult())));
                }
                return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromError(new FirebaseException(task.getException().getMessage(), (Throwable)task.getException()))));
            }
        });
    }

    @Override
    @NonNull
    public Task<AppCheckToken> getAppCheckToken(boolean forceRefresh) {
        if (!forceRefresh && this.hasValidToken()) {
            return Tasks.forResult((Object)this.cachedToken);
        }
        if (this.appCheckProvider == null) {
            return Tasks.forException((Exception)new FirebaseException("No AppCheckProvider installed."));
        }
        return this.fetchTokenFromProvider();
    }

    Task<AppCheckToken> fetchTokenFromProvider() {
        return this.appCheckProvider.getToken().continueWithTask((Continuation)new Continuation<AppCheckToken, Task<AppCheckToken>>(){

            public Task<AppCheckToken> then(@NonNull Task<AppCheckToken> task) {
                if (task.isSuccessful()) {
                    AppCheckToken token = (AppCheckToken)task.getResult();
                    DefaultFirebaseAppCheck.this.updateStoredToken(token);
                    for (FirebaseAppCheck.AppCheckListener listener : DefaultFirebaseAppCheck.this.appCheckListenerList) {
                        listener.onAppCheckTokenChanged(token);
                    }
                    DefaultAppCheckTokenResult tokenResult = DefaultAppCheckTokenResult.constructFromAppCheckToken(token);
                    for (AppCheckTokenListener listener : DefaultFirebaseAppCheck.this.appCheckTokenListenerList) {
                        listener.onAppCheckTokenChanged((AppCheckTokenResult)tokenResult);
                    }
                }
                return task;
            }
        });
    }

    @Nullable
    String getUserAgent() {
        return this.userAgentPublisherProvider.get() != null ? ((UserAgentPublisher)this.userAgentPublisherProvider.get()).getUserAgent() : null;
    }

    @Nullable
    String getHeartbeatCode() {
        return this.heartBeatInfoProvider.get() != null ? Integer.toString(((HeartBeatInfo)this.heartBeatInfoProvider.get()).getHeartBeatCode(HEART_BEAT_STORAGE_TAG).getCode()) : null;
    }

    @VisibleForTesting
    void setCachedToken(@NonNull AppCheckToken token) {
        this.cachedToken = token;
    }

    private void updateStoredToken(@NonNull AppCheckToken token) {
        this.storageHelper.saveAppCheckToken(token);
        this.setCachedToken(token);
        this.tokenRefreshManager.maybeScheduleTokenRefresh(token);
    }

    private boolean hasValidToken() {
        return this.cachedToken != null && this.cachedToken.getExpireTimeMillis() - this.clock.currentTimeMillis() > 300000L;
    }
}

