/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.FirebaseException;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.AppCheckTokenResult;

public final class DefaultAppCheckTokenResult
extends AppCheckTokenResult {
    @VisibleForTesting
    static final String DUMMY_TOKEN = "eyJlcnJvciI6IlVOS05PV05fRVJST1IifQ==";
    private final String token;
    private final FirebaseException error;

    @NonNull
    public static DefaultAppCheckTokenResult constructFromAppCheckToken(@NonNull AppCheckToken token) {
        Preconditions.checkNotNull((Object)token);
        return new DefaultAppCheckTokenResult(token.getToken(), null);
    }

    @NonNull
    public static DefaultAppCheckTokenResult constructFromError(@NonNull FirebaseException error) {
        return new DefaultAppCheckTokenResult(DUMMY_TOKEN, (FirebaseException)Preconditions.checkNotNull((Object)error));
    }

    private DefaultAppCheckTokenResult(@NonNull String tokenJwt, @Nullable FirebaseException error) {
        Preconditions.checkNotEmpty((String)tokenJwt);
        this.token = tokenJwt;
        this.error = error;
    }

    @NonNull
    public String getToken() {
        return this.token;
    }

    @Nullable
    public FirebaseException getError() {
        return this.error;
    }
}

