/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.internal.AppCheckTokenResponse;
import com.google.firebase.appcheck.internal.util.Clock;
import com.google.firebase.appcheck.internal.util.TokenParser;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class DefaultAppCheckToken
extends AppCheckToken {
    private static final String TAG = DefaultAppCheckToken.class.getName();
    @VisibleForTesting
    static final String TOKEN_KEY = "token";
    @VisibleForTesting
    static final String RECEIVED_AT_TIMESTAMP_KEY = "receivedAt";
    @VisibleForTesting
    static final String EXPIRES_IN_MILLIS_KEY = "expiresIn";
    @VisibleForTesting
    static final String ISSUED_AT_KEY = "iat";
    @VisibleForTesting
    static final String EXPIRATION_TIME_KEY = "exp";
    private static final long ONE_SECOND_MILLIS = 1000L;
    private final String token;
    private final long receivedAtTimestamp;
    private final long expiresInMillis;

    @VisibleForTesting
    DefaultAppCheckToken(@NonNull String tokenJwt, long expiresInMillis) {
        this(tokenJwt, expiresInMillis, new Clock.DefaultClock().currentTimeMillis());
    }

    @VisibleForTesting
    DefaultAppCheckToken(@NonNull String tokenJwt, long expiresInMillis, long receivedAtTimestamp) {
        Preconditions.checkNotEmpty((String)tokenJwt);
        this.token = tokenJwt;
        this.expiresInMillis = expiresInMillis;
        this.receivedAtTimestamp = receivedAtTimestamp;
    }

    @NonNull
    public static DefaultAppCheckToken constructFromAppCheckTokenResponse(@NonNull AppCheckTokenResponse tokenResponse) {
        long expiresInMillis;
        Preconditions.checkNotNull((Object)tokenResponse);
        try {
            String timeToLiveSeconds = tokenResponse.getTimeToLive().replace("s", "");
            expiresInMillis = (long)(Double.parseDouble(timeToLiveSeconds) * 1000.0);
        }
        catch (NumberFormatException e) {
            Map<String, Object> claimsMap = TokenParser.parseTokenClaims(tokenResponse.getAttestationToken());
            long iat = DefaultAppCheckToken.getLongFromClaimsSafely(claimsMap, ISSUED_AT_KEY);
            long exp = DefaultAppCheckToken.getLongFromClaimsSafely(claimsMap, EXPIRATION_TIME_KEY);
            expiresInMillis = (exp - iat) * 1000L;
        }
        return new DefaultAppCheckToken(tokenResponse.getAttestationToken(), expiresInMillis);
    }

    @Override
    @NonNull
    public String getToken() {
        return this.token;
    }

    @Override
    public long getExpireTimeMillis() {
        return this.receivedAtTimestamp + this.expiresInMillis;
    }

    long getReceivedAtTimestamp() {
        return this.receivedAtTimestamp;
    }

    long getExpiresInMillis() {
        return this.expiresInMillis;
    }

    @Nullable
    String serializeTokenToString() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(TOKEN_KEY, (Object)this.token);
            jsonObject.put(RECEIVED_AT_TIMESTAMP_KEY, this.receivedAtTimestamp);
            jsonObject.put(EXPIRES_IN_MILLIS_KEY, this.expiresInMillis);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Could not serialize token: " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    static DefaultAppCheckToken deserializeTokenFromJsonString(@NonNull String tokenJsonString) {
        try {
            JSONObject jsonObject = new JSONObject(tokenJsonString);
            String tokenJwt = jsonObject.getString(TOKEN_KEY);
            long receivedAtTimestamp = jsonObject.getLong(RECEIVED_AT_TIMESTAMP_KEY);
            long expiresInMillis = jsonObject.getLong(EXPIRES_IN_MILLIS_KEY);
            return new DefaultAppCheckToken(tokenJwt, expiresInMillis, receivedAtTimestamp);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Could not deserialize token: " + e.getMessage()));
            return null;
        }
    }

    @NonNull
    public static DefaultAppCheckToken constructFromRawToken(@NonNull String token) {
        Preconditions.checkNotNull((Object)token);
        Map<String, Object> claimsMap = TokenParser.parseTokenClaims(token);
        long iat = DefaultAppCheckToken.getLongFromClaimsSafely(claimsMap, ISSUED_AT_KEY);
        long exp = DefaultAppCheckToken.getLongFromClaimsSafely(claimsMap, EXPIRATION_TIME_KEY);
        long expiresInMillis = (exp - iat) * 1000L;
        return new DefaultAppCheckToken(token, expiresInMillis, iat * 1000L);
    }

    private static long getLongFromClaimsSafely(@NonNull Map<String, Object> claimsMap, @NonNull String key) {
        Preconditions.checkNotNull(claimsMap);
        Preconditions.checkNotEmpty((String)key);
        Integer result = (Integer)claimsMap.get(key);
        return result == null ? 0L : result.longValue();
    }
}

