/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Strings;
import com.google.firebase.FirebaseException;
import org.json.JSONException;
import org.json.JSONObject;

public class AppCheckTokenResponse {
    @VisibleForTesting
    static final String TOKEN_KEY = "token";
    @VisibleForTesting
    static final String TIME_TO_LIVE_KEY = "ttl";
    private String token;
    private String timeToLive;

    @NonNull
    public static AppCheckTokenResponse fromJsonString(@NonNull String jsonString) throws FirebaseException, JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        String token = Strings.emptyToNull((String)jsonObject.optString(TOKEN_KEY));
        String timeToLive = Strings.emptyToNull((String)jsonObject.optString(TIME_TO_LIVE_KEY));
        if (token == null || timeToLive == null) {
            throw new FirebaseException("Unexpected server response.");
        }
        return new AppCheckTokenResponse(token, timeToLive);
    }

    private AppCheckTokenResponse(@NonNull String token, @NonNull String timeToLive) {
        Preconditions.checkNotNull((Object)token);
        Preconditions.checkNotNull((Object)timeToLive);
        this.token = token;
        this.timeToLive = timeToLive;
    }

    @NonNull
    public String getToken() {
        return this.token;
    }

    @NonNull
    public String getTimeToLive() {
        return this.timeToLive;
    }
}

