/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.VisibleForTesting;
import com.google.firebase.appcheck.internal.util.Clock;

public class RetryManager {
    @VisibleForTesting
    static final int BAD_REQUEST_ERROR_CODE = 400;
    @VisibleForTesting
    static final int FORBIDDEN_ERROR_CODE = 403;
    @VisibleForTesting
    static final int NOT_FOUND_ERROR_CODE = 404;
    @VisibleForTesting
    static final long MAX_EXP_BACKOFF_MILLIS = 14400000L;
    @VisibleForTesting
    static final long ONE_DAY_MILLIS = 86400000L;
    @VisibleForTesting
    static final long ONE_SECOND_MILLIS = 1000L;
    @VisibleForTesting
    static final long UNSET_RETRY_TIME = -1L;
    private static final double MAX_JITTER_MULTIPLIER = 0.5;
    private final Clock clock;
    private long currentRetryCount = 0L;
    private long nextRetryTimeMillis = -1L;
    private static final int EXPONENTIAL = 0;
    private static final int ONE_DAY = 1;

    public RetryManager() {
        this.clock = new Clock.DefaultClock();
    }

    @VisibleForTesting
    RetryManager(Clock clock) {
        this.clock = clock;
    }

    public boolean canRetry() {
        return this.nextRetryTimeMillis <= this.clock.currentTimeMillis();
    }

    @VisibleForTesting
    long getNextRetryTimeMillis() {
        return this.nextRetryTimeMillis;
    }

    public void resetBackoffOnSuccess() {
        this.currentRetryCount = 0L;
        this.nextRetryTimeMillis = -1L;
    }

    public void updateBackoffOnFailure(int errorCode) {
        ++this.currentRetryCount;
        if (RetryManager.getBackoffStrategyByErrorCode(errorCode) == 1) {
            this.nextRetryTimeMillis = this.clock.currentTimeMillis() + 86400000L;
        } else {
            double jitterCoefficient = 1.0 + Math.random() * 0.5;
            long exponentialBackoffMillis = (long)(Math.pow(2.0, (double)this.currentRetryCount * jitterCoefficient) * 1000.0);
            this.nextRetryTimeMillis = this.clock.currentTimeMillis() + Math.min(exponentialBackoffMillis, 14400000L);
        }
    }

    private static int getBackoffStrategyByErrorCode(int errorCode) {
        if (errorCode == 400 || errorCode == 403 || errorCode == 404) {
            return 1;
        }
        return 0;
    }
}

