/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.util.zzw;

public final class FirebaseOptions {
    private final String zzbWN;
    private final String zzamX;
    private final String zzbWO;
    private final String zzbWP;
    private final String zzbWQ;
    private final String zzbWR;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        zzac.zza((!zzw.zzdz((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzamX = string;
        this.zzbWN = string2;
        this.zzbWO = string3;
        this.zzbWP = string4;
        this.zzbWQ = string5;
        this.zzbWR = string6;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzam zzam2 = new zzam(context);
        String string = zzam2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzam2.getString("google_api_key"), zzam2.getString("firebase_database_url"), zzam2.getString("ga_trackingId"), zzam2.getString("gcm_defaultSenderId"), zzam2.getString("google_storage_bucket"));
    }

    public String getApiKey() {
        return this.zzbWN;
    }

    public String getApplicationId() {
        return this.zzamX;
    }

    public String getDatabaseUrl() {
        return this.zzbWO;
    }

    public String getGcmSenderId() {
        return this.zzbWQ;
    }

    public String getStorageBucket() {
        return this.zzbWR;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzaa.equal((Object)this.zzamX, (Object)firebaseOptions.zzamX) && zzaa.equal((Object)this.zzbWN, (Object)firebaseOptions.zzbWN) && zzaa.equal((Object)this.zzbWO, (Object)firebaseOptions.zzbWO) && zzaa.equal((Object)this.zzbWP, (Object)firebaseOptions.zzbWP) && zzaa.equal((Object)this.zzbWQ, (Object)firebaseOptions.zzbWQ) && zzaa.equal((Object)this.zzbWR, (Object)firebaseOptions.zzbWR);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzamX, this.zzbWN, this.zzbWO, this.zzbWP, this.zzbWQ, this.zzbWR});
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("applicationId", (Object)this.zzamX).zzg("apiKey", (Object)this.zzbWN).zzg("databaseUrl", (Object)this.zzbWO).zzg("gcmSenderId", (Object)this.zzbWQ).zzg("storageBucket", (Object)this.zzbWR).toString();
    }

    public static final class Builder {
        private String zzbWN;
        private String zzamX;
        private String zzbWO;
        private String zzbWP;
        private String zzbWQ;
        private String zzbWR;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzamX = firebaseOptions.zzamX;
            this.zzbWN = firebaseOptions.zzbWN;
            this.zzbWO = firebaseOptions.zzbWO;
            this.zzbWP = firebaseOptions.zzbWP;
            this.zzbWQ = firebaseOptions.zzbWQ;
            this.zzbWR = firebaseOptions.zzbWR;
        }

        public Builder setApiKey(@NonNull String string) {
            this.zzbWN = zzac.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public Builder setApplicationId(@NonNull String string) {
            this.zzamX = zzac.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public Builder setDatabaseUrl(@Nullable String string) {
            this.zzbWO = string;
            return this;
        }

        public Builder setGcmSenderId(@Nullable String string) {
            this.zzbWQ = string;
            return this;
        }

        public Builder setStorageBucket(@Nullable String string) {
            this.zzbWR = string;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.zzamX, this.zzbWN, this.zzbWO, this.zzbWP, this.zzbWQ, this.zzbWR);
        }
    }
}

