/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzeuo;
import com.google.android.gms.internal.zzeup;
import com.google.android.gms.internal.zzeuq;
import com.google.android.gms.internal.zzeur;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzlwp = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzlwq = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzlwr = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzlws = Arrays.asList(new String[0]);
    private static final Set<String> zzlwt = Collections.emptySet();
    private static final Object sLock = new Object();
    static final Map<String, FirebaseApp> zzicu = new ArrayMap();
    private final Context mApplicationContext;
    private final String mName;
    private final FirebaseOptions zzlwu;
    private final AtomicBoolean zzlwv = new AtomicBoolean(false);
    private final AtomicBoolean zzlww = new AtomicBoolean();
    private final List<zzb> zzlwx = new CopyOnWriteArrayList<zzb>();
    private final List<zza> zzlwy = new CopyOnWriteArrayList<zza>();
    private final List<Object> zzlwz = new CopyOnWriteArrayList<Object>();
    private zzeuq zzlxa;
    private zzc zzlxb;

    @NonNull
    public Context getApplicationContext() {
        this.zzbox();
        return this.mApplicationContext;
    }

    @NonNull
    public String getName() {
        this.zzbox();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzbox();
        return this.zzlwu;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzbg.zzw((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzlwu).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        zzeup.zzew(context);
        Object object = sLock;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzicu.values());
            zzeup.zzcht();
            Set<String> set = zzeup.zzchu();
            set.removeAll(zzicu.keySet());
            for (String string : set) {
                zzeup.zzrb(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = sLock;
        synchronized (object) {
            FirebaseApp firebaseApp = zzicu.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = zzs.zzamd();
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = sLock;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzicu.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzbpa();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzicu.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzeup.zzew(context);
        Context context2 = context;
        if (context2.getApplicationContext() instanceof Application) {
            zzk.zza((Application)((Application)context2.getApplicationContext()));
            zzk.zzagq().zza((zzl)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = sLock;
        synchronized (object) {
            zzbq.zza((!zzicu.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzbq.checkNotNull((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zzicu.put(string2, firebaseApp);
        }
        zzeup.zzf(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzlwp);
        if (firebaseApp.zzboy()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzlwq);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzlwr);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzbe(boolean bl) {
        Object object = sLock;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzicu.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzlwv.get()) continue;
                firebaseApp2.zzca(bl);
            }
            return;
        }
    }

    public final void zza(@NonNull zzeuq zzeuq2) {
        this.zzlxa = (zzeuq)zzbq.checkNotNull((Object)zzeuq2);
    }

    public final Task<GetTokenResult> getToken(boolean bl) {
        this.zzbox();
        if (this.zzlxa == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzlxa.zzcb(bl);
    }

    @Nullable
    public final String getUid() throws FirebaseApiNotAvailableException {
        this.zzbox();
        if (this.zzlxa == null) {
            throw new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode.");
        }
        return this.zzlxa.getUid();
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzbox();
        if (this.zzlwv.compareAndSet(!bl, bl)) {
            boolean bl2 = zzk.zzagq().zzagr();
            if (bl && bl2) {
                this.zzca(true);
                return;
            }
            if (!bl && bl2) {
                this.zzca(false);
            }
        }
    }

    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.mApplicationContext = (Context)zzbq.checkNotNull((Object)context);
        this.mName = zzbq.zzgi((String)string);
        this.zzlwu = (FirebaseOptions)zzbq.checkNotNull((Object)firebaseOptions);
        this.zzlxb = new zzeuo();
    }

    private final void zzbox() {
        zzbq.zza((!this.zzlww.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public final boolean zzboy() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public final void zza(@NonNull zzeur zzeur2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<zzb> iterator = this.zzlwx.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb(zzeur2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zzca(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<zza> iterator = this.zzlwy.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzbe(bl);
        }
    }

    public final void zza(@NonNull zzb zzb2) {
        this.zzbox();
        zzbq.checkNotNull((Object)zzb2);
        this.zzlwx.add(zzb2);
        this.zzlwx.size();
    }

    public final void zza(zza zza2) {
        this.zzbox();
        if (this.zzlwv.get() && zzk.zzagq().zzagr()) {
            zza2.zzbe(true);
        }
        this.zzlwy.add(zza2);
    }

    public final String zzboz() {
        String string = com.google.android.gms.common.util.zzb.zzl((byte[])this.getName().getBytes());
        String string2 = com.google.android.gms.common.util.zzb.zzl((byte[])this.getOptions().getApplicationId().getBytes());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzbpa() {
        ArraySet arraySet = new ArraySet();
        ArrayList<String> arrayList = sLock;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzicu.values()) {
                arraySet.add(firebaseApp.getName());
            }
            if (zzeup.zzcht() != null) {
                arraySet.addAll(zzeup.zzchu());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)arraySet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzbpb() {
        this.zza(FirebaseApp.class, this, zzlwp);
        if (this.zzboy()) {
            this.zza(FirebaseApp.class, this, zzlwq);
            this.zza(Context.class, this.mApplicationContext, zzlwr);
        }
    }

    private final <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.mApplicationContext);
        if (bl) {
            zzd.zzeo(this.mApplicationContext);
        }
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zzlws.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzlwt.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @TargetApi(value=24)
    static final class zzd
    extends BroadcastReceiver {
        private static AtomicReference<zzd> zzlxc = new AtomicReference();
        private final Context mApplicationContext;

        private zzd(Context context) {
            this.mApplicationContext = context;
        }

        private static void zzeo(Context context) {
            zzd zzd2;
            if (zzlxc.get() == null && zzlxc.compareAndSet(null, zzd2 = new zzd(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzd2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = sLock;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zzicu.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzbpb();
                }
            }
            zzd zzd2 = this;
            zzd2.mApplicationContext.unregisterReceiver((BroadcastReceiver)zzd2);
        }
    }

    public static interface zza {
        public void zzbe(boolean var1);
    }

    public static interface zzc {
    }

    public static interface zzb {
        public void zzb(@NonNull zzeur var1);
    }
}

