/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzca;
import com.google.android.gms.common.util.zzu;
import com.google.firebase.zzc;
import java.util.Arrays;

public final class FirebaseOptions {
    private final String zzmbb;
    private final String zzenh;
    private final String zzmbc;
    private final String zzmbd;
    private final String zzmbe;
    private final String zzmbf;
    private final String zzmbg;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7) {
        zzbq.zza((!zzu.zzgs((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzenh = string;
        this.zzmbb = string2;
        this.zzmbc = string3;
        this.zzmbd = string4;
        this.zzmbe = string5;
        this.zzmbf = string6;
        this.zzmbg = string7;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzca zzca2 = new zzca(context);
        String string = zzca2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzca2.getString("google_api_key"), zzca2.getString("firebase_database_url"), zzca2.getString("ga_trackingId"), zzca2.getString("gcm_defaultSenderId"), zzca2.getString("google_storage_bucket"), zzca2.getString("project_id"));
    }

    public final String getApiKey() {
        return this.zzmbb;
    }

    public final String getApplicationId() {
        return this.zzenh;
    }

    public final String getDatabaseUrl() {
        return this.zzmbc;
    }

    public final String getGcmSenderId() {
        return this.zzmbe;
    }

    public final String getStorageBucket() {
        return this.zzmbf;
    }

    public final String getProjectId() {
        return this.zzmbg;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzbg.equal((Object)this.zzenh, (Object)firebaseOptions.zzenh) && zzbg.equal((Object)this.zzmbb, (Object)firebaseOptions.zzmbb) && zzbg.equal((Object)this.zzmbc, (Object)firebaseOptions.zzmbc) && zzbg.equal((Object)this.zzmbd, (Object)firebaseOptions.zzmbd) && zzbg.equal((Object)this.zzmbe, (Object)firebaseOptions.zzmbe) && zzbg.equal((Object)this.zzmbf, (Object)firebaseOptions.zzmbf) && zzbg.equal((Object)this.zzmbg, (Object)firebaseOptions.zzmbg);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzenh, this.zzmbb, this.zzmbc, this.zzmbd, this.zzmbe, this.zzmbf, this.zzmbg});
    }

    public final String toString() {
        return zzbg.zzx((Object)this).zzg("applicationId", (Object)this.zzenh).zzg("apiKey", (Object)this.zzmbb).zzg("databaseUrl", (Object)this.zzmbc).zzg("gcmSenderId", (Object)this.zzmbe).zzg("storageBucket", (Object)this.zzmbf).zzg("projectId", (Object)this.zzmbg).toString();
    }

    /* synthetic */ FirebaseOptions(String string, String string2, String string3, String string4, String string5, String string6, String string7, zzc zzc2) {
        this(string, string2, string3, string4, string5, string6, string7);
    }

    public static final class Builder {
        private String zzmbb;
        private String zzenh;
        private String zzmbc;
        private String zzmbd;
        private String zzmbe;
        private String zzmbf;
        private String zzmbg;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzenh = firebaseOptions.zzenh;
            this.zzmbb = firebaseOptions.zzmbb;
            this.zzmbc = firebaseOptions.zzmbc;
            this.zzmbd = firebaseOptions.zzmbd;
            this.zzmbe = firebaseOptions.zzmbe;
            this.zzmbf = firebaseOptions.zzmbf;
            this.zzmbg = firebaseOptions.zzmbg;
        }

        public final Builder setApiKey(@NonNull String string) {
            this.zzmbb = zzbq.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public final Builder setApplicationId(@NonNull String string) {
            this.zzenh = zzbq.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public final Builder setDatabaseUrl(@Nullable String string) {
            this.zzmbc = string;
            return this;
        }

        public final Builder setGcmSenderId(@Nullable String string) {
            this.zzmbe = string;
            return this;
        }

        public final Builder setStorageBucket(@Nullable String string) {
            this.zzmbf = string;
            return this;
        }

        public final Builder setProjectId(@Nullable String string) {
            this.zzmbg = string;
            return this;
        }

        public final FirebaseOptions build() {
            return new FirebaseOptions(this.zzenh, this.zzmbb, this.zzmbc, this.zzmbd, this.zzmbe, this.zzmbf, this.zzmbg, null);
        }
    }
}

