/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzu;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.internal.InternalTokenProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzb = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzc = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzd = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zze = Arrays.asList(new String[0]);
    private static final Set<String> zzf = Collections.emptySet();
    private static final Object zzg = new Object();
    static final Map<String, FirebaseApp> zza = new ArrayMap();
    private final Context zzh;
    private final String zzi;
    private final FirebaseOptions zzj;
    private final AtomicBoolean zzk = new AtomicBoolean(false);
    private final AtomicBoolean zzl = new AtomicBoolean();
    private final List<IdTokenListener> zzm = new CopyOnWriteArrayList<IdTokenListener>();
    private final List<zza> zzn = new CopyOnWriteArrayList<zza>();
    private final List<Object> zzo = new CopyOnWriteArrayList<Object>();
    private InternalTokenProvider zzp;
    private zzb zzq;

    @NonNull
    public Context getApplicationContext() {
        this.zze();
        return this.zzh;
    }

    @NonNull
    public String getName() {
        this.zze();
        return this.zzi;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zze();
        return this.zzj;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.zzi.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.zzi.hashCode();
    }

    public String toString() {
        return zzbg.zza((Object)this).zza("name", (Object)this.zzi).zza("options", (Object)this.zzj).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        com.google.firebase.internal.zzb.zza(context);
        Object object = zzg;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zza.values());
            com.google.firebase.internal.zzb.zza();
            Set<String> set = com.google.firebase.internal.zzb.zzb();
            set.removeAll(zza.keySet());
            for (String string : set) {
                com.google.firebase.internal.zzb.zza(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zzg;
        synchronized (object) {
            FirebaseApp firebaseApp = zza.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = zzu.zza();
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzg;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zza.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzf();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zzg;
        synchronized (object) {
            if (zza.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        com.google.firebase.internal.zzb.zza(context);
        Context context2 = context;
        if (context2.getApplicationContext() instanceof Application) {
            com.google.android.gms.common.api.internal.zzk.zza((Application)((Application)context2.getApplicationContext()));
            com.google.android.gms.common.api.internal.zzk.zza().zza((zzl)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = zzg;
        synchronized (object) {
            zzbq.zza((!zza.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzbq.zza((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zza.put(string2, firebaseApp);
        }
        com.google.firebase.internal.zzb.zza(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzb);
        if (firebaseApp.zzb()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzc);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzd);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public static void zza(boolean bl) {
        Object object = zzg;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zza.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzk.get()) continue;
                firebaseApp2.zzb(bl);
            }
            return;
        }
    }

    @Hide
    public final void zza(@NonNull InternalTokenProvider internalTokenProvider) {
        this.zzp = (InternalTokenProvider)zzbq.zza((Object)internalTokenProvider);
    }

    @Hide
    public final void zza(@NonNull zzb zzb2) {
        this.zzq = (zzb)zzbq.zza((Object)zzb2);
        this.zzq.zza(this.zzm.size());
    }

    @Hide
    @KeepForSdk
    public Task<GetTokenResult> getToken(boolean bl) {
        this.zze();
        if (this.zzp == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzp.zza(bl);
    }

    @Hide
    @Nullable
    public final String zza() throws FirebaseApiNotAvailableException {
        this.zze();
        if (this.zzp == null) {
            throw new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode.");
        }
        return this.zzp.zza();
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zze();
        if (this.zzk.compareAndSet(!bl, bl)) {
            boolean bl2 = com.google.android.gms.common.api.internal.zzk.zza().zzb();
            if (bl && bl2) {
                this.zzb(true);
                return;
            }
            if (!bl && bl2) {
                this.zzb(false);
            }
        }
    }

    @Hide
    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.zzh = (Context)zzbq.zza((Object)context);
        this.zzi = zzbq.zza((String)string);
        this.zzj = (FirebaseOptions)zzbq.zza((Object)firebaseOptions);
        this.zzq = new com.google.firebase.internal.zza();
    }

    private final void zze() {
        zzbq.zza((!this.zzl.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    @Hide
    public final boolean zzb() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @Hide
    @UiThread
    public final void zza(@NonNull com.google.firebase.internal.zzc zzc2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<IdTokenListener> iterator = this.zzm.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzc2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zzb(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<zza> iterator = this.zzn.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(bl);
        }
    }

    @Hide
    public final void zza(@NonNull IdTokenListener idTokenListener) {
        this.zze();
        zzbq.zza((Object)idTokenListener);
        this.zzm.add(idTokenListener);
        this.zzq.zza(this.zzm.size());
    }

    @Hide
    public final void zzb(@NonNull IdTokenListener idTokenListener) {
        this.zze();
        zzbq.zza((Object)idTokenListener);
        this.zzm.remove(idTokenListener);
        this.zzq.zza(this.zzm.size());
    }

    @Hide
    public final void zza(zza zza2) {
        this.zze();
        if (this.zzk.get() && com.google.android.gms.common.api.internal.zzk.zza().zzb()) {
            zza2.zza(true);
        }
        this.zzn.add(zza2);
    }

    @Hide
    public final String zzc() {
        String string = com.google.android.gms.common.util.zzc.zzc((byte[])this.getName().getBytes());
        String string2 = com.google.android.gms.common.util.zzc.zzc((byte[])this.getOptions().getApplicationId().getBytes());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzf() {
        ArraySet arraySet = new ArraySet();
        ArrayList<String> arrayList = zzg;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zza.values()) {
                arraySet.add(firebaseApp.getName());
            }
            if (com.google.firebase.internal.zzb.zza() != null) {
                arraySet.addAll(com.google.firebase.internal.zzb.zzb());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)arraySet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzg() {
        this.zza(FirebaseApp.class, this, zzb);
        if (this.zzb()) {
            this.zza(FirebaseApp.class, this, zzc);
            this.zza(Context.class, this.zzh, zzd);
        }
    }

    private final <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.zzh);
        if (bl) {
            com.google.firebase.FirebaseApp$zzc.zzb(this.zzh);
        }
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zze.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzf.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @Hide
    @TargetApi(value=24)
    static final class zzc
    extends BroadcastReceiver {
        private static AtomicReference<zzc> zza = new AtomicReference();
        private final Context zzb;

        private zzc(Context context) {
            this.zzb = context;
        }

        private static void zzb(Context context) {
            zzc zzc2;
            if (zza.get() == null && zza.compareAndSet(null, zzc2 = new zzc(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzc2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = zzg;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zza.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzg();
                }
            }
            zzc zzc2 = this;
            zzc2.zzb.unregisterReceiver((BroadcastReceiver)zzc2);
        }
    }

    @Hide
    public static interface zza {
        public void zza(boolean var1);
    }

    @Hide
    public static interface zzb {
        public void zza(int var1);
    }

    @Hide
    @KeepForSdk
    public static interface IdTokenListener {
        public void zza(@NonNull com.google.firebase.internal.zzc var1);
    }
}

