/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzedp;
import com.google.android.gms.internal.zzedq;
import com.google.android.gms.internal.zzedt;
import com.google.android.gms.internal.zzeeb;
import com.google.android.gms.internal.zzeee;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzedo<K, V>
extends zzedq<K, V> {
    private final K[] zzmav;
    private final V[] zzmyg;
    private final Comparator<K> zzmyh;

    public static <A, B, C> zzedo<A, C> zza(List<A> list, Map<B, C> map, zzedt<A, B> zzedt2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zzedt2.zzbo(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzedo<Object, Object>(comparator, objectArray, objectArray2);
    }

    public zzedo(Comparator<K> comparator) {
        this.zzmav = new Object[0];
        this.zzmyg = new Object[0];
        this.zzmyh = comparator;
    }

    private zzedo(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zzmav = KArray;
        this.zzmyg = VArray;
        this.zzmyh = comparator;
    }

    @Override
    public final boolean containsKey(K k) {
        return this.zzbn(k) != -1;
    }

    @Override
    public final V get(K k) {
        int n = this.zzbn(k);
        if (n != -1) {
            return this.zzmyg[n];
        }
        return null;
    }

    @Override
    public final zzedq<K, V> zzbj(K k) {
        int n = this.zzbn(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzedo.zzc(this.zzmav, n);
        V[] VArray = zzedo.zzc(this.zzmyg, n);
        return new zzedo<K, V>(this.zzmyh, KArray, VArray);
    }

    @Override
    public final zzedq<K, V> zzg(K k, V v) {
        int n = this.zzbn(k);
        if (n != -1) {
            if (this.zzmav[n] == k && this.zzmyg[n] == v) {
                return this;
            }
            K[] KArray = zzedo.zzb(this.zzmav, n, k);
            V[] VArray = zzedo.zzb(this.zzmyg, n, v);
            return new zzedo<K, V>(this.zzmyh, KArray, VArray);
        }
        if (this.zzmav.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zzmav.length + 1);
            for (int i = 0; i < this.zzmav.length; ++i) {
                hashMap.put(this.zzmav[i], this.zzmyg[i]);
            }
            hashMap.put(k, v);
            return zzeee.zzb(hashMap, this.zzmyh);
        }
        int n2 = this.zzbm(k);
        K[] KArray = zzedo.zza(this.zzmav, n2, k);
        V[] VArray = zzedo.zza(this.zzmyg, n2, v);
        return new zzedo<K, V>(this.zzmyh, KArray, VArray);
    }

    @Override
    public final K zzbvp() {
        if (this.zzmav.length > 0) {
            return this.zzmav[0];
        }
        return null;
    }

    @Override
    public final K zzbvq() {
        if (this.zzmav.length > 0) {
            return this.zzmav[this.zzmav.length - 1];
        }
        return null;
    }

    @Override
    public final int size() {
        return this.zzmav.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.zzmav.length == 0;
    }

    @Override
    public final void zza(zzeeb<K, V> zzeeb2) {
        for (int i = 0; i < this.zzmav.length; ++i) {
            zzeeb2.zzh(this.zzmav[i], this.zzmyg[i]);
        }
    }

    private final Iterator<Map.Entry<K, V>> zzj(int n, boolean bl) {
        return new zzedp(this, n, bl);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iterator() {
        return this.zzj(0, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> zzbk(K k) {
        int n = this.zzbm(k);
        return this.zzj(n, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> zzbvr() {
        return this.zzj(this.zzmav.length - 1, true);
    }

    @Override
    public final K zzbl(K k) {
        int n = this.zzbn(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        if (n > 0) {
            return this.zzmav[n - 1];
        }
        return null;
    }

    @Override
    public final int indexOf(K k) {
        return this.zzbn(k);
    }

    @Override
    public final Comparator<K> getComparator() {
        return this.zzmyh;
    }

    private static <T> T[] zzc(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private final int zzbm(K k) {
        int n;
        for (n = 0; n < this.zzmav.length && this.zzmyh.compare(this.zzmav[n], k) < 0; ++n) {
        }
        return n;
    }

    private final int zzbn(K k) {
        int n = 0;
        K[] KArray = this.zzmav;
        int n2 = this.zzmav.length;
        for (int i = 0; i < n2; ++i) {
            K k2 = KArray[i];
            if (this.zzmyh.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static /* synthetic */ Object[] zza(zzedo zzedo2) {
        return zzedo2.zzmav;
    }

    static /* synthetic */ Object[] zzb(zzedo zzedo2) {
        return zzedo2.zzmyg;
    }
}

