/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.components.ComponentFactory;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.zza;
import com.google.firebase.components.zzb;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@KeepForSdk
public final class Component<T> {
    private final Set<Class<? super T>> zza;
    private final Set<Dependency> zzb;
    private final int zzc;
    private final ComponentFactory<T> zzd;
    private final Set<Class<?>> zze;

    /*
     * WARNING - void declaration
     */
    private Component(Set<Class<? super T>> providedInterfaces, Set<Dependency> dependencies, int instantiation, ComponentFactory<T> factory, Set<Class<?>> publishedEvents) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = Collections.unmodifiableSet(var1_1);
        this.zzb = Collections.unmodifiableSet(var2_2);
        this.zzc = var3_3;
        this.zzd = factory;
        this.zze = Collections.unmodifiableSet(publishedEvents);
    }

    public final Set<Class<? super T>> zza() {
        return this.zza;
    }

    public final Set<Dependency> zzb() {
        return this.zzb;
    }

    public final ComponentFactory<T> zzc() {
        return this.zzd;
    }

    public final Set<Class<?>> zzd() {
        return this.zze;
    }

    public final boolean zze() {
        return this.zzc == 1;
    }

    public final boolean zzf() {
        return this.zzc == 2;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("Component<").append(Arrays.toString(this.zza.toArray())).append(">{").append(this.zzc).append(", deps=").append(Arrays.toString(this.zzb.toArray())).append("}");
        return stringBuilder.toString();
    }

    @KeepForSdk
    public static <T> Builder<T> builder(Class<T> anInterface) {
        Class<T> clazz;
        return new Builder(clazz, new Class[0], 0);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static <T> Builder<T> builder(Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
        void var1_1;
        Class<T> clazz;
        return new Builder(clazz, (Class[])var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public static <T> Component<T> of(Class<T> anInterface, T value) {
        void var1_1;
        return Component.builder(anInterface).factory(new zza(var1_1)).build();
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @KeepForSdk
    public static <T> Component<T> of(T value, Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
        T t;
        void var2_2;
        return Component.builder(anInterface, var2_2).factory(new zzb(t)).build();
    }

    static final /* synthetic */ Object zza(Object object) {
        return object;
    }

    static final /* synthetic */ Object zzb(Object object) {
        return object;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ Component(Set x0, Set x1, int x2, ComponentFactory x3, Set x4, byte by) {
        this((Set<Class<T>>)var1_1, (Set<Dependency>)var2_2, (int)var3_3, x3, x4);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @KeepForSdk
    public static class Builder<T> {
        private final Set<Class<? super T>> zza = new HashSet<Class<? super T>>();
        private final Set<Dependency> zzb = new HashSet<Dependency>();
        private int zzc = 0;
        private ComponentFactory<T> zzd;
        private Set<Class<?>> zze = new HashSet();

        /*
         * WARNING - void declaration
         */
        private Builder(Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
            void var2_2;
            Class<? super T>[] classArray;
            Preconditions.checkNotNull(anInterface, (Object)"Null interface");
            this.zza.add((Class<T>)classArray);
            classArray = additionalInterfaces;
            int n = additionalInterfaces.length;
            for (int i = 0; i < n; ++i) {
                Class<? super T> clazz = classArray[i];
                Preconditions.checkNotNull(clazz, (Object)"Null interface");
            }
            Collections.addAll(this.zza, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public Builder<T> add(Dependency dependency) {
            void var1_1;
            Preconditions.checkNotNull((Object)dependency, (Object)"Null dependency");
            Class<?> clazz = dependency.zza();
            Builder builder = this;
            Preconditions.checkArgument((!builder.zza.contains(clazz) ? 1 : 0) != 0, (Object)"Components are not allowed to depend on interfaces they themselves provide.");
            this.zzb.add((Dependency)var1_1);
            return this;
        }

        @KeepForSdk
        public Builder<T> alwaysEager() {
            return this.zza(1);
        }

        @KeepForSdk
        public Builder<T> eagerInDefaultApp() {
            return this.zza(2);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public Builder<T> publishes(Class<?> eventType) {
            void var1_1;
            this.zze.add((Class<?>)var1_1);
            return this;
        }

        private Builder<T> zza(int n) {
            Preconditions.checkState((this.zzc == 0 ? 1 : 0) != 0, (Object)"Instantiation type has already been set.");
            this.zzc = n;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public Builder<T> factory(ComponentFactory<T> value) {
            void var1_1;
            this.zzd = (ComponentFactory)Preconditions.checkNotNull((Object)var1_1, (Object)"Null factory");
            return this;
        }

        @KeepForSdk
        public Component<T> build() {
            Preconditions.checkState((this.zzd != null ? 1 : 0) != 0, (Object)"Missing required property: factory.");
            return new Component(new HashSet<Class<? super T>>(this.zza), new HashSet<Dependency>(this.zzb), this.zzc, this.zzd, this.zze, 0);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Builder(Class x0, Class[] x1, byte by) {
            this((Class<T>)var1_1, (Class<? super T>)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

