/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.annotations.PublicApi;
import java.util.Map;

@PublicApi
public class GetTokenResult {
    private static final String EXPIRATION_TIMESTAMP = "exp";
    private static final String AUTH_TIMESTAMP = "auth_time";
    private static final String ISSUED_AT_TIMESTAMP = "iat";
    private static final String FIREBASE_KEY = "firebase";
    private static final String SIGN_IN_PROVIDER = "sign_in_provider";
    private String token;
    private Map<String, Object> claims;

    @KeepForSdk
    public GetTokenResult(String token, Map<String, Object> claims) {
        this.token = token;
        this.claims = claims;
    }

    @Nullable
    @PublicApi
    public String getToken() {
        return this.token;
    }

    @PublicApi
    public long getExpirationTimestamp() {
        return this.getLongFromClaimsSafely(EXPIRATION_TIMESTAMP);
    }

    @PublicApi
    public long getAuthTimestamp() {
        return this.getLongFromClaimsSafely(AUTH_TIMESTAMP);
    }

    @PublicApi
    public long getIssuedAtTimestamp() {
        return this.getLongFromClaimsSafely(ISSUED_AT_TIMESTAMP);
    }

    @Nullable
    @PublicApi
    public String getSignInProvider() {
        Map firebaseElem = (Map)this.claims.get(FIREBASE_KEY);
        if (firebaseElem != null) {
            return (String)firebaseElem.get(SIGN_IN_PROVIDER);
        }
        return null;
    }

    @PublicApi
    public Map<String, Object> getClaims() {
        return this.claims;
    }

    private long getLongFromClaimsSafely(String key) {
        Integer result = (Integer)this.claims.get(key);
        return result == null ? 0L : result.longValue();
    }
}

