/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.components.Component$$Lambda$1;
import com.google.firebase.components.Component$$Lambda$2;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentFactory;
import com.google.firebase.components.Dependency;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@KeepForSdk
public final class Component<T> {
    private final Set<Class<? super T>> providedInterfaces;
    private final Set<Dependency> dependencies;
    private final int instantiation;
    private final ComponentFactory<T> factory;
    private final Set<Class<?>> publishedEvents;

    private Component(Set<Class<? super T>> providedInterfaces, Set<Dependency> dependencies, int instantiation, ComponentFactory<T> factory, Set<Class<?>> publishedEvents) {
        this.providedInterfaces = Collections.unmodifiableSet(providedInterfaces);
        this.dependencies = Collections.unmodifiableSet(dependencies);
        this.instantiation = instantiation;
        this.factory = factory;
        this.publishedEvents = Collections.unmodifiableSet(publishedEvents);
    }

    public Set<Class<? super T>> getProvidedInterfaces() {
        return this.providedInterfaces;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public ComponentFactory<T> getFactory() {
        return this.factory;
    }

    public Set<Class<?>> getPublishedEvents() {
        return this.publishedEvents;
    }

    public boolean isLazy() {
        return this.instantiation == 0;
    }

    public boolean isAlwaysEager() {
        return this.instantiation == 1;
    }

    public boolean isEagerInDefaultApp() {
        return this.instantiation == 2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Component<").append(Arrays.toString(this.providedInterfaces.toArray())).append(">{").append(this.instantiation).append(", deps=").append(Arrays.toString(this.dependencies.toArray())).append("}");
        return sb.toString();
    }

    @KeepForSdk
    public static <T> Builder<T> builder(Class<T> anInterface) {
        return new Builder((Class)anInterface, new Class[0]);
    }

    @KeepForSdk
    public static <T> Builder<T> builder(Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
        return new Builder((Class)anInterface, (Class[])additionalInterfaces);
    }

    @Deprecated
    @KeepForSdk
    public static <T> Component<T> of(Class<T> anInterface, T value) {
        return Component.builder(anInterface).factory(Component$$Lambda$1.lambdaFactory$(value)).build();
    }

    @SafeVarargs
    @KeepForSdk
    public static <T> Component<T> of(T value, Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
        return Component.builder(anInterface, additionalInterfaces).factory(Component$$Lambda$2.lambdaFactory$(value)).build();
    }

    static /* synthetic */ Object lambda$of$1(Object value, ComponentContainer args) {
        return value;
    }

    static /* synthetic */ Object lambda$of$0(Object value, ComponentContainer args) {
        return value;
    }

    @KeepForSdk
    public static class Builder<T> {
        private final Set<Class<? super T>> providedInterfaces = new HashSet<Class<? super T>>();
        private final Set<Dependency> dependencies = new HashSet<Dependency>();
        private int instantiation = 0;
        private ComponentFactory<T> factory;
        private Set<Class<?>> publishedEvents = new HashSet();

        private Builder(Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
            Preconditions.checkNotNull(anInterface, (Object)"Null interface");
            this.providedInterfaces.add(anInterface);
            for (Class<? super T> iface : additionalInterfaces) {
                Preconditions.checkNotNull(iface, (Object)"Null interface");
            }
            Collections.addAll(this.providedInterfaces, additionalInterfaces);
        }

        @KeepForSdk
        public Builder<T> add(Dependency dependency) {
            Preconditions.checkNotNull((Object)dependency, (Object)"Null dependency");
            this.validateInterface(dependency.getInterface());
            this.dependencies.add(dependency);
            return this;
        }

        @KeepForSdk
        public Builder<T> alwaysEager() {
            return this.setInstantiation(1);
        }

        @KeepForSdk
        public Builder<T> eagerInDefaultApp() {
            return this.setInstantiation(2);
        }

        @KeepForSdk
        public Builder<T> publishes(Class<?> eventType) {
            this.publishedEvents.add(eventType);
            return this;
        }

        private Builder<T> setInstantiation(int instantiation) {
            Preconditions.checkState((this.instantiation == 0 ? 1 : 0) != 0, (Object)"Instantiation type has already been set.");
            this.instantiation = instantiation;
            return this;
        }

        private void validateInterface(Class<?> anInterface) {
            Preconditions.checkArgument((!this.providedInterfaces.contains(anInterface) ? 1 : 0) != 0, (Object)"Components are not allowed to depend on interfaces they themselves provide.");
        }

        @KeepForSdk
        public Builder<T> factory(ComponentFactory<T> value) {
            this.factory = (ComponentFactory)Preconditions.checkNotNull(value, (Object)"Null factory");
            return this;
        }

        @KeepForSdk
        public Component<T> build() {
            Preconditions.checkState((this.factory != null ? 1 : 0) != 0, (Object)"Missing required property: factory.");
            return new Component(new HashSet<Class<? super T>>(this.providedInterfaces), new HashSet<Dependency>(this.dependencies), this.instantiation, this.factory, this.publishedEvents);
        }
    }
}

