/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.components.AbstractComponentContainer;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.Dependency;
import com.google.firebase.events.Event;
import com.google.firebase.events.Publisher;
import com.google.firebase.inject.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class RestrictedComponentContainer
extends AbstractComponentContainer {
    private final Set<Class<?>> allowedDirectInterfaces;
    private final Set<Class<?>> allowedProviderInterfaces;
    private final Set<Class<?>> allowedPublishedEvents;
    private final ComponentContainer delegateContainer;

    RestrictedComponentContainer(Component<?> component, ComponentContainer container) {
        HashSet directInterfaces = new HashSet();
        HashSet providerInterfaces = new HashSet();
        for (Dependency dependency : component.getDependencies()) {
            if (dependency.isDirectInjection()) {
                directInterfaces.add(dependency.getInterface());
                continue;
            }
            providerInterfaces.add(dependency.getInterface());
        }
        if (!component.getPublishedEvents().isEmpty()) {
            directInterfaces.add(Publisher.class);
        }
        this.allowedDirectInterfaces = Collections.unmodifiableSet(directInterfaces);
        this.allowedProviderInterfaces = Collections.unmodifiableSet(providerInterfaces);
        this.allowedPublishedEvents = component.getPublishedEvents();
        this.delegateContainer = container;
    }

    @Override
    public <T> T get(Class<T> anInterface) {
        if (!this.allowedDirectInterfaces.contains(anInterface)) {
            throw new IllegalArgumentException(String.format("Requesting %s is not allowed.", anInterface));
        }
        T value = this.delegateContainer.get(anInterface);
        if (!anInterface.equals(Publisher.class)) {
            return value;
        }
        RestrictedPublisher publisher = new RestrictedPublisher(this.allowedPublishedEvents, (Publisher)value);
        return (T)publisher;
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> anInterface) {
        if (!this.allowedProviderInterfaces.contains(anInterface)) {
            throw new IllegalArgumentException(String.format("Requesting Provider<%s> is not allowed.", anInterface));
        }
        return this.delegateContainer.getProvider(anInterface);
    }

    private static class RestrictedPublisher
    implements Publisher {
        private final Set<Class<?>> allowedPublishedEvents;
        private final Publisher delegate;

        public RestrictedPublisher(Set<Class<?>> allowedPublishedEvents, Publisher delegate) {
            this.allowedPublishedEvents = allowedPublishedEvents;
            this.delegate = delegate;
        }

        @Override
        public void publish(Event<?> event) {
            if (!this.allowedPublishedEvents.contains(event.getType())) {
                throw new IllegalArgumentException(String.format("Attempting to publish an undeclared event %s.", event));
            }
            this.delegate.publish(event);
        }
    }
}

