/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;

class HeartBeatInfoStorage {
    private static HeartBeatInfoStorage instance = null;
    private static final String GLOBAL = "fire-global";
    private static final String preferencesName = "FirebaseAppHeartBeat";
    private final SharedPreferences sharedPreferences;

    private HeartBeatInfoStorage(Context applicationContext) {
        this.sharedPreferences = applicationContext.getSharedPreferences(preferencesName, 0);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    HeartBeatInfoStorage(SharedPreferences preferences) {
        this.sharedPreferences = preferences;
    }

    static synchronized HeartBeatInfoStorage getInstance(Context applicationContext) {
        if (instance == null) {
            instance = new HeartBeatInfoStorage(applicationContext);
        }
        return instance;
    }

    synchronized boolean shouldSendSdkHeartBeat(String heartBeatTag, long millis) {
        if (this.sharedPreferences.contains(heartBeatTag)) {
            long timeElapsed = millis - this.sharedPreferences.getLong(heartBeatTag, -1L);
            if (timeElapsed >= 86400000L) {
                this.sharedPreferences.edit().putLong(heartBeatTag, millis).apply();
                return true;
            }
            return false;
        }
        this.sharedPreferences.edit().putLong(heartBeatTag, millis).apply();
        return true;
    }

    synchronized boolean shouldSendGlobalHeartBeat(long millis) {
        return this.shouldSendSdkHeartBeat(GLOBAL, millis);
    }
}

