/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.heartbeatinfo.SdkHeartBeatResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

class HeartBeatInfoStorage {
    private static HeartBeatInfoStorage instance = null;
    private static final String GLOBAL = "fire-global";
    private static final String PREFERENCES_NAME = "FirebaseAppHeartBeat";
    private static final String HEART_BEAT_COUNT_TAG = "fire-count";
    private static final int HEART_BEAT_COUNT_LIMIT = 200;
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("dd/MM/yyyy z");
    private static final String STORAGE_PREFERENCES_NAME = "FirebaseAppHeartBeatStorage";
    private final SharedPreferences sharedPreferences;
    private final SharedPreferences heartBeatSharedPreferences;

    private HeartBeatInfoStorage(Context applicationContext) {
        this.sharedPreferences = applicationContext.getSharedPreferences(PREFERENCES_NAME, 0);
        this.heartBeatSharedPreferences = applicationContext.getSharedPreferences(STORAGE_PREFERENCES_NAME, 0);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    HeartBeatInfoStorage(SharedPreferences preferences, SharedPreferences heartBeatSharedPreferences) {
        this.sharedPreferences = preferences;
        this.heartBeatSharedPreferences = heartBeatSharedPreferences;
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    int getHeartBeatCount() {
        return (int)this.sharedPreferences.getLong(HEART_BEAT_COUNT_TAG, 0L);
    }

    static synchronized HeartBeatInfoStorage getInstance(Context applicationContext) {
        if (instance == null) {
            instance = new HeartBeatInfoStorage(applicationContext);
        }
        return instance;
    }

    synchronized void storeHeartBeatInformation(String heartBeatTag, long millis) {
        long heartBeatCount = this.sharedPreferences.getLong(HEART_BEAT_COUNT_TAG, 0L);
        this.heartBeatSharedPreferences.edit().putString(String.valueOf(millis), heartBeatTag).apply();
        this.sharedPreferences.edit().putLong(HEART_BEAT_COUNT_TAG, heartBeatCount + 1L).apply();
        if (++heartBeatCount > 200L) {
            this.cleanUpStoredHeartBeats();
        }
    }

    private synchronized void cleanUpStoredHeartBeats() {
        long heartBeatCount = this.sharedPreferences.getLong(HEART_BEAT_COUNT_TAG, 0L);
        ArrayList<Long> timestampList = new ArrayList<Long>();
        for (Map.Entry entry : this.heartBeatSharedPreferences.getAll().entrySet()) {
            timestampList.add(Long.parseLong((String)entry.getKey()));
        }
        Collections.sort(timestampList);
        for (Long millis : timestampList) {
            this.heartBeatSharedPreferences.edit().remove(String.valueOf(millis)).apply();
            this.sharedPreferences.edit().putLong(HEART_BEAT_COUNT_TAG, heartBeatCount - 1L).apply();
            if (--heartBeatCount > 100L) continue;
            return;
        }
    }

    synchronized long getLastGlobalHeartBeat() {
        return this.sharedPreferences.getLong(GLOBAL, -1L);
    }

    synchronized void updateGlobalHeartBeat(long millis) {
        this.sharedPreferences.edit().putLong(GLOBAL, millis).apply();
    }

    synchronized List<SdkHeartBeatResult> getStoredHeartBeats(boolean shouldClear) {
        ArrayList<SdkHeartBeatResult> sdkHeartBeatResults = new ArrayList<SdkHeartBeatResult>();
        for (Map.Entry entry : this.heartBeatSharedPreferences.getAll().entrySet()) {
            long millis = Long.parseLong((String)entry.getKey());
            String sdkName = (String)entry.getValue();
            sdkHeartBeatResults.add(SdkHeartBeatResult.create(sdkName, millis));
        }
        Collections.sort(sdkHeartBeatResults);
        if (shouldClear) {
            this.clearStoredHeartBeats();
        }
        return sdkHeartBeatResults;
    }

    synchronized void clearStoredHeartBeats() {
        this.heartBeatSharedPreferences.edit().clear().apply();
        this.sharedPreferences.edit().remove(HEART_BEAT_COUNT_TAG).apply();
    }

    static boolean isSameDateUtc(long base, long target) {
        Date baseDate = new Date(base);
        Date targetDate = new Date(target);
        return !FORMATTER.format(baseDate).equals(FORMATTER.format(targetDate));
    }

    synchronized boolean shouldSendSdkHeartBeat(String heartBeatTag, long millis) {
        if (this.sharedPreferences.contains(heartBeatTag)) {
            if (HeartBeatInfoStorage.isSameDateUtc(this.sharedPreferences.getLong(heartBeatTag, -1L), millis)) {
                this.sharedPreferences.edit().putLong(heartBeatTag, millis).apply();
                return true;
            }
            return false;
        }
        this.sharedPreferences.edit().putLong(heartBeatTag, millis).apply();
        return true;
    }

    synchronized boolean shouldSendGlobalHeartBeat(long millis) {
        return this.shouldSendSdkHeartBeat(GLOBAL, millis);
    }
}

