/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.concurrent;

import androidx.annotation.VisibleForTesting;
import com.google.firebase.concurrent.PausableExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

final class PausableExecutorImpl
implements PausableExecutor {
    private volatile boolean paused;
    private final Executor delegate;
    @VisibleForTesting
    final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();

    PausableExecutorImpl(boolean paused, Executor delegate) {
        this.paused = paused;
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        this.queue.offer(command);
        this.maybeEnqueueNext();
    }

    private void maybeEnqueueNext() {
        if (this.paused) {
            return;
        }
        Runnable next = this.queue.poll();
        while (next != null) {
            this.delegate.execute(next);
            if (!this.paused) {
                next = this.queue.poll();
                continue;
            }
            next = null;
        }
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
        this.maybeEnqueueNext();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }
}

