/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.heartbeatinfo.HeartBeatResult;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class HeartBeatInfoStorage {
    private static HeartBeatInfoStorage instance = null;
    private static final String GLOBAL = "fire-global";
    private static final String PREFERENCES_NAME = "FirebaseAppHeartBeat";
    private static final String HEARTBEAT_PREFERENCES_NAME = "FirebaseHeartBeat";
    private static final String HEART_BEAT_COUNT_TAG = "fire-count";
    private static final String LAST_STORED_DATE = "last-used-date";
    private static final int HEART_BEAT_COUNT_LIMIT = 30;
    private final SharedPreferences firebaseSharedPreferences;

    public HeartBeatInfoStorage(Context applicationContext, String persistenceKey) {
        this.firebaseSharedPreferences = applicationContext.getSharedPreferences(HEARTBEAT_PREFERENCES_NAME + persistenceKey, 0);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    HeartBeatInfoStorage(SharedPreferences firebaseSharedPreferences) {
        this.firebaseSharedPreferences = firebaseSharedPreferences;
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    int getHeartBeatCount() {
        return (int)this.firebaseSharedPreferences.getLong(HEART_BEAT_COUNT_TAG, 0L);
    }

    synchronized void deleteAllHeartBeats() {
        SharedPreferences.Editor editor = this.firebaseSharedPreferences.edit();
        int counter = 0;
        for (Map.Entry entry : this.firebaseSharedPreferences.getAll().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            Set dates = (Set)entry.getValue();
            String today = this.getFormattedDate(System.currentTimeMillis());
            String key = (String)entry.getKey();
            if (dates.contains(today)) {
                HashSet<String> userAgentDateSet = new HashSet<String>();
                userAgentDateSet.add(today);
                ++counter;
                editor.putStringSet(key, userAgentDateSet);
                continue;
            }
            editor.remove(key);
        }
        if (counter == 0) {
            editor.remove(HEART_BEAT_COUNT_TAG);
        } else {
            editor.putLong(HEART_BEAT_COUNT_TAG, (long)counter);
        }
        editor.commit();
    }

    synchronized List<HeartBeatResult> getAllHeartBeats() {
        ArrayList<HeartBeatResult> heartBeatResults = new ArrayList<HeartBeatResult>();
        for (Map.Entry entry : this.firebaseSharedPreferences.getAll().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            HashSet dates = new HashSet((Set)entry.getValue());
            String today = this.getFormattedDate(System.currentTimeMillis());
            dates.remove(today);
            if (dates.isEmpty()) continue;
            heartBeatResults.add(HeartBeatResult.create((String)entry.getKey(), new ArrayList<String>(dates)));
        }
        this.updateGlobalHeartBeat(System.currentTimeMillis());
        return heartBeatResults;
    }

    private synchronized String getStoredUserAgentString(String dateString) {
        for (Map.Entry entry : this.firebaseSharedPreferences.getAll().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            Set dateSet = (Set)entry.getValue();
            for (String date : dateSet) {
                if (!dateString.equals(date)) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    private synchronized void updateStoredUserAgent(String userAgent, String dateString) {
        this.removeStoredDate(dateString);
        HashSet<String> userAgentDateSet = new HashSet<String>(this.firebaseSharedPreferences.getStringSet(userAgent, new HashSet()));
        userAgentDateSet.add(dateString);
        this.firebaseSharedPreferences.edit().putStringSet(userAgent, userAgentDateSet).commit();
    }

    private synchronized void removeStoredDate(String dateString) {
        String userAgentString = this.getStoredUserAgentString(dateString);
        if (userAgentString == null) {
            return;
        }
        HashSet userAgentDateSet = new HashSet(this.firebaseSharedPreferences.getStringSet(userAgentString, new HashSet()));
        userAgentDateSet.remove(dateString);
        if (userAgentDateSet.isEmpty()) {
            this.firebaseSharedPreferences.edit().remove(userAgentString).commit();
        } else {
            this.firebaseSharedPreferences.edit().putStringSet(userAgentString, userAgentDateSet).commit();
        }
    }

    synchronized void postHeartBeatCleanUp() {
        String dateString = this.getFormattedDate(System.currentTimeMillis());
        this.firebaseSharedPreferences.edit().putString(LAST_STORED_DATE, dateString).commit();
        this.removeStoredDate(dateString);
    }

    private synchronized String getFormattedDate(long millis) {
        if (Build.VERSION.SDK_INT >= 26) {
            Instant instant = new Date(millis).toInstant();
            LocalDateTime ldt = instant.atOffset(ZoneOffset.UTC).toLocalDateTime();
            return ldt.format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        return new SimpleDateFormat("yyyy-MM-dd", Locale.UK).format(new Date(millis));
    }

    synchronized void storeHeartBeat(long millis, String userAgentString) {
        String dateString = this.getFormattedDate(millis);
        String lastDateString = this.firebaseSharedPreferences.getString(LAST_STORED_DATE, "");
        if (lastDateString.equals(dateString)) {
            String storedUserAgentString = this.getStoredUserAgentString(dateString);
            if (storedUserAgentString == null) {
                return;
            }
            if (storedUserAgentString.equals(userAgentString)) {
                return;
            }
            this.updateStoredUserAgent(userAgentString, dateString);
            return;
        }
        long heartBeatCount = this.firebaseSharedPreferences.getLong(HEART_BEAT_COUNT_TAG, 0L);
        if (heartBeatCount + 1L == 30L) {
            this.cleanUpStoredHeartBeats();
            heartBeatCount = this.firebaseSharedPreferences.getLong(HEART_BEAT_COUNT_TAG, 0L);
        }
        HashSet<String> userAgentDateSet = new HashSet<String>(this.firebaseSharedPreferences.getStringSet(userAgentString, new HashSet()));
        userAgentDateSet.add(dateString);
        this.firebaseSharedPreferences.edit().putStringSet(userAgentString, userAgentDateSet).putLong(HEART_BEAT_COUNT_TAG, ++heartBeatCount).putString(LAST_STORED_DATE, dateString).commit();
    }

    private synchronized void cleanUpStoredHeartBeats() {
        long heartBeatCount = this.firebaseSharedPreferences.getLong(HEART_BEAT_COUNT_TAG, 0L);
        String lowestDate = null;
        String userAgentString = "";
        for (Map.Entry entry : this.firebaseSharedPreferences.getAll().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            Set dateSet = (Set)entry.getValue();
            for (String date : dateSet) {
                if (lowestDate != null && lowestDate.compareTo(date) <= 0) continue;
                lowestDate = date;
                userAgentString = (String)entry.getKey();
            }
        }
        HashSet userAgentDateSet = new HashSet(this.firebaseSharedPreferences.getStringSet(userAgentString, new HashSet()));
        userAgentDateSet.remove(lowestDate);
        this.firebaseSharedPreferences.edit().putStringSet(userAgentString, userAgentDateSet).putLong(HEART_BEAT_COUNT_TAG, heartBeatCount - 1L).commit();
    }

    synchronized long getLastGlobalHeartBeat() {
        return this.firebaseSharedPreferences.getLong(GLOBAL, -1L);
    }

    synchronized void updateGlobalHeartBeat(long millis) {
        this.firebaseSharedPreferences.edit().putLong(GLOBAL, millis).commit();
    }

    synchronized boolean isSameDateUtc(long base, long target) {
        return this.getFormattedDate(base).equals(this.getFormattedDate(target));
    }

    synchronized boolean shouldSendSdkHeartBeat(String heartBeatTag, long millis) {
        if (this.firebaseSharedPreferences.contains(heartBeatTag)) {
            if (!this.isSameDateUtc(this.firebaseSharedPreferences.getLong(heartBeatTag, -1L), millis)) {
                this.firebaseSharedPreferences.edit().putLong(heartBeatTag, millis).commit();
                return true;
            }
            return false;
        }
        this.firebaseSharedPreferences.edit().putLong(heartBeatTag, millis).commit();
        return true;
    }

    synchronized boolean shouldSendGlobalHeartBeat(long millis) {
        return this.shouldSendSdkHeartBeat(GLOBAL, millis);
    }
}

