/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.concurrent;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.StrictMode;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Lazy;
import com.google.firebase.components.Qualified;
import com.google.firebase.concurrent.CustomThreadFactory;
import com.google.firebase.concurrent.DelegatingScheduledExecutorService;
import com.google.firebase.concurrent.UiExecutor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

@SuppressLint(value={"ThreadPoolCreation"})
public class ExecutorsRegistrar
implements ComponentRegistrar {
    static final Lazy<ScheduledExecutorService> BG_EXECUTOR = new Lazy(() -> ExecutorsRegistrar.scheduled(Executors.newFixedThreadPool(4, ExecutorsRegistrar.factory("Firebase Background", 10, ExecutorsRegistrar.bgPolicy()))));
    static final Lazy<ScheduledExecutorService> LITE_EXECUTOR = new Lazy(() -> ExecutorsRegistrar.scheduled(Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()), ExecutorsRegistrar.factory("Firebase Lite", 0, ExecutorsRegistrar.litePolicy()))));
    static final Lazy<ScheduledExecutorService> BLOCKING_EXECUTOR = new Lazy(() -> ExecutorsRegistrar.scheduled(Executors.newCachedThreadPool(ExecutorsRegistrar.factory("Firebase Blocking", 11))));
    static final Lazy<ScheduledExecutorService> SCHEDULER = new Lazy(() -> Executors.newSingleThreadScheduledExecutor(ExecutorsRegistrar.factory("Firebase Scheduler", 0)));

    public List<Component<?>> getComponents() {
        return Arrays.asList(Component.builder((Qualified)Qualified.qualified(Background.class, ScheduledExecutorService.class), (Qualified[])new Qualified[]{Qualified.qualified(Background.class, ExecutorService.class), Qualified.qualified(Background.class, Executor.class)}).factory(c -> (ScheduledExecutorService)BG_EXECUTOR.get()).build(), Component.builder((Qualified)Qualified.qualified(Blocking.class, ScheduledExecutorService.class), (Qualified[])new Qualified[]{Qualified.qualified(Blocking.class, ExecutorService.class), Qualified.qualified(Blocking.class, Executor.class)}).factory(c -> (ScheduledExecutorService)BLOCKING_EXECUTOR.get()).build(), Component.builder((Qualified)Qualified.qualified(Lightweight.class, ScheduledExecutorService.class), (Qualified[])new Qualified[]{Qualified.qualified(Lightweight.class, ExecutorService.class), Qualified.qualified(Lightweight.class, Executor.class)}).factory(c -> (ScheduledExecutorService)LITE_EXECUTOR.get()).build(), Component.builder((Qualified)Qualified.qualified(UiThread.class, Executor.class)).factory(c -> UiExecutor.INSTANCE).build());
    }

    private static ScheduledExecutorService scheduled(ExecutorService delegate) {
        return new DelegatingScheduledExecutorService(delegate, (ScheduledExecutorService)SCHEDULER.get());
    }

    private static ThreadFactory factory(String threadPrefix, int priority) {
        return new CustomThreadFactory(threadPrefix, priority, null);
    }

    private static ThreadFactory factory(String threadPrefix, int priority, StrictMode.ThreadPolicy policy) {
        return new CustomThreadFactory(threadPrefix, priority, policy);
    }

    private static StrictMode.ThreadPolicy bgPolicy() {
        StrictMode.ThreadPolicy.Builder builder = new StrictMode.ThreadPolicy.Builder().detectNetwork();
        if (Build.VERSION.SDK_INT >= 23) {
            builder.detectResourceMismatches();
            if (Build.VERSION.SDK_INT >= 26) {
                builder.detectUnbufferedIo();
            }
        }
        return builder.penaltyLog().build();
    }

    private static StrictMode.ThreadPolicy litePolicy() {
        StrictMode.ThreadPolicy.Builder builder = new StrictMode.ThreadPolicy.Builder().detectAll();
        return builder.penaltyLog().build();
    }
}

