/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.components.Component$$Lambda$1;
import com.google.firebase.components.Component$$Lambda$2;
import com.google.firebase.components.Component$$Lambda$3;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentFactory;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Component<T> {
    private final Set<Class<? super T>> providedInterfaces;
    private final Set<Dependency> dependencies;
    private final int instantiation;
    private final int type;
    private final ComponentFactory<T> factory;
    private final Set<Class<?>> publishedEvents;

    private Component(Set<Class<? super T>> providedInterfaces, Set<Dependency> dependencies, int instantiation, int type, ComponentFactory<T> factory, Set<Class<?>> publishedEvents) {
        this.providedInterfaces = Collections.unmodifiableSet(providedInterfaces);
        this.dependencies = Collections.unmodifiableSet(dependencies);
        this.instantiation = instantiation;
        this.type = type;
        this.factory = factory;
        this.publishedEvents = Collections.unmodifiableSet(publishedEvents);
    }

    public Set<Class<? super T>> getProvidedInterfaces() {
        return this.providedInterfaces;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public ComponentFactory<T> getFactory() {
        return this.factory;
    }

    public Set<Class<?>> getPublishedEvents() {
        return this.publishedEvents;
    }

    public boolean isLazy() {
        return this.instantiation == 0;
    }

    public boolean isAlwaysEager() {
        return this.instantiation == 1;
    }

    public boolean isEagerInDefaultApp() {
        return this.instantiation == 2;
    }

    public boolean isValue() {
        return this.type == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Component<").append(Arrays.toString(this.providedInterfaces.toArray())).append(">{").append(this.instantiation).append(", type=").append(this.type).append(", deps=").append(Arrays.toString(this.dependencies.toArray())).append("}");
        return sb.toString();
    }

    public static <T> Builder<T> builder(Class<T> anInterface) {
        return new Builder((Class)anInterface, new Class[0]);
    }

    @SafeVarargs
    public static <T> Builder<T> builder(Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
        return new Builder((Class)anInterface, (Class[])additionalInterfaces);
    }

    @Deprecated
    public static <T> Component<T> of(Class<T> anInterface, T value) {
        return Component.builder(anInterface).factory(Component$$Lambda$1.lambdaFactory$(value)).build();
    }

    @SafeVarargs
    public static <T> Component<T> of(T value, Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
        return Component.builder(anInterface, additionalInterfaces).factory(Component$$Lambda$2.lambdaFactory$(value)).build();
    }

    public static <T> Builder<T> intoSetBuilder(Class<T> anInterface) {
        return ((Builder)Component.builder(anInterface)).intoSet();
    }

    public static <T> Component<T> intoSet(T value, Class<T> anInterface) {
        return Component.intoSetBuilder(anInterface).factory(Component$$Lambda$3.lambdaFactory$(value)).build();
    }

    static /* synthetic */ Object lambda$intoSet$2(Object value, ComponentContainer c) {
        return value;
    }

    static /* synthetic */ Object lambda$of$1(Object value, ComponentContainer args) {
        return value;
    }

    static /* synthetic */ Object lambda$of$0(Object value, ComponentContainer args) {
        return value;
    }

    public static class Builder<T> {
        private final Set<Class<? super T>> providedInterfaces = new HashSet<Class<? super T>>();
        private final Set<Dependency> dependencies = new HashSet<Dependency>();
        private int instantiation = 0;
        private int type = 0;
        private ComponentFactory<T> factory;
        private Set<Class<?>> publishedEvents = new HashSet();

        @SafeVarargs
        private Builder(Class<T> anInterface, Class<? super T> ... additionalInterfaces) {
            Preconditions.checkNotNull(anInterface, "Null interface");
            this.providedInterfaces.add(anInterface);
            for (Class<? super T> iface : additionalInterfaces) {
                Preconditions.checkNotNull(iface, "Null interface");
            }
            Collections.addAll(this.providedInterfaces, additionalInterfaces);
        }

        public Builder<T> add(Dependency dependency) {
            Preconditions.checkNotNull(dependency, "Null dependency");
            this.validateInterface(dependency.getInterface());
            this.dependencies.add(dependency);
            return this;
        }

        public Builder<T> alwaysEager() {
            return this.setInstantiation(1);
        }

        public Builder<T> eagerInDefaultApp() {
            return this.setInstantiation(2);
        }

        public Builder<T> publishes(Class<?> eventType) {
            this.publishedEvents.add(eventType);
            return this;
        }

        private Builder<T> setInstantiation(int instantiation) {
            Preconditions.checkState(this.instantiation == 0, "Instantiation type has already been set.");
            this.instantiation = instantiation;
            return this;
        }

        private void validateInterface(Class<?> anInterface) {
            Preconditions.checkArgument(!this.providedInterfaces.contains(anInterface), "Components are not allowed to depend on interfaces they themselves provide.");
        }

        public Builder<T> factory(ComponentFactory<T> value) {
            this.factory = Preconditions.checkNotNull(value, "Null factory");
            return this;
        }

        private Builder<T> intoSet() {
            this.type = 1;
            return this;
        }

        public Component<T> build() {
            Preconditions.checkState(this.factory != null, "Missing required property: factory.");
            return new Component(new HashSet<Class<? super T>>(this.providedInterfaces), new HashSet<Dependency>(this.dependencies), this.instantiation, this.type, this.factory, this.publishedEvents);
        }
    }
}

