/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.components.Preconditions;

public final class Dependency {
    private final Class<?> anInterface;
    private final int type;
    private final int injection;

    private Dependency(Class<?> anInterface, int type, int injection) {
        this.anInterface = Preconditions.checkNotNull(anInterface, "Null dependency anInterface.");
        this.type = type;
        this.injection = injection;
    }

    public static Dependency optional(Class<?> anInterface) {
        return new Dependency(anInterface, 0, 0);
    }

    public static Dependency required(Class<?> anInterface) {
        return new Dependency(anInterface, 1, 0);
    }

    public static Dependency setOf(Class<?> anInterface) {
        return new Dependency(anInterface, 2, 0);
    }

    public static Dependency optionalProvider(Class<?> anInterface) {
        return new Dependency(anInterface, 0, 1);
    }

    public static Dependency requiredProvider(Class<?> anInterface) {
        return new Dependency(anInterface, 1, 1);
    }

    public static Dependency setOfProvider(Class<?> anInterface) {
        return new Dependency(anInterface, 2, 1);
    }

    public Class<?> getInterface() {
        return this.anInterface;
    }

    public boolean isRequired() {
        return this.type == 1;
    }

    public boolean isSet() {
        return this.type == 2;
    }

    public boolean isDirectInjection() {
        return this.injection == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof Dependency) {
            Dependency other = (Dependency)o;
            return this.anInterface == other.anInterface && this.type == other.type && this.injection == other.injection;
        }
        return false;
    }

    public int hashCode() {
        int h = 1000003;
        h ^= this.anInterface.hashCode();
        h *= 1000003;
        h ^= this.type;
        h *= 1000003;
        return h ^= this.injection;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Dependency{anInterface=").append(this.anInterface).append(", type=").append(this.type == 1 ? "required" : (this.type == 0 ? "optional" : "set")).append(", direct=").append(this.injection == 0).append("}");
        return sb.toString();
    }
}

