/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.ComponentRegistrarProcessor;
import com.google.firebase.components.CycleDetector;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.EventBus;
import com.google.firebase.components.InvalidRegistrarException;
import com.google.firebase.components.Lazy;
import com.google.firebase.components.LazySet;
import com.google.firebase.components.MissingDependencyException;
import com.google.firebase.components.OptionalProvider;
import com.google.firebase.components.Preconditions;
import com.google.firebase.components.Qualified;
import com.google.firebase.components.RestrictedComponentContainer;
import com.google.firebase.dynamicloading.ComponentLoader;
import com.google.firebase.events.Publisher;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public class ComponentRuntime
implements ComponentContainer,
ComponentLoader {
    private static final Provider<Set<Object>> EMPTY_PROVIDER = Collections::emptySet;
    private final Map<Component<?>, Provider<?>> components = new HashMap();
    private final Map<Qualified<?>, Provider<?>> lazyInstanceMap = new HashMap();
    private final Map<Qualified<?>, LazySet<?>> lazySetMap = new HashMap();
    private final List<Provider<ComponentRegistrar>> unprocessedRegistrarProviders;
    private final EventBus eventBus;
    private final AtomicReference<Boolean> eagerComponentsInitializedWith = new AtomicReference();
    private final ComponentRegistrarProcessor componentRegistrarProcessor;

    @Deprecated
    public ComponentRuntime(Executor defaultEventExecutor, Iterable<ComponentRegistrar> registrars, Component<?> ... additionalComponents) {
        this(defaultEventExecutor, ComponentRuntime.toProviders(registrars), Arrays.asList(additionalComponents), ComponentRegistrarProcessor.NOOP);
    }

    public static Builder builder(Executor defaultEventExecutor) {
        return new Builder(defaultEventExecutor);
    }

    private ComponentRuntime(Executor defaultEventExecutor, Iterable<Provider<ComponentRegistrar>> registrars, Collection<Component<?>> additionalComponents, ComponentRegistrarProcessor componentRegistrarProcessor) {
        this.eventBus = new EventBus(defaultEventExecutor);
        this.componentRegistrarProcessor = componentRegistrarProcessor;
        ArrayList componentsToAdd = new ArrayList();
        componentsToAdd.add(Component.of(this.eventBus, EventBus.class, Subscriber.class, Publisher.class));
        componentsToAdd.add(Component.of(this, ComponentLoader.class, new Class[0]));
        for (Component<?> additionalComponent : additionalComponents) {
            if (additionalComponent == null) continue;
            componentsToAdd.add(additionalComponent);
        }
        this.unprocessedRegistrarProviders = ComponentRuntime.iterableToList(registrars);
        this.discoverComponents(componentsToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverComponents(List<Component<?>> componentsToAdd) {
        ArrayList<Runnable> runAfterDiscovery = new ArrayList<Runnable>();
        ComponentRuntime componentRuntime = this;
        synchronized (componentRuntime) {
            Iterator<Provider<ComponentRegistrar>> iterator = this.unprocessedRegistrarProviders.iterator();
            while (iterator.hasNext()) {
                Provider<ComponentRegistrar> provider = iterator.next();
                try {
                    ComponentRegistrar registrar = provider.get();
                    if (registrar == null) continue;
                    componentsToAdd.addAll(this.componentRegistrarProcessor.processRegistrar(registrar));
                    iterator.remove();
                }
                catch (InvalidRegistrarException ex) {
                    iterator.remove();
                    Log.w((String)"ComponentDiscovery", (String)"Invalid component registrar.", (Throwable)ex);
                }
            }
            if (this.components.isEmpty()) {
                CycleDetector.detect(componentsToAdd);
            } else {
                ArrayList allComponents = new ArrayList(this.components.keySet());
                allComponents.addAll(componentsToAdd);
                CycleDetector.detect(allComponents);
            }
            for (Component<?> component : componentsToAdd) {
                Lazy<Object> lazy = new Lazy<Object>(() -> component.getFactory().create(new RestrictedComponentContainer(component, this)));
                this.components.put(component, lazy);
            }
            runAfterDiscovery.addAll(this.processInstanceComponents(componentsToAdd));
            runAfterDiscovery.addAll(this.processSetComponents());
            this.processDependencies();
        }
        for (Runnable runnable : runAfterDiscovery) {
            runnable.run();
        }
        this.maybeInitializeEagerComponents();
    }

    private void maybeInitializeEagerComponents() {
        Boolean isDefaultApp = this.eagerComponentsInitializedWith.get();
        if (isDefaultApp != null) {
            this.doInitializeEagerComponents(this.components, isDefaultApp);
        }
    }

    private static Iterable<Provider<ComponentRegistrar>> toProviders(Iterable<ComponentRegistrar> registrars) {
        ArrayList<Provider<ComponentRegistrar>> result = new ArrayList<Provider<ComponentRegistrar>>();
        for (ComponentRegistrar registrar : registrars) {
            result.add(() -> registrar);
        }
        return result;
    }

    private static <T> List<T> iterableToList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : iterable) {
            result.add(item);
        }
        return result;
    }

    private List<Runnable> processInstanceComponents(List<Component<?>> componentsToProcess) {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (Component<?> component : componentsToProcess) {
            if (!component.isValue()) continue;
            Provider<?> provider = this.components.get(component);
            for (Qualified<?> anInterface : component.getProvidedInterfaces()) {
                if (!this.lazyInstanceMap.containsKey(anInterface)) {
                    this.lazyInstanceMap.put(anInterface, provider);
                    continue;
                }
                Provider<?> existingProvider = this.lazyInstanceMap.get(anInterface);
                OptionalProvider deferred = (OptionalProvider)existingProvider;
                Provider<?> castedProvider = provider;
                runnables.add(() -> deferred.set(castedProvider));
            }
        }
        return runnables;
    }

    private List<Runnable> processSetComponents() {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        HashMap setIndex = new HashMap();
        for (Map.Entry<Component<?>, Provider<?>> entry : this.components.entrySet()) {
            Component<?> component = entry.getKey();
            if (component.isValue()) continue;
            Provider<?> provider = entry.getValue();
            for (Qualified<?> anInterface : component.getProvidedInterfaces()) {
                if (!setIndex.containsKey(anInterface)) {
                    setIndex.put(anInterface, new HashSet());
                }
                ((Set)setIndex.get(anInterface)).add(provider);
            }
        }
        for (Map.Entry<Component<Object>, Provider<Object>> entry : setIndex.entrySet()) {
            if (!this.lazySetMap.containsKey(entry.getKey())) {
                this.lazySetMap.put((Qualified)((Object)entry.getKey()), LazySet.fromCollection((Collection)((Object)entry.getValue())));
                continue;
            }
            LazySet<?> existingSet = this.lazySetMap.get(entry.getKey());
            Iterator iterator = ((Set)((Object)entry.getValue())).iterator();
            while (iterator.hasNext()) {
                Provider provider;
                Provider castedProvider = provider = (Provider)iterator.next();
                runnables.add(() -> existingSet.add(castedProvider));
            }
        }
        return runnables;
    }

    @Override
    public synchronized <T> Provider<T> getProvider(Qualified<T> anInterface) {
        Preconditions.checkNotNull(anInterface, "Null interface requested.");
        return this.lazyInstanceMap.get(anInterface);
    }

    @Override
    public <T> Deferred<T> getDeferred(Qualified<T> anInterface) {
        Provider<T> provider = this.getProvider(anInterface);
        if (provider == null) {
            return OptionalProvider.empty();
        }
        if (provider instanceof OptionalProvider) {
            return (OptionalProvider)provider;
        }
        return OptionalProvider.of(provider);
    }

    @Override
    public synchronized <T> Provider<Set<T>> setOfProvider(Qualified<T> anInterface) {
        LazySet<?> provider = this.lazySetMap.get(anInterface);
        if (provider != null) {
            return provider;
        }
        return EMPTY_PROVIDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeEagerComponents(boolean isDefaultApp) {
        HashMap componentsCopy;
        if (!this.eagerComponentsInitializedWith.compareAndSet(null, isDefaultApp)) {
            return;
        }
        ComponentRuntime componentRuntime = this;
        synchronized (componentRuntime) {
            componentsCopy = new HashMap(this.components);
        }
        this.doInitializeEagerComponents(componentsCopy, isDefaultApp);
    }

    private void doInitializeEagerComponents(Map<Component<?>, Provider<?>> componentsToInitialize, boolean isDefaultApp) {
        for (Map.Entry<Component<?>, Provider<?>> entry : componentsToInitialize.entrySet()) {
            Component<?> component = entry.getKey();
            Provider<?> provider = entry.getValue();
            if (!component.isAlwaysEager() && (!component.isEagerInDefaultApp() || !isDefaultApp)) continue;
            provider.get();
        }
        this.eventBus.enablePublishingAndFlushPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discoverComponents() {
        ComponentRuntime componentRuntime = this;
        synchronized (componentRuntime) {
            if (this.unprocessedRegistrarProviders.isEmpty()) {
                return;
            }
        }
        this.discoverComponents(new ArrayList());
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public void initializeAllComponentsForTests() {
        for (Provider<?> component : this.components.values()) {
            component.get();
        }
    }

    private void processDependencies() {
        for (Component<?> component : this.components.keySet()) {
            for (Dependency dependency : component.getDependencies()) {
                if (dependency.isSet() && !this.lazySetMap.containsKey(dependency.getInterface())) {
                    this.lazySetMap.put(dependency.getInterface(), LazySet.fromCollection(Collections.emptySet()));
                    continue;
                }
                if (this.lazyInstanceMap.containsKey(dependency.getInterface())) continue;
                if (dependency.isRequired()) {
                    throw new MissingDependencyException(String.format("Unsatisfied dependency for component %s: %s", component, dependency.getInterface()));
                }
                if (dependency.isSet()) continue;
                this.lazyInstanceMap.put(dependency.getInterface(), OptionalProvider.empty());
            }
        }
    }

    @VisibleForTesting
    Collection<Component<?>> getAllComponentsForTest() {
        return this.components.keySet();
    }

    public static final class Builder {
        private final Executor defaultExecutor;
        private final List<Provider<ComponentRegistrar>> lazyRegistrars = new ArrayList<Provider<ComponentRegistrar>>();
        private final List<Component<?>> additionalComponents = new ArrayList();
        private ComponentRegistrarProcessor componentRegistrarProcessor = ComponentRegistrarProcessor.NOOP;

        Builder(Executor defaultExecutor) {
            this.defaultExecutor = defaultExecutor;
        }

        @CanIgnoreReturnValue
        public Builder addLazyComponentRegistrars(Collection<Provider<ComponentRegistrar>> registrars) {
            this.lazyRegistrars.addAll(registrars);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponentRegistrar(ComponentRegistrar registrar) {
            this.lazyRegistrars.add(() -> registrar);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(Component<?> component) {
            this.additionalComponents.add(component);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setProcessor(ComponentRegistrarProcessor processor) {
            this.componentRegistrarProcessor = processor;
            return this;
        }

        public ComponentRuntime build() {
            return new ComponentRuntime(this.defaultExecutor, this.lazyRegistrars, this.additionalComponents, this.componentRegistrarProcessor);
        }
    }
}

