/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.DependencyException;
import com.google.firebase.components.Qualified;
import com.google.firebase.events.Event;
import com.google.firebase.events.Publisher;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class RestrictedComponentContainer
implements ComponentContainer {
    private final Set<Qualified<?>> allowedDirectInterfaces;
    private final Set<Qualified<?>> allowedProviderInterfaces;
    private final Set<Qualified<?>> allowedDeferredInterfaces;
    private final Set<Qualified<?>> allowedSetDirectInterfaces;
    private final Set<Qualified<?>> allowedSetProviderInterfaces;
    private final Set<Class<?>> allowedPublishedEvents;
    private final ComponentContainer delegateContainer;

    RestrictedComponentContainer(Component<?> component, ComponentContainer container) {
        HashSet directInterfaces = new HashSet();
        HashSet providerInterfaces = new HashSet();
        HashSet deferredInterfaces = new HashSet();
        HashSet setDirectInterfaces = new HashSet();
        HashSet setProviderInterfaces = new HashSet();
        for (Dependency dependency : component.getDependencies()) {
            if (dependency.isDirectInjection()) {
                if (dependency.isSet()) {
                    setDirectInterfaces.add(dependency.getInterface());
                    continue;
                }
                directInterfaces.add(dependency.getInterface());
                continue;
            }
            if (dependency.isDeferred()) {
                deferredInterfaces.add(dependency.getInterface());
                continue;
            }
            if (dependency.isSet()) {
                setProviderInterfaces.add(dependency.getInterface());
                continue;
            }
            providerInterfaces.add(dependency.getInterface());
        }
        if (!component.getPublishedEvents().isEmpty()) {
            directInterfaces.add(Qualified.unqualified(Publisher.class));
        }
        this.allowedDirectInterfaces = Collections.unmodifiableSet(directInterfaces);
        this.allowedProviderInterfaces = Collections.unmodifiableSet(providerInterfaces);
        this.allowedDeferredInterfaces = Collections.unmodifiableSet(deferredInterfaces);
        this.allowedSetDirectInterfaces = Collections.unmodifiableSet(setDirectInterfaces);
        this.allowedSetProviderInterfaces = Collections.unmodifiableSet(setProviderInterfaces);
        this.allowedPublishedEvents = component.getPublishedEvents();
        this.delegateContainer = container;
    }

    @Override
    public <T> T get(Class<T> anInterface) {
        if (!this.allowedDirectInterfaces.contains(Qualified.unqualified(anInterface))) {
            throw new DependencyException(String.format("Attempting to request an undeclared dependency %s.", anInterface));
        }
        T value = this.delegateContainer.get(anInterface);
        if (!anInterface.equals(Publisher.class)) {
            return value;
        }
        RestrictedPublisher publisher = new RestrictedPublisher(this.allowedPublishedEvents, (Publisher)value);
        return (T)publisher;
    }

    @Override
    public <T> T get(Qualified<T> anInterface) {
        if (!this.allowedDirectInterfaces.contains(anInterface)) {
            throw new DependencyException(String.format("Attempting to request an undeclared dependency %s.", anInterface));
        }
        return this.delegateContainer.get(anInterface);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> anInterface) {
        return this.getProvider(Qualified.unqualified(anInterface));
    }

    @Override
    public <T> Deferred<T> getDeferred(Class<T> anInterface) {
        return this.getDeferred(Qualified.unqualified(anInterface));
    }

    @Override
    public <T> Provider<Set<T>> setOfProvider(Class<T> anInterface) {
        return this.setOfProvider(Qualified.unqualified(anInterface));
    }

    @Override
    public <T> Provider<T> getProvider(Qualified<T> anInterface) {
        if (!this.allowedProviderInterfaces.contains(anInterface)) {
            throw new DependencyException(String.format("Attempting to request an undeclared dependency Provider<%s>.", anInterface));
        }
        return this.delegateContainer.getProvider(anInterface);
    }

    @Override
    public <T> Deferred<T> getDeferred(Qualified<T> anInterface) {
        if (!this.allowedDeferredInterfaces.contains(anInterface)) {
            throw new DependencyException(String.format("Attempting to request an undeclared dependency Deferred<%s>.", anInterface));
        }
        return this.delegateContainer.getDeferred(anInterface);
    }

    @Override
    public <T> Provider<Set<T>> setOfProvider(Qualified<T> anInterface) {
        if (!this.allowedSetProviderInterfaces.contains(anInterface)) {
            throw new DependencyException(String.format("Attempting to request an undeclared dependency Provider<Set<%s>>.", anInterface));
        }
        return this.delegateContainer.setOfProvider(anInterface);
    }

    @Override
    public <T> Set<T> setOf(Qualified<T> anInterface) {
        if (!this.allowedSetDirectInterfaces.contains(anInterface)) {
            throw new DependencyException(String.format("Attempting to request an undeclared dependency Set<%s>.", anInterface));
        }
        return this.delegateContainer.setOf(anInterface);
    }

    private static class RestrictedPublisher
    implements Publisher {
        private final Set<Class<?>> allowedPublishedEvents;
        private final Publisher delegate;

        public RestrictedPublisher(Set<Class<?>> allowedPublishedEvents, Publisher delegate) {
            this.allowedPublishedEvents = allowedPublishedEvents;
            this.delegate = delegate;
        }

        @Override
        public void publish(Event<?> event) {
            if (!this.allowedPublishedEvents.contains(event.getType())) {
                throw new DependencyException(String.format("Attempting to publish an undeclared event %s.", event));
            }
            this.delegate.publish(event);
        }
    }
}

