/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.components.Component;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.DependencyCycleException;
import com.google.firebase.components.Qualified;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CycleDetector {
    CycleDetector() {
    }

    static void detect(List<Component<?>> components) {
        Set<ComponentNode> graph = CycleDetector.toGraph(components);
        Set<ComponentNode> roots = CycleDetector.getRoots(graph);
        int numVisited = 0;
        while (!roots.isEmpty()) {
            ComponentNode node = roots.iterator().next();
            roots.remove(node);
            ++numVisited;
            for (ComponentNode dependent : node.getDependencies()) {
                dependent.removeDependent(node);
                if (!dependent.isRoot()) continue;
                roots.add(dependent);
            }
        }
        if (numVisited == components.size()) {
            return;
        }
        ArrayList componentsInCycle = new ArrayList();
        for (ComponentNode node : graph) {
            if (node.isRoot() || node.isLeaf()) continue;
            componentsInCycle.add(node.getComponent());
        }
        throw new DependencyCycleException(componentsInCycle);
    }

    private static Set<ComponentNode> toGraph(List<Component<?>> components) {
        HashMap componentIndex = new HashMap(components.size());
        for (Component<?> component : components) {
            ComponentNode node = new ComponentNode(component);
            for (Qualified<?> anInterface : component.getProvidedInterfaces()) {
                Set nodes;
                Dep cmp = new Dep(anInterface, !component.isValue());
                if (!componentIndex.containsKey(cmp)) {
                    componentIndex.put(cmp, new HashSet());
                }
                if (!(nodes = (Set)componentIndex.get(cmp)).isEmpty() && !cmp.set) {
                    throw new IllegalArgumentException(String.format("Multiple components provide %s.", anInterface));
                }
                nodes.add(node);
            }
        }
        for (Set componentNodes : componentIndex.values()) {
            for (ComponentNode node : componentNodes) {
                for (Dependency dependency : node.getComponent().getDependencies()) {
                    Set depComponents;
                    if (!dependency.isDirectInjection() || (depComponents = (Set)componentIndex.get(new Dep(dependency.getInterface(), dependency.isSet()))) == null) continue;
                    for (ComponentNode depComponent : depComponents) {
                        node.addDependency(depComponent);
                        depComponent.addDependent(node);
                    }
                }
            }
        }
        HashSet<ComponentNode> result = new HashSet<ComponentNode>();
        for (Set componentNodes : componentIndex.values()) {
            result.addAll(componentNodes);
        }
        return result;
    }

    private static Set<ComponentNode> getRoots(Set<ComponentNode> components) {
        HashSet<ComponentNode> roots = new HashSet<ComponentNode>();
        for (ComponentNode component : components) {
            if (!component.isRoot()) continue;
            roots.add(component);
        }
        return roots;
    }

    private static class ComponentNode {
        private final Component<?> component;
        private final Set<ComponentNode> dependencies = new HashSet<ComponentNode>();
        private final Set<ComponentNode> dependents = new HashSet<ComponentNode>();

        ComponentNode(Component<?> component) {
            this.component = component;
        }

        void addDependency(ComponentNode node) {
            this.dependencies.add(node);
        }

        void addDependent(ComponentNode node) {
            this.dependents.add(node);
        }

        Set<ComponentNode> getDependencies() {
            return this.dependencies;
        }

        void removeDependent(ComponentNode node) {
            this.dependents.remove(node);
        }

        Component<?> getComponent() {
            return this.component;
        }

        boolean isRoot() {
            return this.dependents.isEmpty();
        }

        boolean isLeaf() {
            return this.dependencies.isEmpty();
        }
    }

    private static class Dep {
        private final Qualified<?> anInterface;
        private final boolean set;

        private Dep(Qualified<?> anInterface, boolean set) {
            this.anInterface = anInterface;
            this.set = set;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Dep) {
                Dep dep = (Dep)obj;
                return dep.anInterface.equals(this.anInterface) && dep.set == this.set;
            }
            return false;
        }

        public int hashCode() {
            int h = 1000003;
            h ^= this.anInterface.hashCode();
            h *= 1000003;
            return h ^= Boolean.valueOf(this.set).hashCode();
        }
    }
}

