/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.StatFs;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.NativeSessionFileProvider;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsReceiver;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.BatteryState;
import com.google.firebase.crashlytics.internal.common.BytesBackedNativeSessionFile;
import com.google.firebase.crashlytics.internal.common.CLSUUID;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsBackgroundWorker;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.common.CrashlyticsFileMarker;
import com.google.firebase.crashlytics.internal.common.CrashlyticsUncaughtExceptionHandler;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.DataTransportState;
import com.google.firebase.crashlytics.internal.common.DeliveryMechanism;
import com.google.firebase.crashlytics.internal.common.FileBackedNativeSessionFile;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.MetaDataStore;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.common.NativeSessionFileGzipper;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator;
import com.google.firebase.crashlytics.internal.common.UserMetadata;
import com.google.firebase.crashlytics.internal.common.Utils;
import com.google.firebase.crashlytics.internal.log.LogFileManager;
import com.google.firebase.crashlytics.internal.ndk.NativeFileUtils;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.proto.ClsFileOutputStream;
import com.google.firebase.crashlytics.internal.proto.CodedOutputStream;
import com.google.firebase.crashlytics.internal.proto.SessionProtobufHelper;
import com.google.firebase.crashlytics.internal.report.ReportManager;
import com.google.firebase.crashlytics.internal.report.ReportUploader;
import com.google.firebase.crashlytics.internal.report.model.Report;
import com.google.firebase.crashlytics.internal.report.model.SessionReport;
import com.google.firebase.crashlytics.internal.report.network.CompositeCreateReportSpiCall;
import com.google.firebase.crashlytics.internal.report.network.CreateReportSpiCall;
import com.google.firebase.crashlytics.internal.report.network.DefaultCreateReportSpiCall;
import com.google.firebase.crashlytics.internal.report.network.NativeCreateReportSpiCall;
import com.google.firebase.crashlytics.internal.settings.SettingsDataProvider;
import com.google.firebase.crashlytics.internal.settings.model.AppSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.Settings;
import com.google.firebase.crashlytics.internal.stacktrace.MiddleOutFallbackStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.RemoveRepeatsStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.TrimmedThrowableData;
import com.google.firebase.crashlytics.internal.unity.UnityVersionProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CrashlyticsController {
    static final String SESSION_USER_TAG = "SessionUser";
    static final String SESSION_NON_FATAL_TAG = "SessionEvent";
    static final String SESSION_FATAL_TAG = "SessionCrash";
    static final String SESSION_APP_TAG = "SessionApp";
    static final String SESSION_OS_TAG = "SessionOS";
    static final String SESSION_DEVICE_TAG = "SessionDevice";
    static final String SESSION_BEGIN_TAG = "BeginSession";
    static final String SESSION_EVENT_MISSING_BINARY_IMGS_TAG = "SessionMissingBinaryImages";
    static final String FIREBASE_CRASH_TYPE = "fatal";
    static final String FIREBASE_TIMESTAMP = "timestamp";
    static final String FIREBASE_APPLICATION_EXCEPTION = "_ae";
    static final String FIREBASE_ANALYTICS_ORIGIN_CRASHLYTICS = "clx";
    static final FilenameFilter SESSION_BEGIN_FILE_FILTER = new FileNameContainsFilter("BeginSession"){

        @Override
        public boolean accept(File dir, String filename) {
            return super.accept(dir, filename) && filename.endsWith(".cls");
        }
    };
    static final FilenameFilter SESSION_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.length() == 35 + ".cls".length() && filename.endsWith(".cls");
        }
    };
    static final Comparator<File> LARGEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file2.getName().compareTo(file1.getName());
        }
    };
    static final Comparator<File> SMALLEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file1.getName().compareTo(file2.getName());
        }
    };
    private static final Pattern SESSION_FILE_PATTERN = Pattern.compile("([\\d|A-Z|a-z]{12}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{12}).+");
    private static final String CRASHLYTICS_API_ENDPOINT = "com.crashlytics.ApiEndpoint";
    private static final Map<String, String> SEND_AT_CRASHTIME_HEADER = Collections.singletonMap("X-CRASHLYTICS-SEND-FLAGS", "1");
    private static final int MAX_LOCAL_LOGGED_EXCEPTIONS = 64;
    static final int MAX_OPEN_SESSIONS = 8;
    private static final int MAX_CHAINED_EXCEPTION_DEPTH = 8;
    static final int MAX_STACK_SIZE = 1024;
    static final int NUM_STACK_REPETITIONS_ALLOWED = 10;
    static final String NONFATAL_SESSION_DIR = "nonfatal-sessions";
    static final String FATAL_SESSION_DIR = "fatal-sessions";
    static final String NATIVE_SESSION_DIR = "native-sessions";
    static final int FIREBASE_CRASH_TYPE_FATAL = 1;
    private static final String GENERATOR_FORMAT = "Crashlytics Android SDK/%s";
    private static final String EVENT_TYPE_CRASH = "crash";
    private static final String EVENT_TYPE_LOGGED = "error";
    private static final int SESSION_ID_LENGTH = 35;
    private static final int ANALYZER_VERSION = 1;
    private static final String COLLECT_CUSTOM_KEYS = "com.crashlytics.CollectCustomKeys";
    private static final String[] INITIAL_SESSION_PART_TAGS = new String[]{"SessionUser", "SessionApp", "SessionOS", "SessionDevice"};
    private final AtomicInteger eventCounter = new AtomicInteger(0);
    private final Context context;
    private final DataCollectionArbiter dataCollectionArbiter;
    private final CrashlyticsFileMarker crashMarker;
    private final UserMetadata userMetadata;
    private final CrashlyticsBackgroundWorker backgroundWorker;
    private final HttpRequestFactory httpRequestFactory;
    private final IdManager idManager;
    private final FileStore fileStore;
    private final AppData appData;
    private final ReportUploader.Provider reportUploaderProvider;
    private final LogFileDirectoryProvider logFileDirectoryProvider;
    private final LogFileManager logFileManager;
    private final ReportManager reportManager;
    private final ReportUploader.HandlingExceptionCheck handlingExceptionCheck;
    private final CrashlyticsNativeComponent nativeComponent;
    private final StackTraceTrimmingStrategy stackTraceTrimmingStrategy;
    private final String unityVersion;
    private final AnalyticsReceiver analyticsReceiver;
    private final AnalyticsConnector analyticsConnector;
    private final SessionReportingCoordinator reportingCoordinator;
    private CrashlyticsUncaughtExceptionHandler crashHandler;
    TaskCompletionSource<Boolean> unsentReportsAvailable = new TaskCompletionSource();
    TaskCompletionSource<Boolean> reportActionProvided = new TaskCompletionSource();
    TaskCompletionSource<Void> unsentReportsHandled = new TaskCompletionSource();
    AtomicBoolean checkForUnsentReportsCalled = new AtomicBoolean(false);

    CrashlyticsController(Context context, CrashlyticsBackgroundWorker backgroundWorker, HttpRequestFactory httpRequestFactory, IdManager idManager, DataCollectionArbiter dataCollectionArbiter, FileStore fileStore, CrashlyticsFileMarker crashMarker, AppData appData, ReportManager reportManager, ReportUploader.Provider reportUploaderProvider, CrashlyticsNativeComponent nativeComponent, UnityVersionProvider unityVersionProvider, AnalyticsReceiver analyticsReceiver, AnalyticsConnector analyticsConnector, SettingsDataProvider settingsDataProvider) {
        this.context = context;
        this.backgroundWorker = backgroundWorker;
        this.httpRequestFactory = httpRequestFactory;
        this.idManager = idManager;
        this.dataCollectionArbiter = dataCollectionArbiter;
        this.fileStore = fileStore;
        this.crashMarker = crashMarker;
        this.appData = appData;
        this.reportUploaderProvider = reportUploaderProvider != null ? reportUploaderProvider : this.defaultReportUploader();
        this.nativeComponent = nativeComponent;
        this.unityVersion = unityVersionProvider.getUnityVersion();
        this.analyticsReceiver = analyticsReceiver;
        this.analyticsConnector = analyticsConnector;
        this.userMetadata = new UserMetadata();
        this.logFileDirectoryProvider = new LogFileDirectoryProvider(fileStore);
        this.logFileManager = new LogFileManager(context, this.logFileDirectoryProvider);
        if (reportManager == null) {
            reportManager = new ReportManager(new ReportUploaderFilesProvider());
        }
        this.reportManager = reportManager;
        this.handlingExceptionCheck = new ReportUploaderHandlingExceptionCheck();
        this.stackTraceTrimmingStrategy = new MiddleOutFallbackStrategy(1024, new RemoveRepeatsStrategy(10));
        this.reportingCoordinator = SessionReportingCoordinator.create(context, idManager, fileStore, appData, this.logFileManager, this.userMetadata, this.stackTraceTrimmingStrategy, settingsDataProvider);
    }

    private Context getContext() {
        return this.context;
    }

    void enableExceptionHandling(Thread.UncaughtExceptionHandler defaultHandler, SettingsDataProvider settingsProvider) {
        this.openSession();
        CrashlyticsUncaughtExceptionHandler.CrashListener crashListener = new CrashlyticsUncaughtExceptionHandler.CrashListener(){

            @Override
            public void onUncaughtException(@NonNull SettingsDataProvider settingsDataProvider, @NonNull Thread thread, @NonNull Throwable ex) {
                CrashlyticsController.this.handleUncaughtException(settingsDataProvider, thread, ex);
            }
        };
        this.crashHandler = new CrashlyticsUncaughtExceptionHandler(crashListener, settingsProvider, defaultHandler);
        Thread.setDefaultUncaughtExceptionHandler(this.crashHandler);
    }

    synchronized void handleUncaughtException(final @NonNull SettingsDataProvider settingsDataProvider, final @NonNull Thread thread, final @NonNull Throwable ex) {
        Logger.getLogger().d("Crashlytics is handling uncaught exception \"" + ex + "\" from thread " + thread.getName());
        final Date time = new Date();
        final Task<Void> recordFatalFirebaseEventTask = this.recordFatalFirebaseEvent(time.getTime());
        Task<Void> handleUncaughtExceptionTask = this.backgroundWorker.submitTask(new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() throws Exception {
                CrashlyticsController.this.crashMarker.create();
                long timestampSeconds = CrashlyticsController.getTimestampSeconds(time);
                CrashlyticsController.this.reportingCoordinator.persistFatalEvent(ex, thread, timestampSeconds);
                CrashlyticsController.this.writeFatal(thread, ex, timestampSeconds);
                Settings settings = settingsDataProvider.getSettings();
                int maxCustomExceptionEvents = settings.getSessionData().maxCustomExceptionEvents;
                int maxCompleteSessionsCount = settings.getSessionData().maxCompleteSessionsCount;
                CrashlyticsController.this.doCloseSessions(maxCustomExceptionEvents);
                CrashlyticsController.this.doOpenSession();
                CrashlyticsController.this.trimSessionFiles(maxCompleteSessionsCount);
                if (!CrashlyticsController.this.dataCollectionArbiter.isAutomaticDataCollectionEnabled()) {
                    return Tasks.forResult(null);
                }
                final Executor executor = CrashlyticsController.this.backgroundWorker.getExecutor();
                return settingsDataProvider.getAppSettings().onSuccessTask(executor, (SuccessContinuation)new SuccessContinuation<AppSettingsData, Void>(){

                    @NonNull
                    public Task<Void> then(@Nullable AppSettingsData appSettingsData) throws Exception {
                        if (appSettingsData == null) {
                            Logger.getLogger().w("Received null app settings, cannot send reports at crash time.");
                            return Tasks.forResult(null);
                        }
                        boolean dataCollectionToken = true;
                        CrashlyticsController.this.sendSessionReports(appSettingsData, dataCollectionToken);
                        CrashlyticsController.this.reportingCoordinator.sendReports(executor, DataTransportState.getState(appSettingsData));
                        return recordFatalFirebaseEventTask;
                    }
                });
            }
        });
        try {
            Utils.awaitEvenIfOnMainThread(handleUncaughtExceptionTask);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Task<Boolean> waitForReportAction() {
        if (this.dataCollectionArbiter.isAutomaticDataCollectionEnabled()) {
            Logger.getLogger().d("Automatic data collection is enabled. Allowing upload.");
            this.unsentReportsAvailable.trySetResult((Object)false);
            return Tasks.forResult((Object)true);
        }
        Logger.getLogger().d("Automatic data collection is disabled.");
        Logger.getLogger().d("Notifying that unsent reports are available.");
        this.unsentReportsAvailable.trySetResult((Object)true);
        Task collectionEnabled = this.dataCollectionArbiter.waitForAutomaticDataCollectionEnabled().onSuccessTask((SuccessContinuation)new SuccessContinuation<Void, Boolean>(){

            @NonNull
            public Task<Boolean> then(@Nullable Void aVoid) throws Exception {
                return Tasks.forResult((Object)true);
            }
        });
        Logger.getLogger().d("Waiting for send/deleteUnsentReports to be called.");
        return Utils.race(collectionEnabled, this.reportActionProvided.getTask());
    }

    boolean didCrashOnPreviousExecution() {
        if (!this.crashMarker.isPresent()) {
            String sessionId = this.getCurrentSessionId();
            return sessionId != null && this.nativeComponent.hasCrashDataForSession(sessionId);
        }
        Logger.getLogger().d("Found previous crash marker.");
        this.crashMarker.remove();
        return Boolean.TRUE;
    }

    @NonNull
    Task<Boolean> checkForUnsentReports() {
        if (!this.checkForUnsentReportsCalled.compareAndSet(false, true)) {
            Logger.getLogger().d("checkForUnsentReports should only be called once per execution.");
            return Tasks.forResult((Object)false);
        }
        return this.unsentReportsAvailable.getTask();
    }

    Task<Void> sendUnsentReports() {
        this.reportActionProvided.trySetResult((Object)true);
        return this.unsentReportsHandled.getTask();
    }

    Task<Void> deleteUnsentReports() {
        this.reportActionProvided.trySetResult((Object)false);
        return this.unsentReportsHandled.getTask();
    }

    Task<Void> submitAllReports(final float delay, final Task<AppSettingsData> appSettingsDataTask) {
        if (!this.reportManager.areReportsAvailable()) {
            Logger.getLogger().d("No reports are available.");
            this.unsentReportsAvailable.trySetResult((Object)false);
            return Tasks.forResult(null);
        }
        Logger.getLogger().d("Unsent reports are available.");
        return this.waitForReportAction().onSuccessTask((SuccessContinuation)new SuccessContinuation<Boolean, Void>(){

            @NonNull
            public Task<Void> then(final @Nullable Boolean send) throws Exception {
                return CrashlyticsController.this.backgroundWorker.submitTask(new Callable<Task<Void>>(){

                    @Override
                    public Task<Void> call() throws Exception {
                        final List<Report> reports = CrashlyticsController.this.reportManager.findReports();
                        if (!send.booleanValue()) {
                            Logger.getLogger().d("Reports are being deleted.");
                            CrashlyticsController.this.reportManager.deleteReports(reports);
                            CrashlyticsController.this.reportingCoordinator.removeAllReports();
                            CrashlyticsController.this.unsentReportsHandled.trySetResult(null);
                            return Tasks.forResult(null);
                        }
                        Logger.getLogger().d("Reports are being sent.");
                        final boolean dataCollectionToken = send;
                        CrashlyticsController.this.dataCollectionArbiter.grantDataCollectionPermission(dataCollectionToken);
                        final Executor executor = CrashlyticsController.this.backgroundWorker.getExecutor();
                        return appSettingsDataTask.onSuccessTask(executor, (SuccessContinuation)new SuccessContinuation<AppSettingsData, Void>(){

                            @NonNull
                            public Task<Void> then(@Nullable AppSettingsData appSettingsData) throws Exception {
                                if (appSettingsData == null) {
                                    Logger.getLogger().w("Received null app settings, cannot send reports during app startup.");
                                    return Tasks.forResult(null);
                                }
                                for (Report report : reports) {
                                    if (report.getType() != Report.Type.JAVA) continue;
                                    CrashlyticsController.appendOrganizationIdToSessionFile(appSettingsData.organizationId, report.getFile());
                                }
                                ReportUploader uploader = CrashlyticsController.this.reportUploaderProvider.createReportUploader(appSettingsData);
                                uploader.uploadReportsAsync(reports, dataCollectionToken, delay);
                                CrashlyticsController.this.reportingCoordinator.sendReports(executor, DataTransportState.getState(appSettingsData));
                                CrashlyticsController.this.unsentReportsHandled.trySetResult(null);
                                return Tasks.forResult(null);
                            }
                        });
                    }
                });
            }
        });
    }

    private ReportUploader.Provider defaultReportUploader() {
        return new ReportUploader.Provider(){

            @Override
            public ReportUploader createReportUploader(@NonNull AppSettingsData appSettingsData) {
                String reportsUrl = appSettingsData.reportsUrl;
                String ndkReportsUrl = appSettingsData.ndkReportsUrl;
                String organizationId = appSettingsData.organizationId;
                CreateReportSpiCall call = CrashlyticsController.this.getCreateReportSpiCall(reportsUrl, ndkReportsUrl);
                return new ReportUploader(organizationId, ((CrashlyticsController)CrashlyticsController.this).appData.googleAppId, DataTransportState.getState(appSettingsData), CrashlyticsController.this.reportManager, call, CrashlyticsController.this.handlingExceptionCheck);
            }
        };
    }

    void writeToLog(final long timestamp, final String msg) {
        this.backgroundWorker.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CrashlyticsController.this.isHandlingException()) {
                    CrashlyticsController.this.logFileManager.writeToLog(timestamp, msg);
                }
                return null;
            }
        });
    }

    void writeNonFatalException(final @NonNull Thread thread, final @NonNull Throwable ex) {
        final Date time = new Date();
        this.backgroundWorker.submit(new Runnable(){

            @Override
            public void run() {
                if (!CrashlyticsController.this.isHandlingException()) {
                    long timestampSeconds = CrashlyticsController.getTimestampSeconds(time);
                    CrashlyticsController.this.reportingCoordinator.persistNonFatalEvent(ex, thread, timestampSeconds);
                    CrashlyticsController.this.doWriteNonFatal(thread, ex, timestampSeconds);
                }
            }
        });
    }

    void setUserId(String identifier) {
        this.userMetadata.setUserId(identifier);
        this.cacheUserData(this.userMetadata);
    }

    void setCustomKey(String key, String value) {
        try {
            this.userMetadata.setCustomKey(key, value);
        }
        catch (IllegalArgumentException ex) {
            if (this.context != null && CommonUtils.isAppDebuggable(this.context)) {
                throw ex;
            }
            Logger.getLogger().e("Attempting to set custom attribute with null key, ignoring.");
            return;
        }
        this.cacheKeyData(this.userMetadata.getCustomKeys());
    }

    private void cacheUserData(final UserMetadata userMetaData) {
        this.backgroundWorker.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CrashlyticsController.this.reportingCoordinator.persistUserId();
                String currentSessionId = CrashlyticsController.this.getCurrentSessionId();
                new MetaDataStore(CrashlyticsController.this.getFilesDir()).writeUserData(currentSessionId, userMetaData);
                return null;
            }
        });
    }

    private void cacheKeyData(final Map<String, String> keyData) {
        this.backgroundWorker.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String currentSessionId = CrashlyticsController.this.getCurrentSessionId();
                new MetaDataStore(CrashlyticsController.this.getFilesDir()).writeKeyData(currentSessionId, keyData);
                return null;
            }
        });
    }

    void openSession() {
        this.backgroundWorker.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CrashlyticsController.this.doOpenSession();
                return null;
            }
        });
    }

    private String getCurrentSessionId() {
        File[] sessionBeginFiles = this.listSortedSessionBeginFiles();
        return sessionBeginFiles.length > 0 ? CrashlyticsController.getSessionIdFromSessionFile(sessionBeginFiles[0]) : null;
    }

    private String getPreviousSessionId() {
        File[] sessionBeginFiles = this.listSortedSessionBeginFiles();
        return sessionBeginFiles.length > 1 ? CrashlyticsController.getSessionIdFromSessionFile(sessionBeginFiles[1]) : null;
    }

    static String getSessionIdFromSessionFile(File sessionFile) {
        return sessionFile.getName().substring(0, 35);
    }

    boolean hasOpenSession() {
        return this.listSessionBeginFiles().length > 0;
    }

    boolean finalizeSessions(int maxCustomExceptionEvents) {
        this.backgroundWorker.checkRunningOnThread();
        if (this.isHandlingException()) {
            Logger.getLogger().d("Skipping session finalization because a crash has already occurred.");
            return Boolean.FALSE;
        }
        Logger.getLogger().d("Finalizing previously open sessions.");
        try {
            this.doCloseSessions(maxCustomExceptionEvents, false);
        }
        catch (Exception e) {
            Logger.getLogger().e("Unable to finalize previously open sessions.", e);
            return false;
        }
        Logger.getLogger().d("Closed all previously open sessions");
        return true;
    }

    private void doOpenSession() throws Exception {
        long startedAtSeconds = CrashlyticsController.getCurrentTimestampSeconds();
        String sessionIdentifier = new CLSUUID(this.idManager).toString();
        Logger.getLogger().d("Opening a new session with ID " + sessionIdentifier);
        this.nativeComponent.openSession(sessionIdentifier);
        this.writeBeginSession(sessionIdentifier, startedAtSeconds);
        this.writeSessionApp(sessionIdentifier);
        this.writeSessionOS(sessionIdentifier);
        this.writeSessionDevice(sessionIdentifier);
        this.logFileManager.setCurrentSession(sessionIdentifier);
        this.reportingCoordinator.onBeginSession(CrashlyticsController.makeFirebaseSessionIdentifier(sessionIdentifier), startedAtSeconds);
    }

    void doCloseSessions(int maxCustomExceptionEvents) throws Exception {
        this.doCloseSessions(maxCustomExceptionEvents, true);
    }

    private void doCloseSessions(int maxCustomExceptionEvents, boolean includeCurrent) throws Exception {
        int offset = includeCurrent ? 0 : 1;
        this.trimOpenSessions(8 + offset);
        File[] sessionBeginFiles = this.listSortedSessionBeginFiles();
        if (sessionBeginFiles.length <= offset) {
            Logger.getLogger().d("No open sessions to be closed.");
            return;
        }
        String mostRecentSessionIdToClose = CrashlyticsController.getSessionIdFromSessionFile(sessionBeginFiles[offset]);
        this.writeSessionUser(mostRecentSessionIdToClose);
        if (includeCurrent) {
            this.reportingCoordinator.onEndSession();
        } else if (this.nativeComponent.hasCrashDataForSession(mostRecentSessionIdToClose)) {
            this.finalizePreviousNativeSession(mostRecentSessionIdToClose);
            if (!this.nativeComponent.finalizeSession(mostRecentSessionIdToClose)) {
                Logger.getLogger().d("Could not finalize native session: " + mostRecentSessionIdToClose);
            }
        }
        this.closeOpenSessions(sessionBeginFiles, offset, maxCustomExceptionEvents);
        this.reportingCoordinator.finalizeSessions(CrashlyticsController.getCurrentTimestampSeconds());
    }

    private void closeOpenSessions(File[] sessionBeginFiles, int beginIndex, int maxLoggedExceptionsCount) {
        Logger.getLogger().d("Closing open sessions.");
        for (int i = beginIndex; i < sessionBeginFiles.length; ++i) {
            File sessionBeginFile = sessionBeginFiles[i];
            String sessionIdentifier = CrashlyticsController.getSessionIdFromSessionFile(sessionBeginFile);
            Logger.getLogger().d("Closing session: " + sessionIdentifier);
            this.writeSessionPartsToSessionFile(sessionBeginFile, sessionIdentifier, maxLoggedExceptionsCount);
        }
    }

    private void closeWithoutRenamingOrLog(ClsFileOutputStream fos) {
        if (fos == null) {
            return;
        }
        try {
            fos.closeInProgressStream();
        }
        catch (IOException ex) {
            Logger.getLogger().e("Error closing session file stream in the presence of an exception", ex);
        }
    }

    private void deleteSessionPartFilesFor(String sessionId) {
        for (File file : this.listSessionPartFilesFor(sessionId)) {
            file.delete();
        }
    }

    private File[] listSessionPartFilesFor(String sessionId) {
        return this.listFilesMatching(new SessionPartFileFilter(sessionId));
    }

    File[] listCompleteSessionFiles() {
        LinkedList completeSessionFiles = new LinkedList();
        Collections.addAll(completeSessionFiles, this.listFilesMatching(this.getFatalSessionFilesDir(), SESSION_FILE_FILTER));
        Collections.addAll(completeSessionFiles, this.listFilesMatching(this.getNonFatalSessionFilesDir(), SESSION_FILE_FILTER));
        Collections.addAll(completeSessionFiles, this.listFilesMatching(this.getFilesDir(), SESSION_FILE_FILTER));
        return completeSessionFiles.toArray(new File[completeSessionFiles.size()]);
    }

    File[] listNativeSessionFileDirectories() {
        return this.ensureFileArrayNotNull(this.getNativeSessionFilesDir().listFiles());
    }

    File[] listSessionBeginFiles() {
        return this.listFilesMatching(SESSION_BEGIN_FILE_FILTER);
    }

    private File[] listSortedSessionBeginFiles() {
        File[] sessionBeginFiles = this.listSessionBeginFiles();
        Arrays.sort(sessionBeginFiles, LARGEST_FILE_NAME_FIRST);
        return sessionBeginFiles;
    }

    private File[] listFilesMatching(FilenameFilter filter) {
        return this.listFilesMatching(this.getFilesDir(), filter);
    }

    private File[] listFilesMatching(File directory, FilenameFilter filter) {
        return this.ensureFileArrayNotNull(directory.listFiles(filter));
    }

    private File[] listFiles(File directory) {
        return this.ensureFileArrayNotNull(directory.listFiles());
    }

    private File[] ensureFileArrayNotNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    private void trimSessionEventFiles(String sessionId, int limit) {
        Utils.capFileCount(this.getFilesDir(), new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG), limit, SMALLEST_FILE_NAME_FIRST);
    }

    void trimSessionFiles(int maxCompleteSessionsCount) {
        int remaining = maxCompleteSessionsCount;
        remaining -= Utils.capSessionCount(this.getNativeSessionFilesDir(), this.getFatalSessionFilesDir(), remaining, SMALLEST_FILE_NAME_FIRST);
        remaining -= Utils.capFileCount(this.getNonFatalSessionFilesDir(), remaining, SMALLEST_FILE_NAME_FIRST);
        Utils.capFileCount(this.getFilesDir(), SESSION_FILE_FILTER, remaining, SMALLEST_FILE_NAME_FIRST);
    }

    private void trimOpenSessions(int maxOpenSessionCount) {
        HashSet<String> sessionIdsToKeep = new HashSet<String>();
        File[] beginSessionFiles = this.listSortedSessionBeginFiles();
        int count = Math.min(maxOpenSessionCount, beginSessionFiles.length);
        for (int i = 0; i < count; ++i) {
            String sessionId = CrashlyticsController.getSessionIdFromSessionFile(beginSessionFiles[i]);
            sessionIdsToKeep.add(sessionId);
        }
        this.logFileManager.discardOldLogFiles(sessionIdsToKeep);
        this.retainSessions(this.listFilesMatching(new AnySessionPartFileFilter()), sessionIdsToKeep);
    }

    private void retainSessions(File[] files, Set<String> sessionIdsToKeep) {
        for (File sessionPartFile : files) {
            String fileName = sessionPartFile.getName();
            Matcher matcher = SESSION_FILE_PATTERN.matcher(fileName);
            if (!matcher.matches()) {
                Logger.getLogger().d("Deleting unknown file: " + fileName);
                sessionPartFile.delete();
                continue;
            }
            String sessionId = matcher.group(1);
            if (sessionIdsToKeep.contains(sessionId)) continue;
            Logger.getLogger().d("Trimming session file: " + fileName);
            sessionPartFile.delete();
        }
    }

    private File[] getTrimmedNonFatalFiles(String sessionId, File[] nonFatalFiles, int maxLoggedExceptionsCount) {
        if (nonFatalFiles.length > maxLoggedExceptionsCount) {
            Logger.getLogger().d(String.format(Locale.US, "Trimming down to %d logged exceptions.", maxLoggedExceptionsCount));
            this.trimSessionEventFiles(sessionId, maxLoggedExceptionsCount);
            nonFatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG));
        }
        return nonFatalFiles;
    }

    void cleanInvalidTempFiles() {
        this.backgroundWorker.submit(new Runnable(){

            @Override
            public void run() {
                CrashlyticsController.this.doCleanInvalidTempFiles(CrashlyticsController.this.listFilesMatching(new InvalidPartFileFilter()));
            }
        });
    }

    void doCleanInvalidTempFiles(File[] invalidFiles) {
        final HashSet<String> invalidSessionIds = new HashSet<String>();
        for (File invalidFile : invalidFiles) {
            Logger.getLogger().d("Found invalid session part file: " + invalidFile);
            invalidSessionIds.add(CrashlyticsController.getSessionIdFromSessionFile(invalidFile));
        }
        if (invalidSessionIds.isEmpty()) {
            return;
        }
        FilenameFilter invalidSessionFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                if (filename.length() < 35) {
                    return false;
                }
                return invalidSessionIds.contains(filename.substring(0, 35));
            }
        };
        for (File sessionFile : this.listFilesMatching(invalidSessionFilter)) {
            Logger.getLogger().d("Deleting invalid session file: " + sessionFile);
            sessionFile.delete();
        }
    }

    private void finalizePreviousNativeSession(String previousSessionId) {
        Logger.getLogger().d("Finalizing native report for session " + previousSessionId);
        NativeSessionFileProvider nativeSessionFileProvider = this.nativeComponent.getSessionFileProvider(previousSessionId);
        File minidumpFile = nativeSessionFileProvider.getMinidumpFile();
        if (minidumpFile == null || !minidumpFile.exists()) {
            Logger.getLogger().w("No minidump data found for session " + previousSessionId);
            return;
        }
        LogFileManager previousSessionLogManager = new LogFileManager(this.context, this.logFileDirectoryProvider, previousSessionId);
        File nativeSessionDirectory = new File(this.getNativeSessionFilesDir(), previousSessionId);
        if (!nativeSessionDirectory.mkdirs()) {
            Logger.getLogger().d("Couldn't create native sessions directory");
            return;
        }
        List<NativeSessionFile> nativeSessionFiles = CrashlyticsController.getNativeSessionFiles(nativeSessionFileProvider, previousSessionId, this.getContext(), this.getFilesDir(), previousSessionLogManager.getBytesForLog());
        NativeSessionFileGzipper.processNativeSessions(nativeSessionDirectory, nativeSessionFiles);
        this.reportingCoordinator.finalizeSessionWithNativeEvent(CrashlyticsController.makeFirebaseSessionIdentifier(previousSessionId), nativeSessionFiles);
        previousSessionLogManager.clearLog();
    }

    private static long getCurrentTimestampSeconds() {
        return CrashlyticsController.getTimestampSeconds(new Date());
    }

    private static long getTimestampSeconds(Date date) {
        return date.getTime() / 1000L;
    }

    @NonNull
    private static String makeFirebaseSessionIdentifier(@NonNull String sessionIdentifier) {
        return sessionIdentifier.replaceAll("-", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatal(Thread thread, Throwable ex, long eventTime) {
        block7: {
            ClsFileOutputStream fos = null;
            CodedOutputStream cos = null;
            try {
                String currentSessionId = this.getCurrentSessionId();
                if (currentSessionId == null) {
                    Logger.getLogger().e("Tried to write a fatal exception while no session was open.");
                    return;
                }
                fos = new ClsFileOutputStream(this.getFilesDir(), currentSessionId + SESSION_FATAL_TAG);
                cos = CodedOutputStream.newInstance(fos);
                this.writeSessionEvent(cos, thread, ex, eventTime, EVENT_TYPE_CRASH, true);
                CommonUtils.flushOrLog(cos, "Failed to flush to session begin file.");
            }
            catch (Exception e) {
                Logger.getLogger().e("An error occurred in the fatal exception logger", e);
                break block7;
            }
            finally {
                CommonUtils.flushOrLog(cos, "Failed to flush to session begin file.");
                CommonUtils.closeOrLog(fos, "Failed to close fatal exception file output stream.");
            }
            CommonUtils.closeOrLog(fos, "Failed to close fatal exception file output stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteNonFatal(@NonNull Thread thread, @NonNull Throwable ex, long eventTime) {
        String currentSessionId;
        block8: {
            currentSessionId = this.getCurrentSessionId();
            if (currentSessionId == null) {
                Logger.getLogger().d("Tried to write a non-fatal exception while no session was open.");
                return;
            }
            ClsFileOutputStream fos = null;
            CodedOutputStream cos = null;
            try {
                Logger.getLogger().d("Crashlytics is logging non-fatal exception \"" + ex + "\" from thread " + thread.getName());
                String counterString = CommonUtils.padWithZerosToMaxIntWidth(this.eventCounter.getAndIncrement());
                String nonFatalFileName = currentSessionId + SESSION_NON_FATAL_TAG + counterString;
                fos = new ClsFileOutputStream(this.getFilesDir(), nonFatalFileName);
                cos = CodedOutputStream.newInstance(fos);
                this.writeSessionEvent(cos, thread, ex, eventTime, EVENT_TYPE_LOGGED, false);
                CommonUtils.flushOrLog(cos, "Failed to flush to non-fatal file.");
            }
            catch (Exception e) {
                Logger.getLogger().e("An error occurred in the non-fatal exception logger", e);
                break block8;
            }
            finally {
                CommonUtils.flushOrLog(cos, "Failed to flush to non-fatal file.");
                CommonUtils.closeOrLog(fos, "Failed to close non-fatal file output stream.");
            }
            CommonUtils.closeOrLog(fos, "Failed to close non-fatal file output stream.");
        }
        try {
            this.trimSessionEventFiles(currentSessionId, 64);
        }
        catch (Exception e) {
            Logger.getLogger().e("An error occurred when trimming non-fatal files.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionPartFile(String sessionId, String tag, CodedOutputStreamWriteAction writeAction) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.getFilesDir(), sessionId + tag);
            cos = CodedOutputStream.newInstance(fos);
            writeAction.writeTo(cos);
        }
        catch (Throwable throwable) {
            CommonUtils.flushOrLog(cos, "Failed to flush to session " + tag + " file.");
            CommonUtils.closeOrLog(fos, "Failed to close session " + tag + " file.");
            throw throwable;
        }
        CommonUtils.flushOrLog(cos, "Failed to flush to session " + tag + " file.");
        CommonUtils.closeOrLog(fos, "Failed to close session " + tag + " file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendToProtoFile(@NonNull File file, @NonNull CodedOutputStreamWriteAction writeAction) throws Exception {
        FileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new FileOutputStream(file, true);
            cos = CodedOutputStream.newInstance(fos);
            writeAction.writeTo(cos);
        }
        finally {
            CommonUtils.flushOrLog(cos, "Failed to flush to append to " + file.getPath());
            CommonUtils.closeOrLog(fos, "Failed to close " + file.getPath());
        }
    }

    private void writeBeginSession(final String sessionId, final long startedAtSeconds) throws Exception {
        final String generator = String.format(Locale.US, GENERATOR_FORMAT, CrashlyticsCore.getVersion());
        this.writeSessionPartFile(sessionId, SESSION_BEGIN_TAG, new CodedOutputStreamWriteAction(){

            @Override
            public void writeTo(CodedOutputStream arg) throws Exception {
                SessionProtobufHelper.writeBeginSession(arg, sessionId, generator, startedAtSeconds);
            }
        });
        this.nativeComponent.writeBeginSession(sessionId, generator, startedAtSeconds);
    }

    private void writeSessionApp(String sessionId) throws Exception {
        final String appIdentifier = this.idManager.getAppIdentifier();
        final String versionCode = this.appData.versionCode;
        final String versionName = this.appData.versionName;
        final String installUuid = this.idManager.getCrashlyticsInstallId();
        final int deliveryMechanism = DeliveryMechanism.determineFrom(this.appData.installerPackageName).getId();
        this.writeSessionPartFile(sessionId, SESSION_APP_TAG, new CodedOutputStreamWriteAction(){

            @Override
            public void writeTo(CodedOutputStream arg) throws Exception {
                SessionProtobufHelper.writeSessionApp(arg, appIdentifier, versionCode, versionName, installUuid, deliveryMechanism, CrashlyticsController.this.unityVersion);
            }
        });
        this.nativeComponent.writeSessionApp(sessionId, appIdentifier, versionCode, versionName, installUuid, deliveryMechanism, this.unityVersion);
    }

    private void writeSessionOS(String sessionId) throws Exception {
        final String osRelease = Build.VERSION.RELEASE;
        final String osCodeName = Build.VERSION.CODENAME;
        final boolean isRooted = CommonUtils.isRooted(this.getContext());
        this.writeSessionPartFile(sessionId, SESSION_OS_TAG, new CodedOutputStreamWriteAction(){

            @Override
            public void writeTo(CodedOutputStream arg) throws Exception {
                SessionProtobufHelper.writeSessionOS(arg, osRelease, osCodeName, isRooted);
            }
        });
        this.nativeComponent.writeSessionOs(sessionId, osRelease, osCodeName, isRooted);
    }

    private void writeSessionDevice(String sessionId) throws Exception {
        Context context = this.getContext();
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        final int arch = CommonUtils.getCpuArchitectureInt();
        final String model = Build.MODEL;
        final int availableProcessors = Runtime.getRuntime().availableProcessors();
        final long totalRam = CommonUtils.getTotalRamInBytes();
        final long diskSpace = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
        final boolean isEmulator = CommonUtils.isEmulator(context);
        final int state = CommonUtils.getDeviceState(context);
        final String manufacturer = Build.MANUFACTURER;
        final String modelClass = Build.PRODUCT;
        this.writeSessionPartFile(sessionId, SESSION_DEVICE_TAG, new CodedOutputStreamWriteAction(){

            @Override
            public void writeTo(CodedOutputStream arg) throws Exception {
                SessionProtobufHelper.writeSessionDevice(arg, arch, model, availableProcessors, totalRam, diskSpace, isEmulator, state, manufacturer, modelClass);
            }
        });
        this.nativeComponent.writeSessionDevice(sessionId, arch, model, availableProcessors, totalRam, diskSpace, isEmulator, state, manufacturer, modelClass);
    }

    private void writeSessionUser(String sessionId) throws Exception {
        final UserMetadata metadata = this.getUserMetadata(sessionId);
        this.writeSessionPartFile(sessionId, SESSION_USER_TAG, new CodedOutputStreamWriteAction(){

            @Override
            public void writeTo(CodedOutputStream arg) throws Exception {
                SessionProtobufHelper.writeSessionUser(arg, metadata.getUserId(), null, null);
            }
        });
    }

    private void writeSessionEvent(CodedOutputStream cos, Thread thread, Throwable ex, long eventTime, String eventType, boolean includeAllThreads) throws Exception {
        Map<Object, Object> attributes;
        Thread[] threads;
        TrimmedThrowableData trimmedEx = new TrimmedThrowableData(ex, this.stackTraceTrimmingStrategy);
        Context context = this.getContext();
        BatteryState battery = BatteryState.get(context);
        Float batteryLevel = battery.getBatteryLevel();
        int batteryVelocity = battery.getBatteryVelocity();
        boolean proximityEnabled = CommonUtils.getProximitySensorEnabled(context);
        int orientation = context.getResources().getConfiguration().orientation;
        long usedRamBytes = CommonUtils.getTotalRamInBytes() - CommonUtils.calculateFreeRamInBytes(context);
        long diskUsedBytes = CommonUtils.calculateUsedDiskSpaceInBytes(Environment.getDataDirectory().getPath());
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = CommonUtils.getAppProcessInfo(context.getPackageName(), context);
        LinkedList<StackTraceElement[]> stacks = new LinkedList<StackTraceElement[]>();
        StackTraceElement[] exceptionStack = trimmedEx.stacktrace;
        String buildId = this.appData.buildId;
        String appIdentifier = this.idManager.getAppIdentifier();
        if (includeAllThreads) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            threads = new Thread[allStackTraces.size()];
            int i = 0;
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                threads[i] = entry.getKey();
                stacks.add(this.stackTraceTrimmingStrategy.getTrimmedStackTrace(entry.getValue()));
                ++i;
            }
        } else {
            threads = new Thread[]{};
        }
        if (!CommonUtils.getBooleanResourceValue(context, COLLECT_CUSTOM_KEYS, true)) {
            attributes = new TreeMap();
        } else {
            attributes = this.userMetadata.getCustomKeys();
            if (attributes != null && attributes.size() > 1) {
                attributes = new TreeMap<Object, Object>(attributes);
            }
        }
        SessionProtobufHelper.writeSessionEvent(cos, eventTime, eventType, trimmedEx, thread, exceptionStack, threads, stacks, 8, attributes, this.logFileManager.getBytesForLog(), runningAppProcessInfo, orientation, appIdentifier, buildId, batteryLevel, batteryVelocity, proximityEnabled, usedRamBytes, diskUsedBytes);
        this.logFileManager.clearLog();
    }

    private void writeSessionPartsToSessionFile(File sessionBeginFile, String sessionId, int maxLoggedExceptionsCount) {
        Logger.getLogger().d("Collecting session parts for ID " + sessionId);
        File[] fatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_FATAL_TAG));
        boolean hasFatal = fatalFiles != null && fatalFiles.length > 0;
        Logger.getLogger().d(String.format(Locale.US, "Session %s has fatal exception: %s", sessionId, hasFatal));
        File[] nonFatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG));
        boolean hasNonFatal = nonFatalFiles != null && nonFatalFiles.length > 0;
        Logger.getLogger().d(String.format(Locale.US, "Session %s has non-fatal exceptions: %s", sessionId, hasNonFatal));
        if (hasFatal || hasNonFatal) {
            File[] trimmedNonFatalFiles = this.getTrimmedNonFatalFiles(sessionId, nonFatalFiles, maxLoggedExceptionsCount);
            File fatalFile = hasFatal ? fatalFiles[0] : null;
            this.synthesizeSessionFile(sessionBeginFile, sessionId, trimmedNonFatalFiles, fatalFile);
        } else {
            Logger.getLogger().d("No events present for session ID " + sessionId);
        }
        Logger.getLogger().d("Removing session part files for ID " + sessionId);
        this.deleteSessionPartFilesFor(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synthesizeSessionFile(File sessionBeginFile, String sessionId, File[] nonFatalFiles, File fatalFile) {
        CodedOutputStream cos;
        ClsFileOutputStream fos;
        boolean exceptionDuringWrite;
        block11: {
            File outputDir;
            boolean hasFatal = fatalFile != null;
            exceptionDuringWrite = false;
            File file = outputDir = hasFatal ? this.getFatalSessionFilesDir() : this.getNonFatalSessionFilesDir();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            fos = null;
            cos = null;
            try {
                fos = new ClsFileOutputStream(outputDir, sessionId);
                cos = CodedOutputStream.newInstance(fos);
                Logger.getLogger().d("Collecting SessionStart data for session ID " + sessionId);
                CrashlyticsController.writeToCosFromFile(cos, sessionBeginFile);
                cos.writeUInt64(4, CrashlyticsController.getCurrentTimestampSeconds());
                cos.writeBool(5, hasFatal);
                cos.writeUInt32(11, 1);
                cos.writeEnum(12, 3);
                this.writeInitialPartsTo(cos, sessionId);
                CrashlyticsController.writeNonFatalEventsTo(cos, nonFatalFiles, sessionId);
                if (!hasFatal) break block11;
                CrashlyticsController.writeToCosFromFile(cos, fatalFile);
            }
            catch (Exception e) {
                try {
                    Logger.getLogger().e("Failed to write session file for session ID: " + sessionId, e);
                    exceptionDuringWrite = true;
                }
                catch (Throwable throwable) {
                    CommonUtils.flushOrLog(cos, "Error flushing session file stream");
                    if (exceptionDuringWrite) {
                        this.closeWithoutRenamingOrLog(fos);
                    } else {
                        CommonUtils.closeOrLog(fos, "Failed to close CLS file");
                    }
                    throw throwable;
                }
                CommonUtils.flushOrLog(cos, "Error flushing session file stream");
                if (exceptionDuringWrite) {
                    this.closeWithoutRenamingOrLog(fos);
                } else {
                    CommonUtils.closeOrLog(fos, "Failed to close CLS file");
                }
            }
        }
        CommonUtils.flushOrLog(cos, "Error flushing session file stream");
        if (exceptionDuringWrite) {
            this.closeWithoutRenamingOrLog(fos);
        } else {
            CommonUtils.closeOrLog(fos, "Failed to close CLS file");
        }
    }

    private static void writeNonFatalEventsTo(CodedOutputStream cos, File[] nonFatalFiles, String sessionId) {
        Arrays.sort(nonFatalFiles, CommonUtils.FILE_MODIFIED_COMPARATOR);
        for (File nonFatalFile : nonFatalFiles) {
            try {
                Logger.getLogger().d(String.format(Locale.US, "Found Non Fatal for session ID %s in %s ", sessionId, nonFatalFile.getName()));
                CrashlyticsController.writeToCosFromFile(cos, nonFatalFile);
            }
            catch (Exception e) {
                Logger.getLogger().e("Error writting non-fatal to session.", e);
            }
        }
    }

    private void writeInitialPartsTo(CodedOutputStream cos, String sessionId) throws IOException {
        for (String tag : INITIAL_SESSION_PART_TAGS) {
            File[] sessionPartFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + tag + ".cls"));
            if (sessionPartFiles.length == 0) {
                Logger.getLogger().d("Can't find " + tag + " data for session ID " + sessionId);
                continue;
            }
            Logger.getLogger().d("Collecting " + tag + " data for session ID " + sessionId);
            CrashlyticsController.writeToCosFromFile(cos, sessionPartFiles[0]);
        }
    }

    private static void appendOrganizationIdToSessionFile(final @Nullable String organizationId, @NonNull File file) throws Exception {
        if (organizationId == null) {
            return;
        }
        CrashlyticsController.appendToProtoFile(file, new CodedOutputStreamWriteAction(){

            @Override
            public void writeTo(CodedOutputStream cos) throws Exception {
                SessionProtobufHelper.writeSessionAppClsId(cos, organizationId);
            }
        });
    }

    private static void writeToCosFromFile(CodedOutputStream cos, File file) throws IOException {
        if (!file.exists()) {
            Logger.getLogger().e("Tried to include a file that doesn't exist: " + file.getName());
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            CrashlyticsController.copyToCodedOutputStream(fis, cos, (int)file.length());
        }
        finally {
            CommonUtils.closeOrLog(fis, "Failed to close file input stream.");
        }
    }

    private static void copyToCodedOutputStream(InputStream inStream, CodedOutputStream cos, int bufferLength) throws IOException {
        int numRead;
        byte[] buffer = new byte[bufferLength];
        for (int offset = 0; offset < buffer.length && (numRead = inStream.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        cos.writeRawBytes(buffer);
    }

    UserMetadata getUserMetadata() {
        return this.userMetadata;
    }

    private UserMetadata getUserMetadata(String sessionId) {
        return this.isHandlingException() ? this.userMetadata : new MetaDataStore(this.getFilesDir()).readUserData(sessionId);
    }

    boolean isHandlingException() {
        return this.crashHandler != null && this.crashHandler.isHandlingException();
    }

    File getFilesDir() {
        return this.fileStore.getFilesDir();
    }

    File getNativeSessionFilesDir() {
        return new File(this.getFilesDir(), NATIVE_SESSION_DIR);
    }

    File getFatalSessionFilesDir() {
        return new File(this.getFilesDir(), FATAL_SESSION_DIR);
    }

    File getNonFatalSessionFilesDir() {
        return new File(this.getFilesDir(), NONFATAL_SESSION_DIR);
    }

    void registerAnalyticsListener() {
        boolean analyticsRegistered = this.analyticsReceiver.register();
        Logger.getLogger().d("Registered Firebase Analytics event listener for breadcrumbs: " + analyticsRegistered);
    }

    private CreateReportSpiCall getCreateReportSpiCall(String reportsUrl, String ndkReportsUrl) {
        Context context = this.getContext();
        String overriddenHost = CommonUtils.getStringsFileValue(context, CRASHLYTICS_API_ENDPOINT);
        DefaultCreateReportSpiCall defaultCreateReportSpiCall = new DefaultCreateReportSpiCall(overriddenHost, reportsUrl, this.httpRequestFactory, CrashlyticsCore.getVersion());
        NativeCreateReportSpiCall nativeCreateReportSpiCall = new NativeCreateReportSpiCall(overriddenHost, ndkReportsUrl, this.httpRequestFactory, CrashlyticsCore.getVersion());
        return new CompositeCreateReportSpiCall(defaultCreateReportSpiCall, nativeCreateReportSpiCall);
    }

    private void sendSessionReports(@NonNull AppSettingsData appSettings, boolean dataCollectionToken) throws Exception {
        Context context = this.getContext();
        ReportUploader reportUploader = this.reportUploaderProvider.createReportUploader(appSettings);
        for (File finishedSessionFile : this.listCompleteSessionFiles()) {
            CrashlyticsController.appendOrganizationIdToSessionFile(appSettings.organizationId, finishedSessionFile);
            SessionReport report = new SessionReport(finishedSessionFile, SEND_AT_CRASHTIME_HEADER);
            this.backgroundWorker.submit(new SendReportRunnable(context, report, reportUploader, dataCollectionToken));
        }
    }

    private Task<Void> recordFatalFirebaseEvent(final long timestamp) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        return Tasks.call((Executor)executor, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (CrashlyticsController.this.firebaseCrashExists()) {
                    Logger.getLogger().d("Skipping logging Crashlytics event to Firebase, FirebaseCrash exists");
                    return null;
                }
                if (CrashlyticsController.this.analyticsConnector == null) {
                    Logger.getLogger().d("Skipping logging Crashlytics event to Firebase, no Firebase Analytics");
                    return null;
                }
                BlockingCrashEventListener blockingListener = new BlockingCrashEventListener();
                CrashlyticsController.this.analyticsReceiver.setCrashlyticsOriginEventListener(blockingListener);
                Logger.getLogger().d("Logging Crashlytics event to Firebase");
                Bundle params = new Bundle();
                params.putInt(CrashlyticsController.FIREBASE_CRASH_TYPE, 1);
                params.putLong(CrashlyticsController.FIREBASE_TIMESTAMP, timestamp);
                CrashlyticsController.this.analyticsConnector.logEvent(CrashlyticsController.FIREBASE_ANALYTICS_ORIGIN_CRASHLYTICS, CrashlyticsController.FIREBASE_APPLICATION_EXCEPTION, params);
                blockingListener.awaitEvent();
                CrashlyticsController.this.analyticsReceiver.setCrashlyticsOriginEventListener(null);
                return null;
            }
        });
    }

    private boolean firebaseCrashExists() {
        try {
            Class<?> clazz = Class.forName("com.google.firebase.crash.FirebaseCrash");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @NonNull
    static List<NativeSessionFile> getNativeSessionFiles(NativeSessionFileProvider fileProvider, String previousSessionId, Context context, File filesDir, byte[] logBytes) {
        MetaDataStore metaDataStore = new MetaDataStore(filesDir);
        File userFile = metaDataStore.getUserDataFileForSession(previousSessionId);
        File keysFile = metaDataStore.getKeysFileForSession(previousSessionId);
        byte[] binaryImageBytes = null;
        try {
            binaryImageBytes = NativeFileUtils.binaryImagesJsonFromMapsFile(fileProvider.getBinaryImagesFile(), context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<NativeSessionFile> nativeSessionFiles = new ArrayList<NativeSessionFile>();
        nativeSessionFiles.add(new BytesBackedNativeSessionFile("logs_file", "logs", logBytes));
        nativeSessionFiles.add(new BytesBackedNativeSessionFile("binary_images_file", "binaryImages", binaryImageBytes));
        nativeSessionFiles.add(new FileBackedNativeSessionFile("crash_meta_file", "metadata", fileProvider.getMetadataFile()));
        nativeSessionFiles.add(new FileBackedNativeSessionFile("session_meta_file", "session", fileProvider.getSessionFile()));
        nativeSessionFiles.add(new FileBackedNativeSessionFile("app_meta_file", "app", fileProvider.getAppFile()));
        nativeSessionFiles.add(new FileBackedNativeSessionFile("device_meta_file", "device", fileProvider.getDeviceFile()));
        nativeSessionFiles.add(new FileBackedNativeSessionFile("os_meta_file", "os", fileProvider.getOsFile()));
        nativeSessionFiles.add(new FileBackedNativeSessionFile("minidump_file", "minidump", fileProvider.getMinidumpFile()));
        nativeSessionFiles.add(new FileBackedNativeSessionFile("user_meta_file", "user", userFile));
        nativeSessionFiles.add(new FileBackedNativeSessionFile("keys_file", "keys", keysFile));
        return nativeSessionFiles;
    }

    private static final class LogFileDirectoryProvider
    implements LogFileManager.DirectoryProvider {
        private static final String LOG_FILES_DIR = "log-files";
        private final FileStore rootFileStore;

        public LogFileDirectoryProvider(FileStore rootFileStore) {
            this.rootFileStore = rootFileStore;
        }

        @Override
        public File getLogFileDir() {
            File logFileDir = new File(this.rootFileStore.getFilesDir(), LOG_FILES_DIR);
            if (!logFileDir.exists()) {
                logFileDir.mkdirs();
            }
            return logFileDir;
        }
    }

    private static final class SendReportRunnable
    implements Runnable {
        private final Context context;
        private final Report report;
        private final ReportUploader reportUploader;
        private final boolean dataCollectionToken;

        public SendReportRunnable(Context context, Report report, ReportUploader reportUploader, boolean dataCollectionToken) {
            this.context = context;
            this.report = report;
            this.reportUploader = reportUploader;
            this.dataCollectionToken = dataCollectionToken;
        }

        @Override
        public void run() {
            if (!CommonUtils.canTryConnection(this.context)) {
                return;
            }
            Logger.getLogger().d("Attempting to send crash report at time of crash...");
            this.reportUploader.uploadReport(this.report, this.dataCollectionToken);
        }
    }

    private final class ReportUploaderFilesProvider
    implements ReportUploader.ReportFilesProvider {
        private ReportUploaderFilesProvider() {
        }

        @Override
        public File[] getCompleteSessionFiles() {
            return CrashlyticsController.this.listCompleteSessionFiles();
        }

        @Override
        public File[] getNativeReportFiles() {
            return CrashlyticsController.this.listNativeSessionFileDirectories();
        }
    }

    private final class ReportUploaderHandlingExceptionCheck
    implements ReportUploader.HandlingExceptionCheck {
        private ReportUploaderHandlingExceptionCheck() {
        }

        @Override
        public boolean isHandlingException() {
            return CrashlyticsController.this.isHandlingException();
        }
    }

    private static class BlockingCrashEventListener
    implements AnalyticsReceiver.CrashlyticsOriginEventListener {
        private static final int APP_EXCEPTION_CALLBACK_TIMEOUT_MS = 2000;
        private final CountDownLatch eventLatch = new CountDownLatch(1);

        private BlockingCrashEventListener() {
        }

        public void awaitEvent() throws InterruptedException {
            Logger.getLogger().d("Background thread awaiting app exception callback from FA...");
            if (this.eventLatch.await(2000L, TimeUnit.MILLISECONDS)) {
                Logger.getLogger().d("App exception callback received from FA listener.");
            } else {
                Logger.getLogger().d("Timeout exceeded while awaiting app exception callback from FA listener.");
            }
        }

        @Override
        public void onCrashlyticsOriginEvent(int id, Bundle extras) {
            String eventName = extras.getString("name");
            if (CrashlyticsController.FIREBASE_APPLICATION_EXCEPTION.equals(eventName)) {
                this.eventLatch.countDown();
            }
        }
    }

    private static interface CodedOutputStreamWriteAction {
        public void writeTo(CodedOutputStream var1) throws Exception;
    }

    static class InvalidPartFileFilter
    implements FilenameFilter {
        InvalidPartFileFilter() {
        }

        @Override
        public boolean accept(File file, String fileName) {
            return ClsFileOutputStream.TEMP_FILENAME_FILTER.accept(file, fileName) || fileName.contains(CrashlyticsController.SESSION_EVENT_MISSING_BINARY_IMGS_TAG);
        }
    }

    private static class AnySessionPartFileFilter
    implements FilenameFilter {
        private AnySessionPartFileFilter() {
        }

        @Override
        public boolean accept(File file, String fileName) {
            return !SESSION_FILE_FILTER.accept(file, fileName) && SESSION_FILE_PATTERN.matcher(fileName).matches();
        }
    }

    static class SessionPartFileFilter
    implements FilenameFilter {
        private final String sessionId;

        public SessionPartFileFilter(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public boolean accept(File file, String fileName) {
            if (fileName.equals(this.sessionId + ".cls")) {
                return false;
            }
            return fileName.contains(this.sessionId) && !fileName.endsWith(".cls_temp");
        }
    }

    static class FileNameContainsFilter
    implements FilenameFilter {
        private final String string;

        public FileNameContainsFilter(String s) {
            this.string = s;
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename.contains(this.string) && !filename.endsWith(".cls_temp");
        }
    }
}

