/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings.model;

import com.google.firebase.crashlytics.internal.settings.model.AppSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.FeaturesSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.SessionSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.Settings;

public class SettingsData
implements Settings {
    public final AppSettingsData appData;
    public final SessionSettingsData sessionData;
    public final FeaturesSettingsData featuresData;
    public final long expiresAtMillis;
    public final int settingsVersion;
    public final int cacheDuration;

    public SettingsData(long expiresAtMillis, AppSettingsData appData, SessionSettingsData sessionData, FeaturesSettingsData featuresData, int settingsVersion, int cacheDuration) {
        this.expiresAtMillis = expiresAtMillis;
        this.appData = appData;
        this.sessionData = sessionData;
        this.featuresData = featuresData;
        this.settingsVersion = settingsVersion;
        this.cacheDuration = cacheDuration;
    }

    public AppSettingsData getAppSettingsData() {
        return this.appData;
    }

    @Override
    public boolean isExpired(long currentTimeMillis) {
        return this.expiresAtMillis < currentTimeMillis;
    }

    @Override
    public SessionSettingsData getSessionData() {
        return this.sessionData;
    }

    @Override
    public FeaturesSettingsData getFeaturesData() {
        return this.featuresData;
    }

    @Override
    public long getExpiresAtMillis() {
        return this.expiresAtMillis;
    }

    @Override
    public int getSettingsVersion() {
        return this.settingsVersion;
    }

    @Override
    public int getCacheDuration() {
        return this.cacheDuration;
    }
}

