/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.CrashlyticsAnalyticsListener;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.MissingNativeComponent;
import com.google.firebase.crashlytics.internal.Onboarding;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.BlockingAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.BreadcrumbAnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.analytics.CrashlyticsOriginAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.UnavailableAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbSource;
import com.google.firebase.crashlytics.internal.breadcrumbs.DisabledBreadcrumbSource;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.ExecutorUtils;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.settings.SettingsController;
import com.google.firebase.installations.FirebaseInstallationsApi;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class FirebaseCrashlytics {
    private static final String FIREBASE_CRASHLYTICS_ANALYTICS_ORIGIN = "clx";
    private static final String LEGACY_CRASH_ANALYTICS_ORIGIN = "crash";
    private static final int APP_EXCEPTION_CALLBACK_TIMEOUT_MS = 500;
    private final CrashlyticsCore core;

    @Nullable
    static FirebaseCrashlytics init(@NonNull FirebaseApp app, @NonNull FirebaseInstallationsApi firebaseInstallationsApi, @Nullable CrashlyticsNativeComponent nativeComponent, @Nullable AnalyticsConnector analyticsConnector) {
        AnalyticsEventLogger analyticsEventLogger;
        BreadcrumbSource breadcrumbSource;
        Context context = app.getApplicationContext();
        String appIdentifier = context.getPackageName();
        IdManager idManager = new IdManager(context, appIdentifier, firebaseInstallationsApi);
        DataCollectionArbiter arbiter = new DataCollectionArbiter(app);
        if (nativeComponent == null) {
            nativeComponent = new MissingNativeComponent();
        }
        final Onboarding onboarding = new Onboarding(app, context, idManager, arbiter);
        if (analyticsConnector != null) {
            Logger.getLogger().d("Firebase Analytics is available.");
            CrashlyticsOriginAnalyticsEventLogger directAnalyticsEventLogger = new CrashlyticsOriginAnalyticsEventLogger(analyticsConnector);
            CrashlyticsAnalyticsListener crashlyticsAnalyticsListener = new CrashlyticsAnalyticsListener();
            AnalyticsConnector.AnalyticsConnectorHandle analyticsConnectorHandle = FirebaseCrashlytics.subscribeToAnalyticsEvents(analyticsConnector, crashlyticsAnalyticsListener);
            if (analyticsConnectorHandle != null) {
                Logger.getLogger().d("Firebase Analytics listener registered successfully.");
                BreadcrumbAnalyticsEventReceiver breadcrumbReceiver = new BreadcrumbAnalyticsEventReceiver();
                BlockingAnalyticsEventLogger blockingAnalyticsEventLogger = new BlockingAnalyticsEventLogger(directAnalyticsEventLogger, 500, TimeUnit.MILLISECONDS);
                crashlyticsAnalyticsListener.setBreadcrumbEventReceiver(breadcrumbReceiver);
                crashlyticsAnalyticsListener.setCrashlyticsOriginEventReceiver(blockingAnalyticsEventLogger);
                breadcrumbSource = breadcrumbReceiver;
                analyticsEventLogger = blockingAnalyticsEventLogger;
            } else {
                Logger.getLogger().d("Firebase Analytics listener registration failed.");
                breadcrumbSource = new DisabledBreadcrumbSource();
                analyticsEventLogger = directAnalyticsEventLogger;
            }
        } else {
            Logger.getLogger().d("Firebase Analytics is unavailable.");
            breadcrumbSource = new DisabledBreadcrumbSource();
            analyticsEventLogger = new UnavailableAnalyticsEventLogger();
        }
        ExecutorService crashHandlerExecutor = ExecutorUtils.buildSingleThreadExecutorService("Crashlytics Exception Handler");
        final CrashlyticsCore core = new CrashlyticsCore(app, idManager, nativeComponent, arbiter, breadcrumbSource, analyticsEventLogger, crashHandlerExecutor);
        if (!onboarding.onPreExecute()) {
            Logger.getLogger().e("Unable to start Crashlytics.");
            return null;
        }
        final ExecutorService threadPoolExecutor = ExecutorUtils.buildSingleThreadExecutorService("com.google.firebase.crashlytics.startup");
        final SettingsController settingsController = onboarding.retrieveSettingsData(context, app, threadPoolExecutor);
        final boolean finishCoreInBackground = core.onPreExecute(settingsController);
        Tasks.call((Executor)threadPoolExecutor, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                onboarding.doOnboarding(threadPoolExecutor, settingsController);
                if (finishCoreInBackground) {
                    core.doBackgroundInitializationAsync(settingsController);
                }
                return null;
            }
        });
        return new FirebaseCrashlytics(core);
    }

    private static AnalyticsConnector.AnalyticsConnectorHandle subscribeToAnalyticsEvents(@NonNull AnalyticsConnector analyticsConnector, @NonNull CrashlyticsAnalyticsListener listener) {
        AnalyticsConnector.AnalyticsConnectorHandle handle = analyticsConnector.registerAnalyticsConnectorListener(FIREBASE_CRASHLYTICS_ANALYTICS_ORIGIN, (AnalyticsConnector.AnalyticsConnectorListener)listener);
        if (handle == null) {
            Logger.getLogger().d("Could not register AnalyticsConnectorListener with Crashlytics origin.");
            handle = analyticsConnector.registerAnalyticsConnectorListener(LEGACY_CRASH_ANALYTICS_ORIGIN, (AnalyticsConnector.AnalyticsConnectorListener)listener);
            if (handle != null) {
                Logger.getLogger().w("A new version of the Google Analytics for Firebase SDK is now available. For improved performance and compatibility with Crashlytics, please update to the latest version.");
            }
        }
        return handle;
    }

    private FirebaseCrashlytics(@NonNull CrashlyticsCore core) {
        this.core = core;
    }

    @NonNull
    public static FirebaseCrashlytics getInstance() {
        FirebaseApp app = FirebaseApp.getInstance();
        FirebaseCrashlytics instance = (FirebaseCrashlytics)app.get(FirebaseCrashlytics.class);
        if (instance == null) {
            throw new NullPointerException("FirebaseCrashlytics component is not present.");
        }
        return instance;
    }

    public void recordException(@NonNull Throwable throwable) {
        if (throwable == null) {
            Logger.getLogger().w("Crashlytics is ignoring a request to log a null exception.");
            return;
        }
        this.core.logException(throwable);
    }

    public void log(@NonNull String message) {
        this.core.log(message);
    }

    public void setUserId(@NonNull String identifier) {
        this.core.setUserId(identifier);
    }

    public void setCustomKey(@NonNull String key, boolean value) {
        this.core.setCustomKey(key, Boolean.toString(value));
    }

    public void setCustomKey(@NonNull String key, double value) {
        this.core.setCustomKey(key, Double.toString(value));
    }

    public void setCustomKey(@NonNull String key, float value) {
        this.core.setCustomKey(key, Float.toString(value));
    }

    public void setCustomKey(@NonNull String key, int value) {
        this.core.setCustomKey(key, Integer.toString(value));
    }

    public void setCustomKey(@NonNull String key, long value) {
        this.core.setCustomKey(key, Long.toString(value));
    }

    public void setCustomKey(@NonNull String key, @NonNull String value) {
        this.core.setCustomKey(key, value);
    }

    @NonNull
    public Task<Boolean> checkForUnsentReports() {
        return this.core.checkForUnsentReports();
    }

    public void sendUnsentReports() {
        this.core.sendUnsentReports();
    }

    public void deleteUnsentReports() {
        this.core.deleteUnsentReports();
    }

    public boolean didCrashOnPreviousExecution() {
        return this.core.didCrashOnPreviousExecution();
    }

    public void setCrashlyticsCollectionEnabled(boolean enabled) {
        this.core.setCrashlyticsCollectionEnabled(enabled);
    }

    public void setCrashlyticsCollectionEnabled(@Nullable Boolean enabled) {
        this.core.setCrashlyticsCollectionEnabled(enabled);
    }
}

