/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.crashlytics.internal.common.ExecutorUtils;
import com.google.firebase.crashlytics.internal.common.Utils$$Lambda$1;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Utils {
    private static final FilenameFilter ALL_FILES_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return true;
        }
    };
    private static final ExecutorService TASK_CONTINUATION_EXECUTOR_SERVICE = ExecutorUtils.buildSingleThreadExecutorService("awaitEvenIfOnMainThread task continuation executor");

    private Utils() {
    }

    static int capSessionCount(File nativeDirectory, File fatalDirectory, int maxAllowed, Comparator<File> sortComparator) {
        ArrayList<File> allFiles = new ArrayList<File>();
        File[] nativeFiles = nativeDirectory.listFiles();
        File[] fatalFiles = fatalDirectory.listFiles(ALL_FILES_FILTER);
        nativeFiles = nativeFiles != null ? nativeFiles : new File[]{};
        fatalFiles = fatalFiles != null ? fatalFiles : new File[]{};
        allFiles.addAll(Arrays.asList(nativeFiles));
        allFiles.addAll(Arrays.asList(fatalFiles));
        return Utils.capFileCount(allFiles, maxAllowed, sortComparator);
    }

    static int capFileCount(File directory, int maxAllowed, Comparator<File> sortComparator) {
        return Utils.capFileCount(directory, ALL_FILES_FILTER, maxAllowed, sortComparator);
    }

    static int capFileCount(File directory, FilenameFilter filter, int maxAllowed, Comparator<File> sortComparator) {
        File[] sessionFiles = directory.listFiles(filter);
        if (sessionFiles == null) {
            return 0;
        }
        return Utils.capFileCount(Arrays.asList(sessionFiles), maxAllowed, sortComparator);
    }

    static int capFileCount(List<File> files, int maxAllowed, Comparator<File> sortComparator) {
        int numRetained = files.size();
        Collections.sort(files, sortComparator);
        for (File file : files) {
            if (numRetained <= maxAllowed) {
                return numRetained;
            }
            Utils.recursiveDelete(file);
            --numRetained;
        }
        return numRetained;
    }

    public static <T> Task<T> race(Task<T> t1, Task<T> t2) {
        final TaskCompletionSource result = new TaskCompletionSource();
        Continuation continuation = new Continuation<T, Void>(){

            public Void then(@NonNull Task<T> task) throws Exception {
                if (task.isSuccessful()) {
                    result.trySetResult(task.getResult());
                } else {
                    result.trySetException(task.getException());
                }
                return null;
            }
        };
        t1.continueWith(continuation);
        t2.continueWith(continuation);
        return result.getTask();
    }

    public static <T> Task<T> callTask(Executor executor, final Callable<Task<T>> callable) {
        final TaskCompletionSource tcs = new TaskCompletionSource();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ((Task)callable.call()).continueWith(new Continuation<T, Void>(){

                        public Void then(@NonNull Task<T> task) throws Exception {
                            if (task.isSuccessful()) {
                                tcs.setResult(task.getResult());
                            } else {
                                tcs.setException(task.getException());
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    tcs.setException(e);
                }
            }
        });
        return tcs.getTask();
    }

    public static <T> T awaitEvenIfOnMainThread(Task<T> task) throws InterruptedException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        task.continueWith((Executor)TASK_CONTINUATION_EXECUTOR_SERVICE, Utils$$Lambda$1.lambdaFactory$(latch));
        if (Looper.getMainLooper() == Looper.myLooper()) {
            latch.await(4L, TimeUnit.SECONDS);
        } else {
            latch.await();
        }
        if (task.isSuccessful()) {
            return (T)task.getResult();
        }
        if (task.isCanceled()) {
            throw new CancellationException("Task is already canceled");
        }
        if (task.isComplete()) {
            throw new IllegalStateException(task.getException());
        }
        throw new TimeoutException();
    }

    private static void recursiveDelete(File f) {
        if (f.isDirectory()) {
            for (File s : f.listFiles()) {
                Utils.recursiveDelete(s);
            }
        }
        f.delete();
    }

    static /* synthetic */ Object lambda$awaitEvenIfOnMainThread$0(CountDownLatch latch, Task unusedTask) throws Exception {
        latch.countDown();
        return null;
    }
}

