/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class CrashlyticsBackgroundWorker {
    private final Executor executor;
    private Task<Void> tail = Tasks.forResult(null);
    private final Object tailLock = new Object();
    private ThreadLocal<Boolean> isExecutorThread = new ThreadLocal();

    public CrashlyticsBackgroundWorker(Executor executor) {
        this.executor = executor;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                CrashlyticsBackgroundWorker.this.isExecutorThread.set(true);
            }
        });
    }

    public Executor getExecutor() {
        return this.executor;
    }

    private boolean isRunningOnThread() {
        return Boolean.TRUE.equals(this.isExecutorThread.get());
    }

    public void checkRunningOnThread() {
        if (!this.isRunningOnThread()) {
            throw new IllegalStateException("Not running on background worker thread as intended.");
        }
    }

    Task<Void> submit(final Runnable runnable) {
        return this.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    private <T> Continuation<Void, T> newContinuation(final Callable<T> callable) {
        return new Continuation<Void, T>(){

            public T then(@NonNull Task<Void> task) throws Exception {
                return callable.call();
            }
        };
    }

    private <T> Task<Void> ignoreResult(Task<T> task) {
        return task.continueWith(this.executor, new Continuation<T, Void>(){

            public Void then(@NonNull Task<T> task) throws Exception {
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Task<T> submit(Callable<T> callable) {
        Object object = this.tailLock;
        synchronized (object) {
            Task toReturn = this.tail.continueWith(this.executor, this.newContinuation(callable));
            this.tail = this.ignoreResult(toReturn);
            return toReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Task<T> submitTask(Callable<Task<T>> callable) {
        Object object = this.tailLock;
        synchronized (object) {
            Task toReturn = this.tail.continueWithTask(this.executor, this.newContinuation(callable));
            this.tail = this.ignoreResult(toReturn);
            return toReturn;
        }
    }
}

