/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.ndk;

import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.ndk.ProcMapEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ProcMapEntryParser {
    private static final Pattern MAP_REGEX = Pattern.compile("\\s*(\\p{XDigit}+)-\\s*(\\p{XDigit}+)\\s+(.{4})\\s+\\p{XDigit}+\\s+.+\\s+\\d+\\s+(.*)");

    private ProcMapEntryParser() {
    }

    @Nullable
    static ProcMapEntry parse(String mapEntry) {
        Matcher m = MAP_REGEX.matcher(mapEntry);
        if (!m.matches()) {
            return null;
        }
        try {
            long address = Long.valueOf(m.group(1), 16);
            long size = Long.valueOf(m.group(2), 16) - address;
            String perms = m.group(3);
            String path = m.group(4);
            return new ProcMapEntry(address, size, perms, path);
        }
        catch (Exception e) {
            Logger.getLogger().d("Could not parse map entry: " + mapEntry);
            return null;
        }
    }
}

