/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.report.network;

import com.google.firebase.crashlytics.internal.report.model.CreateReportRequest;
import com.google.firebase.crashlytics.internal.report.network.CreateReportSpiCall;
import com.google.firebase.crashlytics.internal.report.network.DefaultCreateReportSpiCall;
import com.google.firebase.crashlytics.internal.report.network.NativeCreateReportSpiCall;

public class CompositeCreateReportSpiCall
implements CreateReportSpiCall {
    private final DefaultCreateReportSpiCall javaReportSpiCall;
    private final NativeCreateReportSpiCall nativeReportSpiCall;

    public CompositeCreateReportSpiCall(DefaultCreateReportSpiCall javaReportSpiCall, NativeCreateReportSpiCall nativeReportSpiCall) {
        this.javaReportSpiCall = javaReportSpiCall;
        this.nativeReportSpiCall = nativeReportSpiCall;
    }

    @Override
    public boolean invoke(CreateReportRequest requestData, boolean dataCollectionToken) {
        switch (requestData.report.getType()) {
            case JAVA: {
                this.javaReportSpiCall.invoke(requestData, dataCollectionToken);
                return true;
            }
            case NATIVE: {
                this.nativeReportSpiCall.invoke(requestData, dataCollectionToken);
                return true;
            }
        }
        return false;
    }
}

