/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.InstallIdProvider;
import com.google.firebase.crashlytics.internal.common.InstallerPackageNameProvider;
import com.google.firebase.crashlytics.internal.common.Utils;
import com.google.firebase.installations.FirebaseInstallationsApi;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;

public class IdManager
implements InstallIdProvider {
    public static final String DEFAULT_VERSION_NAME = "0.0";
    static final String PREFKEY_ADVERTISING_ID = "crashlytics.advertising.id";
    static final String PREFKEY_INSTALLATION_UUID = "crashlytics.installation.id";
    static final String PREFKEY_FIREBASE_IID = "firebase.installation.id";
    static final String PREFKEY_LEGACY_INSTALLATION_UUID = "crashlytics.installation.id";
    private static final Pattern ID_PATTERN = Pattern.compile("[^\\p{Alnum}]");
    private static final String FORWARD_SLASH_REGEX = Pattern.quote("/");
    private final InstallerPackageNameProvider installerPackageNameProvider;
    private final Context appContext;
    private final String appIdentifier;
    private final FirebaseInstallationsApi firebaseInstallationsApi;
    private String crashlyticsInstallId;

    public IdManager(Context appContext, String appIdentifier, FirebaseInstallationsApi firebaseInstallationsApi) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext must not be null");
        }
        if (appIdentifier == null) {
            throw new IllegalArgumentException("appIdentifier must not be null");
        }
        this.appContext = appContext;
        this.appIdentifier = appIdentifier;
        this.firebaseInstallationsApi = firebaseInstallationsApi;
        this.installerPackageNameProvider = new InstallerPackageNameProvider();
    }

    private static String formatId(String id) {
        return id == null ? null : ID_PATTERN.matcher(id).replaceAll("").toLowerCase(Locale.US);
    }

    @Override
    @NonNull
    public synchronized String getCrashlyticsInstallId() {
        String cachedFid;
        String currentFid;
        SharedPreferences prefs;
        block10: {
            if (this.crashlyticsInstallId != null) {
                return this.crashlyticsInstallId;
            }
            Logger.getLogger().v("Determining Crashlytics installation ID...");
            prefs = CommonUtils.getSharedPrefs(this.appContext);
            Task currentFidTask = this.firebaseInstallationsApi.getId();
            currentFid = null;
            cachedFid = prefs.getString(PREFKEY_FIREBASE_IID, null);
            try {
                currentFid = (String)Utils.awaitEvenIfOnMainThread(currentFidTask);
            }
            catch (Exception e) {
                Logger.getLogger().w("Failed to retrieve Firebase Installations ID.", e);
                if (cachedFid == null) break block10;
                currentFid = cachedFid;
            }
        }
        if (cachedFid == null) {
            Logger.getLogger().v("No cached Firebase Installations ID found.");
            SharedPreferences legacyPrefs = CommonUtils.getLegacySharedPrefs(this.appContext);
            String legacyId = legacyPrefs.getString("crashlytics.installation.id", null);
            if (legacyId == null) {
                Logger.getLogger().v("No legacy Crashlytics installation ID found, creating new ID.");
                this.crashlyticsInstallId = this.createAndStoreIid(currentFid, prefs);
            } else {
                Logger.getLogger().v("A legacy Crashlytics installation ID was found. Upgrading.");
                this.crashlyticsInstallId = legacyId;
                this.migrateLegacyId(legacyId, currentFid, prefs, legacyPrefs);
            }
        } else if (cachedFid.equals(currentFid)) {
            this.crashlyticsInstallId = prefs.getString("crashlytics.installation.id", null);
            Logger.getLogger().v("Firebase Installations ID is unchanged from previous startup.");
            if (this.crashlyticsInstallId == null) {
                Logger.getLogger().v("Crashlytics installation ID was null, creating new ID.");
                this.crashlyticsInstallId = this.createAndStoreIid(currentFid, prefs);
            }
        } else {
            this.crashlyticsInstallId = this.createAndStoreIid(currentFid, prefs);
        }
        Logger.getLogger().v("Crashlytics installation ID is " + this.crashlyticsInstallId);
        return this.crashlyticsInstallId;
    }

    private synchronized void migrateLegacyId(String legacyId, String fidToCache, SharedPreferences prefs, SharedPreferences legacyPrefs) {
        Logger.getLogger().v("Migrating legacy Crashlytics installation ID: " + legacyId);
        prefs.edit().putString("crashlytics.installation.id", legacyId).putString(PREFKEY_FIREBASE_IID, fidToCache).apply();
        legacyPrefs.edit().remove("crashlytics.installation.id").remove(PREFKEY_ADVERTISING_ID).apply();
    }

    private synchronized String createAndStoreIid(String fidToCache, SharedPreferences prefs) {
        String iid = IdManager.formatId(UUID.randomUUID().toString());
        Logger.getLogger().v("Created new Crashlytics installation ID: " + iid);
        prefs.edit().putString("crashlytics.installation.id", iid).putString(PREFKEY_FIREBASE_IID, fidToCache).apply();
        return iid;
    }

    public String getAppIdentifier() {
        return this.appIdentifier;
    }

    public String getOsDisplayVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.RELEASE);
    }

    public String getOsBuildVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.INCREMENTAL);
    }

    public String getModelName() {
        return String.format(Locale.US, "%s/%s", this.removeForwardSlashesIn(Build.MANUFACTURER), this.removeForwardSlashesIn(Build.MODEL));
    }

    private String removeForwardSlashesIn(String s) {
        return s.replaceAll(FORWARD_SLASH_REGEX, "");
    }

    public String getInstallerPackageName() {
        return this.installerPackageNameProvider.getInstallerPackageName(this.appContext);
    }
}

