/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.annotations.DeferredApi;
import com.google.firebase.crashlytics.CrashlyticsAnalyticsListener;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.BlockingAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.BreadcrumbAnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.analytics.CrashlyticsOriginAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.UnavailableAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbHandler;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbSource;
import com.google.firebase.crashlytics.internal.breadcrumbs.DisabledBreadcrumbSource;
import com.google.firebase.inject.Deferred;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AnalyticsDeferredProxy {
    private final Deferred<AnalyticsConnector> analyticsConnectorDeferred;
    private volatile AnalyticsEventLogger analyticsEventLogger;
    private volatile BreadcrumbSource breadcrumbSource;
    @GuardedBy(value="this")
    private final List<BreadcrumbHandler> breadcrumbHandlerList;

    public AnalyticsDeferredProxy(Deferred<AnalyticsConnector> analyticsConnectorDeferred) {
        this(analyticsConnectorDeferred, new DisabledBreadcrumbSource(), new UnavailableAnalyticsEventLogger());
    }

    public AnalyticsDeferredProxy(Deferred<AnalyticsConnector> analyticsConnectorDeferred, @NonNull BreadcrumbSource breadcrumbSource, @NonNull AnalyticsEventLogger analyticsEventLogger) {
        this.analyticsConnectorDeferred = analyticsConnectorDeferred;
        this.breadcrumbSource = breadcrumbSource;
        this.breadcrumbHandlerList = new ArrayList<BreadcrumbHandler>();
        this.analyticsEventLogger = analyticsEventLogger;
        this.init();
    }

    public BreadcrumbSource getDeferredBreadcrumbSource() {
        return breadcrumbHandler -> {
            AnalyticsDeferredProxy analyticsDeferredProxy = this;
            synchronized (analyticsDeferredProxy) {
                if (this.breadcrumbSource instanceof DisabledBreadcrumbSource) {
                    this.breadcrumbHandlerList.add(breadcrumbHandler);
                }
                this.breadcrumbSource.registerBreadcrumbHandler(breadcrumbHandler);
            }
        };
    }

    public AnalyticsEventLogger getAnalyticsEventLogger() {
        return (name, params) -> this.analyticsEventLogger.logEvent(name, params);
    }

    private void init() {
        this.analyticsConnectorDeferred.whenAvailable(analyticsConnector -> {
            AnalyticsConnector connector = (AnalyticsConnector)analyticsConnector.get();
            CrashlyticsOriginAnalyticsEventLogger directAnalyticsEventLogger = new CrashlyticsOriginAnalyticsEventLogger(connector);
            CrashlyticsAnalyticsListener crashlyticsAnalyticsListener = new CrashlyticsAnalyticsListener();
            AnalyticsConnector.AnalyticsConnectorHandle analyticsConnectorHandle = AnalyticsDeferredProxy.subscribeToAnalyticsEvents(connector, crashlyticsAnalyticsListener);
            if (analyticsConnectorHandle != null) {
                Logger.getLogger().d("Registered Firebase Analytics listener.");
                BreadcrumbAnalyticsEventReceiver breadcrumbReceiver = new BreadcrumbAnalyticsEventReceiver();
                BlockingAnalyticsEventLogger blockingAnalyticsEventLogger = new BlockingAnalyticsEventLogger(directAnalyticsEventLogger, 500, TimeUnit.MILLISECONDS);
                AnalyticsDeferredProxy analyticsDeferredProxy = this;
                synchronized (analyticsDeferredProxy) {
                    for (BreadcrumbHandler handler : this.breadcrumbHandlerList) {
                        breadcrumbReceiver.registerBreadcrumbHandler(handler);
                    }
                    crashlyticsAnalyticsListener.setBreadcrumbEventReceiver(breadcrumbReceiver);
                    crashlyticsAnalyticsListener.setCrashlyticsOriginEventReceiver(blockingAnalyticsEventLogger);
                    this.breadcrumbSource = breadcrumbReceiver;
                    this.analyticsEventLogger = blockingAnalyticsEventLogger;
                }
            } else {
                Logger.getLogger().w("Could not register Firebase Analytics listener; a listener is already registered.");
            }
        });
    }

    @DeferredApi
    private static AnalyticsConnector.AnalyticsConnectorHandle subscribeToAnalyticsEvents(@NonNull AnalyticsConnector analyticsConnector, @NonNull CrashlyticsAnalyticsListener listener) {
        AnalyticsConnector.AnalyticsConnectorHandle handle = analyticsConnector.registerAnalyticsConnectorListener("clx", (AnalyticsConnector.AnalyticsConnectorListener)listener);
        if (handle == null) {
            Logger.getLogger().d("Could not register AnalyticsConnectorListener with Crashlytics origin.");
            handle = analyticsConnector.registerAnalyticsConnectorListener("crash", (AnalyticsConnector.AnalyticsConnectorListener)listener);
            if (handle != null) {
                Logger.getLogger().w("A new version of the Google Analytics for Firebase SDK is now available. For improved performance and compatibility with Crashlytics, please update to the latest version.");
            }
        }
        return handle;
    }
}

