/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.stacktrace;

import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;

public class TrimmedThrowableData {
    public final String localizedMessage;
    public final String className;
    public final StackTraceElement[] stacktrace;
    public final TrimmedThrowableData cause;

    public TrimmedThrowableData(Throwable ex, StackTraceTrimmingStrategy trimmingStrategy) {
        this.localizedMessage = ex.getLocalizedMessage();
        this.className = ex.getClass().getName();
        this.stacktrace = trimmingStrategy.getTrimmedStackTrace(ex.getStackTrace());
        Throwable exCause = ex.getCause();
        this.cause = exCause != null ? new TrimmedThrowableData(exCause, trimmingStrategy) : null;
    }
}

