/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class MetaDataStore {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String KEY_USER_ID = "userId";
    private final FileStore fileStore;

    public MetaDataStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUserData(String sessionId, String userId) {
        File f = this.getUserDataFileForSession(sessionId);
        BufferedWriter writer = null;
        try {
            String userIdJson = MetaDataStore.userIdToJson(userId);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(userIdJson);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog(writer, "Failed to close user metadata file.");
        }
        catch (Exception e) {
            Logger.getLogger().w("Error serializing user metadata.", e);
        }
        finally {
            CommonUtils.closeOrLog(writer, "Failed to close user metadata file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String readUserId(String sessionId) {
        File f = this.getUserDataFileForSession(sessionId);
        if (!f.exists() || f.length() == 0L) {
            Logger.getLogger().d("No userId set for session " + sessionId);
            MetaDataStore.safeDeleteCorruptFile(f);
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            String userId = this.jsonToUserId(CommonUtils.streamToString(is));
            Logger.getLogger().d("Loaded userId " + userId + " for session " + sessionId);
            String string = userId;
            return string;
        }
        catch (Exception e) {
            Logger.getLogger().w("Error deserializing user metadata.", e);
            MetaDataStore.safeDeleteCorruptFile(f);
        }
        finally {
            CommonUtils.closeOrLog(is, "Failed to close user metadata file.");
        }
        return null;
    }

    public void writeKeyData(String sessionId, Map<String, String> keyData) {
        this.writeKeyData(sessionId, keyData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeyData(String sessionId, Map<String, String> keyData, boolean isInternal) {
        File f = isInternal ? this.getInternalKeysFileForSession(sessionId) : this.getKeysFileForSession(sessionId);
        BufferedWriter writer = null;
        try {
            String keyDataString = MetaDataStore.keysDataToJson(keyData);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(keyDataString);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog(writer, "Failed to close key/value metadata file.");
        }
        catch (Exception e) {
            Logger.getLogger().w("Error serializing key/value metadata.", e);
            MetaDataStore.safeDeleteCorruptFile(f);
        }
        finally {
            CommonUtils.closeOrLog(writer, "Failed to close key/value metadata file.");
        }
    }

    public Map<String, String> readKeyData(String sessionId) {
        return this.readKeyData(sessionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> readKeyData(String sessionId, boolean isInternal) {
        File f;
        File file = f = isInternal ? this.getInternalKeysFileForSession(sessionId) : this.getKeysFileForSession(sessionId);
        if (!f.exists() || f.length() == 0L) {
            MetaDataStore.safeDeleteCorruptFile(f);
            return Collections.emptyMap();
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            Map<String, String> map = MetaDataStore.jsonToKeysData(CommonUtils.streamToString(is));
            return map;
        }
        catch (Exception e) {
            Logger.getLogger().w("Error deserializing user metadata.", e);
            MetaDataStore.safeDeleteCorruptFile(f);
        }
        finally {
            CommonUtils.closeOrLog(is, "Failed to close user metadata file.");
        }
        return Collections.emptyMap();
    }

    @NonNull
    public File getUserDataFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, "user-data");
    }

    @NonNull
    public File getKeysFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, "keys");
    }

    @NonNull
    public File getInternalKeysFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, "internal-keys");
    }

    @Nullable
    private String jsonToUserId(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        return MetaDataStore.valueOrNull(dataObj, KEY_USER_ID);
    }

    private static String userIdToJson(final String userId) throws JSONException {
        return new JSONObject(){
            {
                this.put(MetaDataStore.KEY_USER_ID, userId);
            }
        }.toString();
    }

    private static Map<String, String> jsonToKeysData(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        HashMap<String, String> keyData = new HashMap<String, String>();
        Iterator keyIter = dataObj.keys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            keyData.put(key, MetaDataStore.valueOrNull(dataObj, key));
        }
        return keyData;
    }

    private static String keysDataToJson(Map<String, String> keyData) {
        return new JSONObject(keyData).toString();
    }

    private static String valueOrNull(JSONObject json, String key) {
        return !json.isNull(key) ? json.optString(key, null) : null;
    }

    private static void safeDeleteCorruptFile(File file) {
        if (file.exists() && file.delete()) {
            Logger.getLogger().i("Deleted corrupt file: " + file.getAbsolutePath());
        }
    }
}

