/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

public class Settings {
    public final SessionData sessionData;
    public final FeatureFlagData featureFlagData;
    public final long expiresAtMillis;
    public final int settingsVersion;
    public final int cacheDuration;
    public final double onDemandUploadRatePerMinute;
    public final double onDemandBackoffBase;
    public final int onDemandBackoffStepDurationSeconds;

    public Settings(long expiresAtMillis, SessionData sessionData, FeatureFlagData featureFlagData, int settingsVersion, int cacheDuration, double onDemandUploadRatePerMinute, double onDemandBackoffBase, int onDemandBackoffStepDurationSeconds) {
        this.expiresAtMillis = expiresAtMillis;
        this.sessionData = sessionData;
        this.featureFlagData = featureFlagData;
        this.settingsVersion = settingsVersion;
        this.cacheDuration = cacheDuration;
        this.onDemandUploadRatePerMinute = onDemandUploadRatePerMinute;
        this.onDemandBackoffBase = onDemandBackoffBase;
        this.onDemandBackoffStepDurationSeconds = onDemandBackoffStepDurationSeconds;
    }

    public boolean isExpired(long currentTimeMillis) {
        return this.expiresAtMillis < currentTimeMillis;
    }

    public static class FeatureFlagData {
        public final boolean collectReports;
        public final boolean collectAnrs;
        public final boolean collectBuildIds;

        public FeatureFlagData(boolean collectReports, boolean collectAnrs, boolean collectBuildIds) {
            this.collectReports = collectReports;
            this.collectAnrs = collectAnrs;
            this.collectBuildIds = collectBuildIds;
        }
    }

    public static class SessionData {
        public final int maxCustomExceptionEvents;
        public final int maxCompleteSessionsCount;

        public SessionData(int maxCustomExceptionEvents, int maxCompleteSessionsCount) {
            this.maxCustomExceptionEvents = maxCustomExceptionEvents;
            this.maxCompleteSessionsCount = maxCompleteSessionsCount;
        }
    }
}

