/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.stacktrace;

import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import java.util.Stack;

public class TrimmedThrowableData {
    public final String localizedMessage;
    public final String className;
    public final StackTraceElement[] stacktrace;
    @Nullable
    public final TrimmedThrowableData cause;

    private TrimmedThrowableData(String localizedMessage, String className, StackTraceElement[] stacktrace, @Nullable TrimmedThrowableData cause) {
        this.localizedMessage = localizedMessage;
        this.className = className;
        this.stacktrace = stacktrace;
        this.cause = cause;
    }

    public static TrimmedThrowableData makeTrimmedThrowableData(Throwable ex, StackTraceTrimmingStrategy trimmingStrategy) {
        Stack<Throwable> throwableStack = new Stack<Throwable>();
        for (Throwable exCause = ex; exCause != null; exCause = exCause.getCause()) {
            throwableStack.push(exCause);
        }
        TrimmedThrowableData trimmedThrowableData = null;
        while (!throwableStack.isEmpty()) {
            Throwable throwable = (Throwable)throwableStack.pop();
            trimmedThrowableData = new TrimmedThrowableData(throwable.getLocalizedMessage(), throwable.getClass().getName(), trimmingStrategy.getTrimmedStackTrace(throwable.getStackTrace()), trimmedThrowableData);
        }
        return trimmedThrowableData;
    }
}

