/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import com.google.firebase.crashlytics.internal.CrashlyticsRemoteConfigListener;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata;
import com.google.firebase.inject.Deferred;
import com.google.firebase.remoteconfig.interop.FirebaseRemoteConfigInterop;
import com.google.firebase.remoteconfig.interop.rollouts.RolloutsStateSubscriber;

public class RemoteConfigDeferredProxy {
    private final Deferred<FirebaseRemoteConfigInterop> remoteConfigInteropDeferred;

    public RemoteConfigDeferredProxy(Deferred<FirebaseRemoteConfigInterop> remoteConfigInteropDeferred) {
        this.remoteConfigInteropDeferred = remoteConfigInteropDeferred;
    }

    public void setupListener(UserMetadata metadata) {
        if (metadata == null) {
            Logger.getLogger().w("Didn't successfully register with UserMetadata for rollouts listener");
            return;
        }
        CrashlyticsRemoteConfigListener listener = new CrashlyticsRemoteConfigListener(metadata);
        this.remoteConfigInteropDeferred.whenAvailable(remoteConfigInteropProvider -> {
            FirebaseRemoteConfigInterop interop = (FirebaseRemoteConfigInterop)remoteConfigInteropProvider.get();
            interop.registerRolloutsStateSubscriber("firebase", (RolloutsStateSubscriber)listener);
            Logger.getLogger().d("Registering RemoteConfig Rollouts subscriber");
        });
    }
}

