/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.utilities;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.utilities.TreeNode;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.snapshot.ChildKey;
import java.util.Map;

public class Tree<T> {
    private ChildKey name;
    private Tree<T> parent;
    private TreeNode<T> node;

    public Tree(ChildKey name, Tree<T> parent, TreeNode<T> node) {
        this.name = name;
        this.parent = parent;
        this.node = node;
    }

    public Tree() {
        this(null, null, new TreeNode());
    }

    public TreeNode<T> lastNodeOnPath(Path path) {
        TreeNode<T> current = this.node;
        ChildKey next = path.getFront();
        while (next != null) {
            TreeNode childNode;
            TreeNode treeNode = childNode = current.children.containsKey(next) ? current.children.get(next) : null;
            if (childNode == null) {
                return current;
            }
            current = childNode;
            path = path.popFront();
            next = path.getFront();
        }
        return current;
    }

    public Tree<T> subTree(Path path) {
        Tree child = this;
        ChildKey next = path.getFront();
        while (next != null) {
            TreeNode childNode = child.node.children.containsKey(next) ? child.node.children.get(next) : new TreeNode();
            child = new Tree(next, child, childNode);
            path = path.popFront();
            next = path.getFront();
        }
        return child;
    }

    public T getValue() {
        return this.node.value;
    }

    public void setValue(T value) {
        this.node.value = value;
        this.updateParents();
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public ChildKey getName() {
        return this.name;
    }

    public Path getPath() {
        if (this.parent != null) {
            Utilities.hardAssert(this.name != null);
            return this.parent.getPath().child(this.name);
        }
        return this.name != null ? new Path(this.name) : Path.getEmptyPath();
    }

    public boolean hasChildren() {
        return !this.node.children.isEmpty();
    }

    public boolean isEmpty() {
        return this.node.value == null && this.node.children.isEmpty();
    }

    public void forEachDescendant(TreeVisitor<T> visitor) {
        this.forEachDescendant(visitor, false, false);
    }

    public void forEachDescendant(TreeVisitor<T> visitor, boolean includeSelf) {
        this.forEachDescendant(visitor, includeSelf, false);
    }

    public void forEachDescendant(final TreeVisitor<T> visitor, boolean includeSelf, final boolean childrenFirst) {
        if (includeSelf && !childrenFirst) {
            visitor.visitTree(this);
        }
        this.forEachChild(new TreeVisitor<T>(){

            @Override
            public void visitTree(Tree<T> tree) {
                tree.forEachDescendant(visitor, true, childrenFirst);
            }
        });
        if (includeSelf && childrenFirst) {
            visitor.visitTree(this);
        }
    }

    public boolean forEachAncestor(TreeFilter<T> filter) {
        return this.forEachAncestor(filter, false);
    }

    public boolean forEachAncestor(TreeFilter<T> filter, boolean includeSelf) {
        Tree<T> tree;
        Tree<T> tree2 = tree = includeSelf ? this : this.parent;
        while (tree != null) {
            if (filter.filterTreeNode(tree)) {
                return true;
            }
            tree = tree.parent;
        }
        return false;
    }

    public void forEachChild(TreeVisitor<T> visitor) {
        Object[] entries = this.node.children.entrySet().toArray();
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry entry = (Map.Entry)entries[i];
            Tree<T> subTree = new Tree<T>((ChildKey)entry.getKey(), this, (TreeNode)entry.getValue());
            visitor.visitTree(subTree);
        }
    }

    private void updateParents() {
        if (this.parent != null) {
            super.updateChild(this.name, this);
        }
    }

    private void updateChild(ChildKey name, Tree<T> child) {
        boolean childEmpty = child.isEmpty();
        boolean childExists = this.node.children.containsKey(name);
        if (childEmpty && childExists) {
            this.node.children.remove(name);
            this.updateParents();
        } else if (!childEmpty && !childExists) {
            this.node.children.put(name, child.node);
            this.updateParents();
        }
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String prefix) {
        String nodeName = this.name == null ? "<anon>" : this.name.asString();
        return prefix + nodeName + "\n" + this.node.toString(prefix + "\t");
    }

    public static interface TreeFilter<T> {
        public boolean filterTreeNode(Tree<T> var1);
    }

    public static interface TreeVisitor<T> {
        public void visitTree(Tree<T> var1);
    }
}

