/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.ChildrenNode;
import com.google.firebase.database.snapshot.DoubleNode;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.LongNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public abstract class LeafNode<T extends LeafNode>
implements Node {
    protected final Node priority;
    private String lazyHash;

    LeafNode(Node priority) {
        this.priority = priority;
    }

    @Override
    public boolean hasChild(ChildKey childKey) {
        return false;
    }

    @Override
    public boolean isLeafNode() {
        return true;
    }

    @Override
    public Node getPriority() {
        return this.priority;
    }

    @Override
    public Node getChild(Path path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.getFront().isPriorityChildName()) {
            return this.priority;
        }
        return EmptyNode.Empty();
    }

    @Override
    public Node updateChild(Path path, Node node) {
        ChildKey front = path.getFront();
        if (front == null) {
            return node;
        }
        if (node.isEmpty() && !front.isPriorityChildName()) {
            return this;
        }
        Utilities.hardAssert(!path.getFront().isPriorityChildName() || path.size() == 1);
        return this.updateImmediateChild(front, EmptyNode.Empty().updateChild(path.popFront(), node));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public ChildKey getPredecessorChildKey(ChildKey childKey) {
        return null;
    }

    @Override
    public ChildKey getSuccessorChildKey(ChildKey childKey) {
        return null;
    }

    @Override
    public Node getImmediateChild(ChildKey name) {
        if (name.isPriorityChildName()) {
            return this.priority;
        }
        return EmptyNode.Empty();
    }

    @Override
    public Object getValue(boolean useExportFormat) {
        if (!useExportFormat || this.priority.isEmpty()) {
            return this.getValue();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(".value", this.getValue());
        result.put(".priority", this.priority.getValue());
        return result;
    }

    @Override
    public Node updateImmediateChild(ChildKey name, Node node) {
        if (name.isPriorityChildName()) {
            return this.updatePriority(node);
        }
        if (node.isEmpty()) {
            return this;
        }
        return EmptyNode.Empty().updateImmediateChild(name, node).updatePriority(this.priority);
    }

    @Override
    public String getHash() {
        if (this.lazyHash == null) {
            this.lazyHash = Utilities.sha1HexDigest(this.getHashRepresentation(Node.HashVersion.V1));
        }
        return this.lazyHash;
    }

    protected String getPriorityHash(Node.HashVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                if (this.priority.isEmpty()) {
                    return "";
                }
                return "priority:" + this.priority.getHashRepresentation(version) + ":";
            }
        }
        throw new IllegalArgumentException("Unknown hash version: " + (Object)((Object)version));
    }

    protected abstract LeafType getLeafType();

    @Override
    public Iterator<NamedNode> iterator() {
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator<NamedNode> reverseIterator() {
        return Collections.emptyList().iterator();
    }

    private static int compareLongDoubleNodes(LongNode longNode, DoubleNode doubleNode) {
        Double longDoubleValue = (double)((Long)longNode.getValue());
        return longDoubleValue.compareTo((Double)doubleNode.getValue());
    }

    @Override
    public int compareTo(Node other) {
        if (other.isEmpty()) {
            return 1;
        }
        if (other instanceof ChildrenNode) {
            return -1;
        }
        Utilities.hardAssert(other.isLeafNode(), "Node is not leaf node!");
        if (this instanceof LongNode && other instanceof DoubleNode) {
            return LeafNode.compareLongDoubleNodes((LongNode)this, (DoubleNode)other);
        }
        if (this instanceof DoubleNode && other instanceof LongNode) {
            return -1 * LeafNode.compareLongDoubleNodes((LongNode)other, (DoubleNode)this);
        }
        return this.leafCompare((LeafNode)other);
    }

    protected abstract int compareLeafValues(T var1);

    protected int leafCompare(LeafNode<?> other) {
        LeafType otherLeafType;
        LeafType thisLeafType = this.getLeafType();
        if (thisLeafType.equals((Object)(otherLeafType = other.getLeafType()))) {
            int value = this.compareLeafValues(other);
            return value;
        }
        return thisLeafType.compareTo(otherLeafType);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        String str = this.getValue(true).toString();
        return str.length() <= 100 ? str : str.substring(0, 100) + "...";
    }

    protected static enum LeafType {
        DeferredValue,
        Boolean,
        Number,
        String;

    }
}

