/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.snapshot.BooleanNode;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.ChildrenNode;
import com.google.firebase.database.snapshot.DeferredValueNode;
import com.google.firebase.database.snapshot.DoubleNode;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.LongNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.PriorityUtilities;
import com.google.firebase.database.snapshot.StringNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeUtilities {
    public static Node NodeFromJSON(Object value) throws DatabaseException {
        return NodeUtilities.NodeFromJSON(value, PriorityUtilities.NullPriority());
    }

    public static Node NodeFromJSON(Object value, Node priority) throws DatabaseException {
        try {
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                if (mapValue.containsKey(".priority")) {
                    priority = PriorityUtilities.parsePriority(mapValue.get(".priority"));
                }
                if (mapValue.containsKey(".value")) {
                    value = mapValue.get(".value");
                }
            }
            if (value == null) {
                return EmptyNode.Empty();
            }
            if (value instanceof String) {
                return new StringNode((String)value, priority);
            }
            if (value instanceof Long) {
                return new LongNode((Long)value, priority);
            }
            if (value instanceof Integer) {
                return new LongNode((long)((Integer)value), priority);
            }
            if (value instanceof Double) {
                return new DoubleNode((Double)value, priority);
            }
            if (value instanceof Boolean) {
                return new BooleanNode((Boolean)value, priority);
            }
            if (value instanceof Map || value instanceof List) {
                HashMap<ChildKey, Node> childData;
                if (value instanceof Map) {
                    Map mapValue = (Map)value;
                    if (mapValue.containsKey(".sv")) {
                        DeferredValueNode node = new DeferredValueNode(mapValue, priority);
                        return node;
                    }
                    childData = new HashMap(mapValue.size());
                    for (String key : mapValue.keySet()) {
                        Node childNode;
                        if (key.startsWith(".") || (childNode = NodeUtilities.NodeFromJSON(mapValue.get(key))).isEmpty()) continue;
                        ChildKey childKey = ChildKey.fromString(key);
                        childData.put(childKey, childNode);
                    }
                } else {
                    List listValue = (List)value;
                    childData = new HashMap<ChildKey, Node>(listValue.size());
                    for (int i = 0; i < listValue.size(); ++i) {
                        String key = "" + i;
                        Node childNode = NodeUtilities.NodeFromJSON(listValue.get(i));
                        if (childNode.isEmpty()) continue;
                        ChildKey childKey = ChildKey.fromString(key);
                        childData.put(childKey, childNode);
                    }
                }
                if (childData.isEmpty()) {
                    return EmptyNode.Empty();
                }
                ImmutableSortedMap childSet = ImmutableSortedMap.Builder.fromMap(childData, ChildrenNode.NAME_ONLY_COMPARATOR);
                return new ChildrenNode((ImmutableSortedMap<ChildKey, Node>)childSet, priority);
            }
            throw new DatabaseException("Failed to parse node with class " + value.getClass().toString());
        }
        catch (ClassCastException e) {
            throw new DatabaseException("Failed to parse node", e);
        }
    }

    public static int nameAndPriorityCompare(ChildKey aKey, Node aPriority, ChildKey bKey, Node bPriority) {
        int priCmp = aPriority.compareTo(bPriority);
        if (priCmp != 0) {
            return priCmp;
        }
        return aKey.compareTo(bKey);
    }
}

