/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzdox;
import com.google.android.gms.internal.zzeco;
import com.google.android.gms.internal.zzedk;
import com.google.android.gms.internal.zzedp;
import com.google.android.gms.internal.zzeen;
import com.google.android.gms.internal.zzega;
import com.google.android.gms.internal.zzegf;
import com.google.android.gms.internal.zzegm;
import com.google.android.gms.internal.zzego;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzegv;
import com.google.android.gms.internal.zzejm;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzekp;
import com.google.android.gms.internal.zzeuk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class zzeej
implements zzeen {
    private final List<zzegv> zzmva = new ArrayList<zzegv>();
    private zzdox<zzedk> zzmvb = new zzdox(Collections.emptyList(), zzedk.zzmtv);
    private int zzmvc = 1;
    private int zzmvd = -1;
    private zzeuk zzmve = zzejm.zzncy;
    private zzedp zzmuh;

    zzeej() {
    }

    @Override
    public final void start() {
        if (this.zzmva.isEmpty()) {
            this.zzmvc = 1;
            this.zzmvd = -1;
        }
        zzejo.zzc(this.zzmvd < this.zzmvc, "highestAcknowledgedBatchId must be less than the nextBatchId", new Object[0]);
    }

    @Override
    public final int zzcax() {
        return this.zzmvd;
    }

    @Override
    public final void zza(zzegv zzegv2, zzeuk zzeuk2) {
        int n = zzegv2.zzcav();
        zzejo.zzc(n > this.zzmvd, "Mutation batchIds must be acknowledged in order", new Object[0]);
        int n2 = this.zzl(n, "acknowledged");
        zzegv zzegv3 = this.zzmva.get(n2);
        zzejo.zzc(n == zzegv3.zzcav(), "Queue ordering failure: expected batch %d, got batch %d", n, zzegv3.zzcav());
        zzejo.zzc(!zzegv3.zzccl(), "Can't acknowledge a previously removed batch", new Object[0]);
        this.zzmvd = n;
        this.zzmve = (zzeuk)zzbp.zzu((Object)zzeuk2);
    }

    @Override
    public final zzeuk zzcap() {
        return this.zzmve;
    }

    @Override
    public final void zzac(zzeuk zzeuk2) {
        this.zzmve = (zzeuk)zzbp.zzu((Object)zzeuk2);
    }

    @Override
    public final zzegv zzb(zzego zzego2, List<zzegu> list) {
        zzejo.zzc(!list.isEmpty(), "Mutation batches should not be empty", new Object[0]);
        int n = this.zzmvc++;
        int n2 = this.zzmva.size();
        if (n2 > 0) {
            zzejo.zzc(this.zzmva.get(n2 - 1).zzcav() < n, "Mutation batchIds must be monotonically increasing order", new Object[0]);
        }
        zzegv zzegv2 = new zzegv(n, zzego2, list);
        this.zzmva.add(zzegv2);
        for (zzegu zzegu2 : list) {
            this.zzmvb = this.zzmvb.zzbf((Object)new zzedk(zzegu2.zzbyq(), n));
        }
        return zzegv2;
    }

    @Override
    public final zzegv zzgj(int n) {
        int n2 = this.zzgn(n);
        if (n2 < 0 || n2 >= this.zzmva.size()) {
            return null;
        }
        zzegv zzegv2 = this.zzmva.get(n2);
        zzejo.zzc(zzegv2.zzcav() == n, "If found batch must match", new Object[0]);
        if (zzegv2.zzccl()) {
            return null;
        }
        return zzegv2;
    }

    @Override
    public final zzegv zzgk(int n) {
        int n2;
        int n3 = this.zzmva.size();
        int n4 = this.zzgn(n = Math.max(n + 1, this.zzmvd));
        int n5 = n2 = n4 < 0 ? 0 : n4;
        while (n2 < n3) {
            zzegv zzegv2 = this.zzmva.get(n2);
            if (!zzegv2.zzccl()) {
                return zzegv2;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public final List<zzegv> zzcay() {
        return this.zzgm(this.zzmva.size());
    }

    @Override
    public final List<zzegv> zzgl(int n) {
        int n2 = this.zzmva.size();
        int n3 = this.zzgn(n);
        n3 = n3 < 0 ? 0 : (n3 >= n2 ? n2 : ++n3);
        return this.zzgm(n3);
    }

    @Override
    public final List<zzegv> zzf(zzegf zzegf2) {
        zzedk zzedk2;
        zzedk zzedk3 = new zzedk(zzegf2, 0);
        ArrayList<zzegv> arrayList = new ArrayList<zzegv>();
        Iterator iterator = this.zzmvb.zzaz((Object)zzedk3);
        while (iterator.hasNext() && zzegf2.equals((zzedk2 = (zzedk)iterator.next()).zzbyq())) {
            zzegv zzegv2 = this.zzgj(zzedk2.getId());
            zzejo.zzc(zzegv2 != null, "Batches in the index must exist in the main table", new Object[0]);
            arrayList.add(zzegv2);
        }
        return arrayList;
    }

    @Override
    public final List<zzegv> zzh(zzeco zzeco2) {
        Object object;
        Object object2;
        zzegm zzegm2 = zzeco2.zzbzm();
        int n = zzegm2.length() + 1;
        zzegm zzegm3 = zzegm2;
        if (!zzegf.zzc(zzegm3)) {
            zzegm3 = (zzegm)zzegm3.zzql("");
        }
        zzedk zzedk2 = new zzedk(zzegf.zzb(zzegm3), 0);
        zzdox zzdox2 = new zzdox(Collections.emptyList(), zzekp.comparator());
        Iterator iterator = this.zzmvb.zzaz((Object)zzedk2);
        while (iterator.hasNext() && zzegm2.zzd(object2 = ((zzedk)(object = (zzedk)iterator.next())).zzbyq().zzbzm())) {
            if (((zzega)object2).length() != n) continue;
            zzdox2 = zzdox2.zzbf((Object)((zzedk)object).getId());
        }
        object = new ArrayList();
        for (Integer n2 : zzdox2) {
            zzegv zzegv2 = this.zzgj(n2);
            if (zzegv2 == null) continue;
            object.add(zzegv2);
        }
        return object;
    }

    @Override
    public final void zzbc(List<zzegv> list) {
        int n = list.size();
        zzejo.zzc(n > 0, "Should not remove mutations when none exist.", new Object[0]);
        int n2 = list.get(0).zzcav();
        int n3 = this.zzmva.size();
        int n4 = this.zzl(n2, "removed");
        zzejo.zzc(this.zzmva.get(n4).zzcav() == n2, "Removed batches must exist in the queue", new Object[0]);
        int n5 = 1;
        int n6 = n4 + 1;
        while (n5 < n && n6 < n3) {
            zzegv zzegv2 = this.zzmva.get(n6);
            if (zzegv2.zzccl()) {
                ++n6;
                continue;
            }
            zzejo.zzc(zzegv2.zzcav() == list.get(n5).zzcav(), "Removed batches must be contiguous in the queue", new Object[0]);
            ++n5;
            ++n6;
        }
        if (n4 == 0) {
            while (n6 < n3 && this.zzmva.get(n6).zzccl()) {
                ++n6;
            }
            this.zzmva.subList(n4, n6).clear();
        } else {
            for (int i = n4; i < n6; ++i) {
                this.zzmva.set(i, this.zzmva.get(i).zzccm());
            }
        }
        zzdox zzdox2 = this.zzmvb;
        for (zzegv zzegv3 : list) {
            int n7 = zzegv3.zzcav();
            Iterator<zzegu> iterator = zzegv3.zzccn().iterator();
            while (iterator.hasNext()) {
                zzegf zzegf2 = iterator.next().zzbyq();
                if (this.zzmuh != null) {
                    this.zzmuh.zzc(zzegf2);
                }
                zzedk zzedk2 = new zzedk(zzegf2, n7);
                zzdox2 = zzdox2.zzbe((Object)zzedk2);
            }
        }
        this.zzmvb = zzdox2;
    }

    @Override
    public final void zzcaz() {
        if (this.zzmva.isEmpty()) {
            zzejo.zzc(this.zzmvb.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty.", new Object[0]);
        }
    }

    @Override
    public final void zza(zzedp zzedp2) {
        this.zzmuh = zzedp2;
    }

    @Override
    public final boolean zzd(zzegf zzegf2) {
        zzedk zzedk2 = new zzedk(zzegf2, 0);
        Iterator iterator = this.zzmvb.zzaz((Object)zzedk2);
        if (!iterator.hasNext()) {
            return false;
        }
        return ((zzedk)iterator.next()).zzbyq().equals(zzegf2);
    }

    private final List<zzegv> zzgm(int n) {
        ArrayList<zzegv> arrayList = new ArrayList<zzegv>(n);
        for (int i = 0; i < n; ++i) {
            zzegv zzegv2 = this.zzmva.get(i);
            if (zzegv2.zzccl()) continue;
            arrayList.add(zzegv2);
        }
        return arrayList;
    }

    private final int zzgn(int n) {
        if (this.zzmva.isEmpty()) {
            return 0;
        }
        int n2 = this.zzmva.get(0).zzcav();
        return n - n2;
    }

    private final int zzl(int n, String string) {
        int n2 = this.zzgn(n);
        zzejo.zzc(n2 >= 0 && n2 < this.zzmva.size(), "Batches must exist to be %s", string);
        return n2;
    }
}

