/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzebq;
import com.google.android.gms.internal.zzeco;
import com.google.android.gms.internal.zzedo;
import com.google.android.gms.internal.zzedp;
import com.google.android.gms.internal.zzeds;
import com.google.android.gms.internal.zzeen;
import com.google.android.gms.internal.zzeey;
import com.google.android.gms.internal.zzeez;
import com.google.android.gms.internal.zzefa;
import com.google.android.gms.internal.zzefb;
import com.google.android.gms.internal.zzefc;
import com.google.android.gms.internal.zzefd;
import com.google.android.gms.internal.zzefe;
import com.google.android.gms.internal.zzeff;
import com.google.android.gms.internal.zzefg;
import com.google.android.gms.internal.zzefh;
import com.google.android.gms.internal.zzefi;
import com.google.android.gms.internal.zzegf;
import com.google.android.gms.internal.zzegm;
import com.google.android.gms.internal.zzego;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzegv;
import com.google.android.gms.internal.zzehw;
import com.google.android.gms.internal.zzejm;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzeuk;
import com.google.android.gms.internal.zzevz;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzeex
implements zzeen {
    private final zzefi zzmvx;
    private final zzeds zzmvy;
    private final String zzgtz;
    private int zzmvc;
    private int zzmvz;
    private zzeuk zzmve;
    private zzedp zzmuh;

    zzeex(zzefi zzefi2, zzeds zzeds2, zzebq zzebq2) {
        this.zzmvx = zzefi2;
        this.zzmvy = zzeds2;
        this.zzgtz = zzebq2.zzbzc() ? "" : zzebq2.getUid();
        this.zzmve = zzejm.zzncy;
    }

    @Override
    public final void start() {
        zzeex zzeex2 = this;
        ArrayList arrayList = new ArrayList();
        zzeex2.zzmvx.zzqk("SELECT uid FROM mutation_queues").zza(new zzeez(arrayList));
        zzeex2.zzmvc = 0;
        ArrayList arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList2.get(i);
            String string = (String)e;
            zzeex2.zzmvx.zzqk("SELECT MAX(batch_id) FROM mutations WHERE uid = ?").zzd(string).zza(new zzefa(zzeex2));
        }
        ++zzeex2.zzmvc;
        this.zzmvz = -1;
        if (this.zzmvx.zzqk("SELECT last_acknowledged_batch_id, last_stream_token FROM mutation_queues WHERE uid = ?").zzd(this.zzgtz).zzb(new zzeey(this)) == 0) {
            this.zzcbh();
            return;
        }
        if (this.zzmvz >= this.zzmvc) {
            zzejo.zzc(this.isEmpty(), "Reset nextBatchId is only possible when the queue is empty", new Object[0]);
            this.zzmvz = -1;
            this.zzcbh();
        }
    }

    private final boolean isEmpty() {
        return this.zzmvx.zzqk("SELECT batch_id FROM mutations WHERE uid = ? LIMIT 1").zzd(this.zzgtz).isEmpty();
    }

    @Override
    public final int zzcax() {
        return this.zzmvz;
    }

    @Override
    public final void zza(zzegv zzegv2, zzeuk zzeuk2) {
        int n = zzegv2.zzcav();
        zzejo.zzc(n > this.zzmvz, "Mutation batchIds must be acknowledged in order", new Object[0]);
        this.zzmvz = n;
        this.zzmve = (zzeuk)zzbp.zzu((Object)zzeuk2);
        this.zzcbh();
    }

    @Override
    public final zzeuk zzcap() {
        return this.zzmve;
    }

    @Override
    public final void zzac(zzeuk zzeuk2) {
        this.zzmve = (zzeuk)zzbp.zzu((Object)zzeuk2);
        this.zzcbh();
    }

    private final void zzcbh() {
        this.zzmvx.zzj("INSERT OR REPLACE INTO mutation_queues (uid, last_acknowledged_batch_id, last_stream_token) VALUES (?, ?, ?)", this.zzgtz, this.zzmvz, this.zzmve.toByteArray());
    }

    @Override
    public final zzegv zzb(zzego zzego2, List<zzegu> list) {
        int n = this.zzmvc++;
        zzegv zzegv2 = new zzegv(n, zzego2, list);
        zzehw zzehw2 = this.zzmvy.zza(zzegv2);
        this.zzmvx.zzj("INSERT INTO mutations (uid, batch_id, mutations) VALUES (?, ?, ?)", this.zzgtz, n, zzehw2.toByteArray());
        HashSet<zzegf> hashSet = new HashSet<zzegf>();
        SQLiteStatement sQLiteStatement = this.zzmvx.zzqj("INSERT INTO document_mutations (uid, path, batch_id) VALUES (?, ?, ?)");
        Iterator<zzegu> iterator = list.iterator();
        while (iterator.hasNext()) {
            zzegf zzegf2 = iterator.next().zzbyq();
            if (!hashSet.add(zzegf2)) continue;
            String string = zzedo.zza(zzegf2.zzbzm());
            zzefi.zza(sQLiteStatement, this.zzgtz, string, n);
        }
        return zzegv2;
    }

    @Override
    public final zzegv zzgj(int n) {
        return (zzegv)this.zzmvx.zzqk("SELECT mutations FROM mutations WHERE uid = ? AND batch_id = ?").zzd(this.zzgtz, n).zza(new zzefb(this));
    }

    @Override
    public final zzegv zzgk(int n) {
        return (zzegv)this.zzmvx.zzqk("SELECT mutations FROM mutations WHERE uid = ? AND batch_id > ? ORDER BY batch_id ASC LIMIT 1").zzd(this.zzgtz, n).zza(new zzefc(this));
    }

    @Override
    public final List<zzegv> zzcay() {
        ArrayList<zzegv> arrayList = new ArrayList<zzegv>();
        this.zzmvx.zzqk("SELECT mutations FROM mutations WHERE uid = ? ORDER BY batch_id ASC").zzd(this.zzgtz).zza(new zzefd(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzegv> zzgl(int n) {
        ArrayList<zzegv> arrayList = new ArrayList<zzegv>();
        this.zzmvx.zzqk("SELECT mutations FROM mutations WHERE uid = ? AND batch_id <= ? ORDER BY batch_id ASC").zzd(this.zzgtz, n).zza(new zzefe(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzegv> zzf(zzegf zzegf2) {
        String string = zzedo.zza(zzegf2.zzbzm());
        ArrayList<zzegv> arrayList = new ArrayList<zzegv>();
        this.zzmvx.zzqk("SELECT m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path = ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id").zzd(this.zzgtz, string).zza(new zzeff(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzegv> zzh(zzeco zzeco2) {
        zzegm zzegm2 = zzeco2.zzbzm();
        int n = zzegm2.length() + 1;
        String string = zzedo.zza(zzegm2);
        String string2 = zzedo.zzqi(string);
        ArrayList<zzegv> arrayList = new ArrayList<zzegv>();
        this.zzmvx.zzqk("SELECT dm.batch_id, dm.path, m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path >= ? AND dm.path < ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id").zzd(this.zzgtz, string, string2).zza(new zzefg(this, arrayList, n));
        return arrayList;
    }

    @Override
    public final void zzbc(List<zzegv> list) {
        SQLiteStatement sQLiteStatement = this.zzmvx.zzqj("DELETE FROM mutations WHERE uid = ? AND batch_id = ?");
        SQLiteStatement sQLiteStatement2 = this.zzmvx.zzqj("DELETE FROM document_mutations WHERE uid = ? AND path = ? AND batch_id = ?");
        for (zzegv zzegv2 : list) {
            int n = zzegv2.zzcav();
            zzejo.zzc(zzefi.zza(sQLiteStatement, this.zzgtz, n) != 0, "Mutation batch (%s, %d) did not exist", this.zzgtz, zzegv2.zzcav());
            Iterator<zzegu> iterator = zzegv2.zzccn().iterator();
            while (iterator.hasNext()) {
                zzegf zzegf2 = iterator.next().zzbyq();
                String string = zzedo.zza(zzegf2.zzbzm());
                zzefi.zza(sQLiteStatement2, this.zzgtz, string, n);
                if (this.zzmuh == null) continue;
                this.zzmuh.zzc(zzegf2);
            }
        }
    }

    @Override
    public final void zzcaz() {
        if (!this.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.zzmvx.zzqk("SELECT path FROM document_mutations WHERE uid = ?").zzd(this.zzgtz).zza(new zzefh(arrayList));
        zzejo.zzc(arrayList.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty. Dangling keys: %s", arrayList);
    }

    private final zzegv zzaq(byte[] byArray) {
        try {
            return this.zzmvy.zza(zzehw.zzav(byArray));
        }
        catch (zzevz zzevz2) {
            throw zzejo.zzk("MutationBatch failed to parse: %s", new Object[]{zzevz2});
        }
    }

    @Override
    public final void zza(zzedp zzedp2) {
        this.zzmuh = zzedp2;
    }

    @Override
    public final boolean zzd(zzegf zzegf2) {
        String string = zzedo.zza(zzegf2.zzbzm());
        return !this.zzmvx.zzqk("SELECT batch_id FROM document_mutations WHERE uid = ? AND path = ? LIMIT 1").zzd(this.zzgtz, string).isEmpty();
    }

    final /* synthetic */ void zza(List list, int n, Cursor cursor) {
        int n2 = cursor.getInt(0);
        int n3 = list.size();
        if (n3 > 0 && n2 == ((zzegv)list.get(n3 - 1)).zzcav()) {
            return;
        }
        if (zzedo.zzqh(cursor.getString(1)).length() != n) {
            return;
        }
        list.add(this.zzaq(cursor.getBlob(2)));
    }

    final /* synthetic */ void zza(List list, Cursor cursor) {
        list.add(this.zzaq(cursor.getBlob(0)));
    }

    final /* synthetic */ void zzb(List list, Cursor cursor) {
        list.add(this.zzaq(cursor.getBlob(0)));
    }

    final /* synthetic */ void zzc(List list, Cursor cursor) {
        list.add(this.zzaq(cursor.getBlob(0)));
    }

    final /* synthetic */ zzegv zza(Cursor cursor) {
        return this.zzaq(cursor.getBlob(0));
    }

    final /* synthetic */ zzegv zzb(Cursor cursor) {
        return this.zzaq(cursor.getBlob(0));
    }

    final /* synthetic */ void zzc(Cursor cursor) {
        this.zzmvc = Math.max(this.zzmvc, cursor.getInt(0));
    }

    final /* synthetic */ void zzd(Cursor cursor) {
        this.zzmvz = cursor.getInt(0);
        this.zzmve = zzeuk.zzaz((byte[])cursor.getBlob(1));
    }
}

