/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.internal.zzebq;
import com.google.android.gms.internal.zzeds;
import com.google.android.gms.internal.zzeen;
import com.google.android.gms.internal.zzeep;
import com.google.android.gms.internal.zzeeq;
import com.google.android.gms.internal.zzeev;
import com.google.android.gms.internal.zzeex;
import com.google.android.gms.internal.zzefk;
import com.google.android.gms.internal.zzefl;
import com.google.android.gms.internal.zzefn;
import com.google.android.gms.internal.zzefv;
import com.google.android.gms.internal.zzegb;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzekl;
import com.google.android.gms.internal.zzeko;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class zzefi
extends zzeep {
    private final zzefk zzmwc;
    private final zzeds zzmvy;
    private SQLiteDatabase zzmwd;
    private boolean started;

    @VisibleForTesting
    private static String zza(String string, zzegb zzegb2) {
        try {
            String string2 = URLEncoder.encode(string, "utf-8");
            String string3 = URLEncoder.encode(zzegb2.getProjectId(), "utf-8");
            String string4 = URLEncoder.encode(zzegb2.zzcbo(), "utf-8");
            return new StringBuilder(12 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("firestore.").append(string2).append(".").append(string3).append(".").append(string4).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public zzefi(Context context, String string, zzegb zzegb2, zzeds zzeds2) {
        String string2 = zzefi.zza(string, zzegb2);
        this.zzmwc = new zzefk(context, string2);
        this.zzmvy = zzeds2;
    }

    @Override
    public final void start() {
        zzejo.zzc(!this.started, "SQLitePersistence double-started!", new Object[0]);
        this.started = true;
        try {
            this.zzmwd = this.zzmwc.getWritableDatabase();
            return;
        }
        catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
            throw new RuntimeException("Failed to gain exclusive lock to the Firestore client's offline persistence. This generally means you are using Firestore from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing Firestore in your Application class. If you are intentionally using Firestore from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.", sQLiteDatabaseLockedException);
        }
    }

    @Override
    final zzeen zzd(zzebq zzebq2) {
        return new zzeex(this, this.zzmvy, zzebq2);
    }

    @Override
    final zzeeq zzcba() {
        return new zzefn(this, this.zzmvy);
    }

    @Override
    final zzeev zzcbb() {
        return new zzefv(this, this.zzmvy);
    }

    @Override
    final void zzb(String string, Runnable runnable) {
        try {
            zzekl.zzc(TAG, "Starting transaction: %s", string);
            this.zzmwd.beginTransaction();
            runnable.run();
            this.zzmwd.setTransactionSuccessful();
            return;
        }
        finally {
            this.zzmwd.endTransaction();
        }
    }

    @Override
    final <T> T zza(String string, zzeko<T> zzeko2) {
        try {
            zzekl.zzc(TAG, "Starting transaction: %s", string);
            this.zzmwd.beginTransaction();
            T t = zzeko2.get();
            this.zzmwd.setTransactionSuccessful();
            T t2 = t;
            return t2;
        }
        finally {
            this.zzmwd.endTransaction();
        }
    }

    final void zzj(String string, Object ... objectArray) {
        this.zzmwd.execSQL(string, objectArray);
    }

    final SQLiteStatement zzqj(String string) {
        return this.zzmwd.compileStatement(string);
    }

    static int zza(SQLiteStatement sQLiteStatement, Object ... objectArray) {
        sQLiteStatement.clearBindings();
        zzefi.zza((SQLiteProgram)sQLiteStatement, objectArray);
        return sQLiteStatement.executeUpdateDelete();
    }

    final zzefl zzqk(String string) {
        return new zzefl(this, string, null);
    }

    private static void zza(SQLiteProgram sQLiteProgram, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                sQLiteProgram.bindNull(i + 1);
                continue;
            }
            if (object instanceof String) {
                sQLiteProgram.bindString(i + 1, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                sQLiteProgram.bindLong(i + 1, (long)((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                sQLiteProgram.bindLong(i + 1, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                sQLiteProgram.bindDouble(i + 1, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof byte[]) {
                sQLiteProgram.bindBlob(i + 1, (byte[])object);
                continue;
            }
            throw zzejo.zzk("Unknown argument %s of type %s", object, object.getClass());
        }
    }

    static /* synthetic */ SQLiteDatabase zza(zzefi zzefi2) {
        return zzefi2.zzmwd;
    }

    static /* synthetic */ void zza(zzefi zzefi2, SQLiteProgram sQLiteProgram, Object[] objectArray) {
        zzefi.zza(sQLiteProgram, objectArray);
    }
}

