/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzehz;
import com.google.android.gms.internal.zzeia;
import com.google.android.gms.internal.zzeib;
import com.google.android.gms.internal.zzeic;
import com.google.android.gms.internal.zzeiu;
import com.google.android.gms.internal.zzeiv;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzejp;
import com.google.android.gms.internal.zzekd;
import com.google.android.gms.internal.zzeke;
import com.google.android.gms.internal.zzekl;
import io.grpc.zzbp;
import io.grpc.zzcq;
import io.grpc.zzcs;
import io.grpc.zzj;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

abstract class zzehy<ReqT, RespT, CallbackT extends zzeiv> {
    private static final long zzmzs = TimeUnit.SECONDS.toMillis(1L);
    private static final long zzmzt = TimeUnit.MINUTES.toMillis(1L);
    private static final long zzmzu = TimeUnit.MINUTES.toMillis(1L);
    private ScheduledFuture<?> zzlur;
    private final zzeke zzmzv;
    private final zzbp<ReqT, RespT> zzmzw;
    private final zzeib zzmzx;
    private final zzejp zzmzy;
    private zzeiu zzmzz = zzeiu.zznbq;
    private zzj<ReqT, RespT> zznaa;
    final zzekd zznab;
    CallbackT zznac;
    private zzeic zznad;

    zzehy(zzeke zzeke2, zzbp<ReqT, RespT> zzbp2, zzejp zzejp2) {
        this.zzmzv = zzeke2;
        this.zzmzw = zzbp2;
        this.zzmzy = zzejp2;
        this.zzmzx = new zzeib(this);
        this.zznab = new zzekd(zzejp2, zzmzs, 1.5, zzmzt);
    }

    public boolean isStarted() {
        this.zzmzy.zzcfq();
        return this.zzmzz == zzeiu.zznbu || this.zzmzz == zzeiu.zznbr || this.zzmzz == zzeiu.zznbs;
    }

    public boolean isOpen() {
        this.zzmzy.zzcfq();
        return this.zzmzz == zzeiu.zznbs;
    }

    public void zza(CallbackT CallbackT) {
        this.zzmzy.zzcfq();
        zzejo.zzc(this.zznac == null, "Receive listener still set", new Object[0]);
        zzejo.zzc(this.zznaa == null, "Last call still set", new Object[0]);
        zzejo.zzc(this.zzlur == null, "Inactivity timer still set", new Object[0]);
        if (this.zzmzz == zzeiu.zznbt) {
            CallbackT CallbackT2 = CallbackT;
            zzehy zzehy2 = this;
            zzejo.zzc(zzehy2.zzmzz == zzeiu.zznbt, "Should only perform backoff in an error state", new Object[0]);
            zzehy2.zzmzz = zzeiu.zznbu;
            zzehy2.zznab.zzo(new zzeia(zzehy2, (zzeiv)CallbackT2));
            return;
        }
        zzejo.zzc(this.zzmzz == zzeiu.zznbq, "Already started", new Object[0]);
        this.zznac = CallbackT;
        this.zznad = new zzeic(this);
        this.zznaa = this.zzmzv.zza(this.zzmzw, this.zznad);
        this.zzmzz = zzeiu.zznbr;
        this.zzmzy.enqueue(new zzehz(this));
    }

    private final void zza(zzeiu zzeiu2, zzcq zzcq2) {
        this.zzmzy.zzcfq();
        this.zzcee();
        zzeic.zza(this.zznad, false);
        zzcs zzcs2 = zzcq2.zzcys();
        if (zzcs2 == zzcs.zzpcn) {
            this.zznab.reset();
        } else if (zzcs2 == zzcs.zzpcv) {
            zzekl.zzc(this.getClass().getSimpleName(), "(%x) Using maximum backoff delay to prevent overloading the backend.", System.identityHashCode(this));
            this.zznab.zzcfr();
        }
        this.zzmzz = zzeiu2;
        if (this.zznaa != null) {
            if (zzcq2 == zzcq.zzpbu) {
                zzekl.zzc(this.getClass().getSimpleName(), "(%x) Closing stream client-side", System.identityHashCode(this));
                this.zznaa.halfClose();
            }
            this.zznaa = null;
        }
        CallbackT CallbackT = this.zznac;
        this.zznac = null;
        if (zzeiu2 != zzeiu.zznbv) {
            CallbackT.zzb(zzcq2);
        }
    }

    public void stop() {
        if (this.isStarted()) {
            this.zza(zzeiu.zznbv, zzcq.zzpbu);
        }
    }

    public void zzceb() {
        zzejo.zzc(!this.isStarted(), "Can only inhibit backoff after in a stopped state", new Object[0]);
        this.zzmzy.zzcfq();
        this.zzmzz = zzeiu.zznbq;
        this.zznab.reset();
    }

    protected final void zzby(ReqT ReqT) {
        this.zzmzy.zzcfq();
        zzekl.zzc(this.getClass().getSimpleName(), "(%x) Stream sending: %s", System.identityHashCode(this), ReqT);
        this.zzcee();
        this.zznaa.sendMessage(ReqT);
    }

    private final void zzcec() {
        if (this.zzmzz.equals((Object)zzeiu.zznbs)) {
            this.zza(zzeiu.zznbq, zzcq.zzpbu);
        }
    }

    private final void zza(zzcq zzcq2) {
        zzejo.zzc(this.isStarted(), "Can't handle server close on non-started stream!", new Object[0]);
        this.zza(zzeiu.zznbt, zzcq2);
    }

    public abstract void zzbz(RespT var1);

    final void zzced() {
        if (this.zzmzz == zzeiu.zznbs && this.zzlur == null) {
            this.zzlur = this.zzmzy.zza(this.zzmzx, zzmzu);
        }
    }

    private final void zzcee() {
        if (this.zzlur != null) {
            this.zzlur.cancel(false);
            this.zzlur = null;
        }
    }

    final /* synthetic */ void zzb(zzeiv zzeiv2) {
        if (this.zzmzz == zzeiu.zznbv) {
            return;
        }
        zzejo.zzc(this.zzmzz == zzeiu.zznbu, "State should still be backoff but was %s", new Object[]{this.zzmzz});
        this.zzmzz = zzeiu.zznbq;
        this.zza(zzeiv2);
        zzejo.zzc(this.isStarted(), "Stream should have started", new Object[0]);
    }

    final /* synthetic */ void zzcef() {
        if (this.zzmzz == zzeiu.zznbr) {
            this.zzmzz = zzeiu.zznbs;
            this.zznac.zzbsc();
        }
    }

    static /* synthetic */ zzejp zza(zzehy zzehy2) {
        return zzehy2.zzmzy;
    }

    static /* synthetic */ void zza(zzehy zzehy2, zzcq zzcq2) {
        zzehy2.zza(zzcq2);
    }

    static /* synthetic */ void zzb(zzehy zzehy2) {
        zzehy2.zzcec();
    }
}

