/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzejx;
import com.google.android.gms.internal.zzejy;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.GeoPoint;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class zzejw {
    private static final ConcurrentMap<Class<?>, zzejx<?>> zzmlv = new ConcurrentHashMap();

    private static void zzb(boolean bl, String string) {
        if (!bl) {
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Hard assert failed: ".concat(string2) : new String("Hard assert failed: "));
        }
    }

    public static Object zzbp(Object object) {
        return zzejw.zza(object, zzejy.zzndk);
    }

    public static <T> T zza(Object object, Class<T> clazz) {
        return zzejw.zza(object, clazz, zzejy.zzndk);
    }

    private static <T> Object zza(T t, zzejy zzejy2) {
        if (zzejy2.getLength() > 500) {
            throw zzejw.zza(zzejy2, "Exceeded maximum depth of 500, which likely indicates there's an object cycle");
        }
        if (t == null) {
            return null;
        }
        if (t instanceof Number) {
            if (t instanceof Float) {
                return ((Float)t).doubleValue();
            }
            if (t instanceof Short) {
                throw zzejw.zza(zzejy2, "Shorts are not supported, please use int or long");
            }
            if (t instanceof Byte) {
                throw zzejw.zza(zzejy2, "Bytes are not supported, please use int or long");
            }
            return t;
        }
        if (t instanceof String) {
            return t;
        }
        if (t instanceof Boolean) {
            return t;
        }
        if (t instanceof Character) {
            throw zzejw.zza(zzejy2, "Characters are not supported, please use Strings.");
        }
        if (t instanceof Map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)t).entrySet()) {
                Object k = entry.getKey();
                if (k instanceof String) {
                    String string = (String)k;
                    hashMap.put(string, zzejw.zza(entry.getValue(), zzejy2.zzqv(string)));
                    continue;
                }
                throw zzejw.zza(zzejy2, "Maps with non-string keys are not supported");
            }
            return hashMap;
        }
        if (t instanceof Collection) {
            if (t instanceof List) {
                List list = (List)t;
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    int n = i;
                    arrayList.add(zzejw.zza(list.get(i), zzejy2.zzqv(new StringBuilder(13).append("[").append(n).append("]").toString())));
                }
                return arrayList;
            }
            throw zzejw.zza(zzejy2, "Serializing Collections is not supported, please use Lists instead");
        }
        if (t.getClass().isArray()) {
            throw zzejw.zza(zzejy2, "Serializing Arrays is not supported, please use Lists instead");
        }
        if (t instanceof Enum) {
            return ((Enum)t).name();
        }
        if (t instanceof Date || t instanceof GeoPoint || t instanceof Blob || t instanceof DocumentReference) {
            return t;
        }
        return zzejw.zzg(t.getClass()).zze(t, zzejy2);
    }

    private static <T> T zza(Object object, Type type, zzejy zzejy2) {
        if (object == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            zzejy zzejy3 = zzejy2;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Object object2 = object;
            Class clazz = (Class)parameterizedType.getRawType();
            if (List.class.isAssignableFrom(clazz)) {
                Type type2 = parameterizedType.getActualTypeArguments()[0];
                if (object2 instanceof List) {
                    List list = (List)object2;
                    ArrayList<T> arrayList = new ArrayList<T>(list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        int n = i;
                        arrayList.add(zzejw.zza(list.get(i), type2, zzejy3.zzqv(new StringBuilder(13).append("[").append(n).append("]").toString())));
                    }
                    return (T)arrayList;
                }
                String string = String.valueOf(object2.getClass());
                throw zzejw.zzb(zzejy3, new StringBuilder(27 + String.valueOf(string).length()).append("Expected a List, but got a ").append(string).toString());
            }
            if (Map.class.isAssignableFrom(clazz)) {
                Type type3 = parameterizedType.getActualTypeArguments()[0];
                Type type4 = parameterizedType.getActualTypeArguments()[1];
                if (!type3.equals(String.class)) {
                    String string = String.valueOf(type3);
                    throw zzejw.zzb(zzejy3, new StringBuilder(70 + String.valueOf(string).length()).append("Only Maps with string keys are supported, but found Map with key type ").append(string).toString());
                }
                Map<String, Object> map = zzejw.zzb(object2, zzejy3);
                HashMap<String, T> hashMap = new HashMap<String, T>();
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    hashMap.put(entry.getKey(), zzejw.zza(entry.getValue(), type4, zzejy3.zzqv(entry.getKey())));
                }
                return (T)hashMap;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                throw zzejw.zzb(zzejy3, "Collections are not supported, please use Lists instead");
            }
            Map<String, Object> map = zzejw.zzb(object2, zzejy3);
            zzejx zzejx2 = zzejw.zzg(clazz);
            HashMap hashMap = new HashMap();
            TypeVariable<Class<T>>[] typeVariableArray = zzejx.zza(zzejx2).getTypeParameters();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray.length != typeVariableArray.length) {
                throw new IllegalStateException("Mismatched lengths for type variables and actual types");
            }
            for (int i = 0; i < typeVariableArray.length; ++i) {
                hashMap.put(typeVariableArray[i], typeArray[i]);
            }
            return zzejx2.zza(map, hashMap, zzejy3);
        }
        if (type instanceof Class) {
            return zzejw.zza(object, (Class)type, zzejy2);
        }
        if (type instanceof WildcardType) {
            throw zzejw.zzb(zzejy2, "Generic wildcard types are not supported");
        }
        if (type instanceof GenericArrayType) {
            throw zzejw.zzb(zzejy2, "Generic Arrays are not supported, please use Lists instead");
        }
        String string = String.valueOf(type);
        throw zzejw.zzb(zzejy2, new StringBuilder(26 + String.valueOf(string).length()).append("Unknown type encountered: ").append(string).toString());
    }

    private static <T> T zza(Object object, Class<T> clazz, zzejy zzejy2) {
        if (object == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            zzejy zzejy3 = zzejy2;
            Class<T> clazz2 = clazz;
            Object object2 = object;
            if (Integer.class.isAssignableFrom(clazz2) || Integer.TYPE.isAssignableFrom(clazz2)) {
                zzejy zzejy4 = zzejy3;
                Object object3 = object2;
                if (object3 instanceof Integer) {
                    return (T)((Integer)object3);
                }
                if (object3 instanceof Long || object3 instanceof Double) {
                    double d;
                    double d2 = ((Number)object3).doubleValue();
                    if (d >= -2.147483648E9 && d2 <= 2.147483647E9) {
                        return (T)Integer.valueOf(((Number)object3).intValue());
                    }
                    throw zzejw.zzb(zzejy4, new StringBuilder(124).append("Numeric value out of 32-bit integer range: ").append(d2).append(". Did you mean to use a long or double instead of an int?").toString());
                }
                String string = object3.getClass().getName();
                throw zzejw.zzb(zzejy4, new StringBuilder(41 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to int").toString());
            }
            if (Boolean.class.isAssignableFrom(clazz2) || Boolean.TYPE.isAssignableFrom(clazz2)) {
                zzejy zzejy5 = zzejy3;
                Object object4 = object2;
                if (object4 instanceof Boolean) {
                    return (T)((Boolean)object4);
                }
                String string = object4.getClass().getName();
                throw zzejw.zzb(zzejy5, new StringBuilder(43 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to boolean").toString());
            }
            if (Double.class.isAssignableFrom(clazz2) || Double.TYPE.isAssignableFrom(clazz2)) {
                return (T)zzejw.zzc(object2, zzejy3);
            }
            if (Long.class.isAssignableFrom(clazz2) || Long.TYPE.isAssignableFrom(clazz2)) {
                zzejy zzejy6 = zzejy3;
                Object object5 = object2;
                if (object5 instanceof Integer) {
                    return (T)Long.valueOf(((Integer)object5).longValue());
                }
                if (object5 instanceof Long) {
                    return (T)((Long)object5);
                }
                if (object5 instanceof Double) {
                    Double d;
                    Double d3 = (Double)object5;
                    if (d >= -9.223372036854776E18 && d3 <= 9.223372036854776E18) {
                        return (T)Long.valueOf(d3.longValue());
                    }
                    String string = String.valueOf(d3);
                    throw zzejw.zzb(zzejy6, new StringBuilder(89 + String.valueOf(string).length()).append("Numeric value out of 64-bit long range: ").append(string).append(". Did you mean to use a double instead of a long?").toString());
                }
                String string = object5.getClass().getName();
                throw zzejw.zzb(zzejy6, new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to long").toString());
            }
            if (Float.class.isAssignableFrom(clazz2) || Float.TYPE.isAssignableFrom(clazz2)) {
                return (T)Float.valueOf(zzejw.zzc(object2, zzejy3).floatValue());
            }
            if (Short.class.isAssignableFrom(clazz2) || Short.TYPE.isAssignableFrom(clazz2)) {
                throw zzejw.zzb(zzejy3, "Deserializing to shorts is not supported");
            }
            if (Byte.class.isAssignableFrom(clazz2) || Byte.TYPE.isAssignableFrom(clazz2)) {
                throw zzejw.zzb(zzejy3, "Deserializing to bytes is not supported");
            }
            if (Character.class.isAssignableFrom(clazz2) || Character.TYPE.isAssignableFrom(clazz2)) {
                throw zzejw.zzb(zzejy3, "Deserializing to chars is not supported");
            }
            String string = String.valueOf(clazz2);
            throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Unknown primitive type: ").append(string).toString());
        }
        if (String.class.isAssignableFrom(clazz)) {
            zzejy zzejy7 = zzejy2;
            Object object6 = object;
            if (object6 instanceof String) {
                return (T)((String)object6);
            }
            String string = object6.getClass().getName();
            throw zzejw.zzb(zzejy7, new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to String").toString());
        }
        if (Date.class.isAssignableFrom(clazz)) {
            zzejy zzejy8 = zzejy2;
            Object object7 = object;
            if (object7 instanceof Date) {
                return (T)((Date)object7);
            }
            String string = object7.getClass().getName();
            throw zzejw.zzb(zzejy8, new StringBuilder(40 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to Date").toString());
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            zzejy zzejy9 = zzejy2;
            Object object8 = object;
            if (object8 instanceof Blob) {
                return (T)((Blob)object8);
            }
            String string = object8.getClass().getName();
            throw zzejw.zzb(zzejy9, new StringBuilder(40 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to Blob").toString());
        }
        if (GeoPoint.class.isAssignableFrom(clazz)) {
            zzejy zzejy10 = zzejy2;
            Object object9 = object;
            if (object9 instanceof GeoPoint) {
                return (T)((GeoPoint)object9);
            }
            String string = object9.getClass().getName();
            throw zzejw.zzb(zzejy10, new StringBuilder(44 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to GeoPoint").toString());
        }
        if (DocumentReference.class.isAssignableFrom(clazz)) {
            zzejy zzejy11 = zzejy2;
            Object object10 = object;
            if (object10 instanceof DocumentReference) {
                return (T)((DocumentReference)object10);
            }
            String string = object10.getClass().getName();
            throw zzejw.zzb(zzejy11, new StringBuilder(53 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to DocumentReference").toString());
        }
        if (clazz.isArray()) {
            throw zzejw.zzb(zzejy2, "Converting to Arrays is not supported, please use Lists instead");
        }
        if (clazz.getTypeParameters().length > 0) {
            String string = clazz.getName();
            throw zzejw.zzb(zzejy2, new StringBuilder(75 + String.valueOf(string).length()).append("Class ").append(string).append(" has generic type parameters, please use GenericTypeIndicator instead").toString());
        }
        if (clazz.equals(Object.class)) {
            return (T)object;
        }
        if (clazz.isEnum()) {
            return zzejw.zzb(object, clazz, zzejy2);
        }
        zzejy zzejy12 = zzejy2;
        Class<T> clazz3 = clazz;
        Object object11 = object;
        zzejx zzejx2 = zzejw.zzg(clazz3);
        if (object11 instanceof Map) {
            zzejy zzejy13 = zzejy12;
            Map<String, Object> map = zzejw.zzb(object11, zzejy12);
            return zzejx2.zza(map, Collections.emptyMap(), zzejy13);
        }
        String string = object11.getClass().getName();
        String string2 = clazz3.getName();
        throw zzejw.zzb(zzejy12, new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Can't convert object of type ").append(string).append(" to type ").append(string2).toString());
    }

    private static <T> T zzb(Object object, Class<T> clazz, zzejy zzejy2) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Enum.valueOf(clazz, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = clazz.getName();
                throw zzejw.zzb(zzejy2, new StringBuilder(42 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Could not find enum value of ").append(string2).append(" for value \"").append(string).append("\"").toString());
            }
        }
        String string = String.valueOf(clazz);
        String string3 = String.valueOf(object.getClass());
        throw zzejw.zzb(zzejy2, new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Expected a String while deserializing to enum ").append(string).append(" but got a ").append(string3).toString());
    }

    private static <T> zzejx<T> zzg(Class<T> clazz) {
        zzejx<T> zzejx2 = (zzejx<T>)zzmlv.get(clazz);
        if (zzejx2 == null) {
            zzejx2 = new zzejx<T>(clazz);
            zzmlv.put(clazz, zzejx2);
        }
        return zzejx2;
    }

    private static Map<String, Object> zzb(Object object, zzejy zzejy2) {
        if (object instanceof Map) {
            return (Map)object;
        }
        String string = String.valueOf(object.getClass());
        throw zzejw.zzb(zzejy2, new StringBuilder(46 + String.valueOf(string).length()).append("Expected a Map while deserializing, but got a ").append(string).toString());
    }

    private static Double zzc(Object object, zzejy zzejy2) {
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            Double d = ((Long)object).doubleValue();
            if (d.longValue() == l.longValue()) {
                return d;
            }
            String string = String.valueOf(object);
            throw zzejw.zzb(zzejy2, new StringBuilder(97 + String.valueOf(string).length()).append("Loss of precision while converting number to double: ").append(string).append(". Did you mean to use a 64-bit long instead?").toString());
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string = object.getClass().getName();
        throw zzejw.zzb(zzejy2, new StringBuilder(44 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to double").toString());
    }

    private static RuntimeException zza(zzejy zzejy2, String string) {
        String string2 = String.valueOf(string);
        String string3 = string = string2.length() != 0 ? "Could not serialize object. ".concat(string2) : new String("Could not serialize object. ");
        if (zzejy2.getLength() > 0) {
            String string4 = string;
            String string5 = zzejy2.toString();
            string = new StringBuilder(20 + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string4).append(" (found in field '").append(string5).append("')").toString();
        }
        return new RuntimeException(string);
    }

    private static RuntimeException zzb(zzejy zzejy2, String string) {
        String string2 = String.valueOf(string);
        String string3 = string = string2.length() != 0 ? "Could not deserialize object. ".concat(string2) : new String("Could not deserialize object. ");
        if (zzejy2.getLength() > 0) {
            String string4 = string;
            String string5 = zzejy2.toString();
            string = new StringBuilder(20 + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string4).append(" (found in field '").append(string5).append("')").toString();
        }
        return new RuntimeException(string);
    }

    static /* synthetic */ RuntimeException zzc(zzejy zzejy2, String string) {
        return zzejw.zzb(zzejy2, string);
    }

    static /* synthetic */ Object zzb(Object object, Type type, zzejy zzejy2) {
        return zzejw.zza(object, type, zzejy2);
    }

    static /* synthetic */ Object zzd(Object object, zzejy zzejy2) {
        return zzejw.zza(object, zzejy2);
    }

    static /* synthetic */ void zzc(boolean bl, String string) {
        zzejw.zzb(bl, string);
    }
}

