/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzebt;
import com.google.android.gms.internal.zzebu;
import com.google.android.gms.internal.zzedi;
import com.google.android.gms.internal.zzegc;
import com.google.android.gms.internal.zzegh;
import com.google.android.gms.internal.zzejo;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import java.util.ArrayList;
import java.util.List;

public class DocumentChange {
    private final Type zzmmv;
    private final DocumentSnapshot zzmmw;
    private final int zzmmx;
    private final int zzmmy;

    private DocumentChange(DocumentSnapshot documentSnapshot, Type type, int n, int n2) {
        this.zzmmv = type;
        this.zzmmw = documentSnapshot;
        this.zzmmx = n;
        this.zzmmy = n2;
    }

    @NonNull
    public Type getType() {
        return this.zzmmv;
    }

    @NonNull
    public DocumentSnapshot getDocument() {
        return this.zzmmw;
    }

    public int getOldIndex() {
        return this.zzmmx;
    }

    public int getNewIndex() {
        return this.zzmmy;
    }

    static List<DocumentChange> zza(FirebaseFirestore firebaseFirestore, zzedi zzedi2) {
        ArrayList<DocumentChange> arrayList = new ArrayList<DocumentChange>();
        if (zzedi2.zzcak().isEmpty()) {
            int n = 0;
            zzegc zzegc2 = null;
            for (zzebt zzebt2 : zzedi2.zzbwf()) {
                zzegc zzegc3 = zzebt2.zzbyr();
                DocumentSnapshot documentSnapshot = DocumentSnapshot.zza(firebaseFirestore, zzegc3, zzedi2.isFromCache());
                zzejo.zzc(zzebt2.zzbzg() == zzebu.zzmpx, "Invalid added event for first snapshot", new Object[0]);
                zzejo.zzc(zzegc2 == null || zzedi2.zzbzw().comparator().compare(zzegc2, zzegc3) < 0, "Got added events in wrong order", new Object[0]);
                arrayList.add(new DocumentChange(documentSnapshot, Type.ADDED, -1, n++));
                zzegc2 = zzegc3;
            }
        } else {
            zzegh zzegh2 = zzedi2.zzcak();
            for (zzebt zzebt3 : zzedi2.zzbwf()) {
                int n;
                int n2;
                Type type;
                zzegc zzegc4 = zzebt3.zzbyr();
                DocumentSnapshot documentSnapshot = DocumentSnapshot.zza(firebaseFirestore, zzegc4, zzedi2.isFromCache());
                zzebt zzebt4 = zzebt3;
                switch (zzebt4.zzbzg()) {
                    case zzmpx: {
                        type = Type.ADDED;
                        break;
                    }
                    case zzmpz: 
                    case zzmpy: {
                        type = Type.MODIFIED;
                        break;
                    }
                    case zzmpw: {
                        type = Type.REMOVED;
                        break;
                    }
                    default: {
                        String string = String.valueOf((Object)zzebt4.zzbzg());
                        throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Unknown view change type: ").append(string).toString());
                    }
                }
                Type type2 = type;
                if (type != Type.ADDED) {
                    n2 = zzegh2.zzl(zzegc4.zzbyq());
                    zzejo.zzc(n2 >= 0, "Index for document not found", new Object[0]);
                    zzegh2 = zzegh2.zzm(zzegc4.zzbyq());
                } else {
                    n2 = -1;
                }
                if (type2 != Type.REMOVED) {
                    n = (zzegh2 = zzegh2.zzc(zzegc4)).zzl(zzegc4.zzbyq());
                    zzejo.zzc(n >= 0, "Index for document not found", new Object[0]);
                } else {
                    n = -1;
                }
                arrayList.add(new DocumentChange(documentSnapshot, type2, n2, n));
            }
        }
        return arrayList;
    }

    public static enum Type {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

