/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzegb;
import com.google.android.gms.internal.zzegc;
import com.google.android.gms.internal.zzegf;
import com.google.android.gms.internal.zzehc;
import com.google.android.gms.internal.zzehg;
import com.google.android.gms.internal.zzehl;
import com.google.android.gms.internal.zzehm;
import com.google.android.gms.internal.zzejw;
import com.google.android.gms.internal.zzekl;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.SnapshotMetadata;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DocumentSnapshot {
    private final FirebaseFirestore zzmnd;
    private final zzegf zzmnc;
    private final zzegc zzmnh;
    private final SnapshotMetadata zzmni;

    private DocumentSnapshot(FirebaseFirestore firebaseFirestore, zzegf zzegf2, zzegc zzegc2, boolean bl) {
        this.zzmnd = (FirebaseFirestore)zzbp.zzu((Object)firebaseFirestore);
        this.zzmnc = (zzegf)zzbp.zzu((Object)zzegf2);
        this.zzmnh = zzegc2;
        boolean bl2 = this.zzmnh != null && this.zzmnh.zzcbr();
        this.zzmni = new SnapshotMetadata(bl2, bl);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzegc zzegc2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzegc2.zzbyq(), zzegc2, bl);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzegf zzegf2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzegf2, null, bl);
    }

    @NonNull
    public String getId() {
        return this.zzmnc.zzbzm().zzcbm();
    }

    @NonNull
    public SnapshotMetadata getMetadata() {
        return this.zzmni;
    }

    public boolean exists() {
        return this.zzmnh != null;
    }

    final zzegc zzbyr() {
        return this.zzmnh;
    }

    private final zzegc zzbys() {
        if (this.zzmnh == null) {
            throw new IllegalStateException("This document doesn't exist. Use DocumentSnapshot.exists() to check whether the document exists before accessing its fields.");
        }
        return this.zzmnh;
    }

    @NonNull
    public Map<String, Object> getData() {
        zzegc zzegc2 = this.zzbys();
        return this.zza(zzegc2.zzcbq());
    }

    @NonNull
    public <T> T toObject(@NonNull Class<T> clazz) {
        zzbp.zzb(clazz, (Object)"Provided POJO type must not be null.");
        return zzejw.zza(this.getData(), clazz);
    }

    public boolean contains(@NonNull String string) {
        return this.contains(FieldPath.zzqc(string));
    }

    public boolean contains(@NonNull FieldPath fieldPath) {
        zzbp.zzb((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zzbys().zzb(fieldPath.zzbyt()) != null;
    }

    public Object get(@NonNull String string) {
        return this.get(FieldPath.zzqc(string));
    }

    public Object get(@NonNull FieldPath fieldPath) {
        zzbp.zzb((Object)fieldPath, (Object)"Provided field path must not be null.");
        zzehg zzehg2 = this.zzbys().zzb(fieldPath.zzbyt());
        if (zzehg2 == null) {
            return null;
        }
        return this.zza(zzehg2);
    }

    public Boolean getBoolean(@NonNull String string) {
        return this.zzd(string, Boolean.class);
    }

    public Double getDouble(@NonNull String string) {
        Number number = this.zzd(string, Number.class);
        if (number != null) {
            return number.doubleValue();
        }
        return null;
    }

    public String getString(@NonNull String string) {
        return this.zzd(string, String.class);
    }

    public Long getLong(@NonNull String string) {
        Number number = this.zzd(string, Number.class);
        if (number != null) {
            return number.longValue();
        }
        return null;
    }

    public Date getDate(@NonNull String string) {
        return this.zzd(string, Date.class);
    }

    public Blob getBlob(@NonNull String string) {
        return this.zzd(string, Blob.class);
    }

    public GeoPoint getGeoPoint(@NonNull String string) {
        return this.zzd(string, GeoPoint.class);
    }

    public DocumentReference getDocumentReference(@NonNull String string) {
        return this.zzd(string, DocumentReference.class);
    }

    @NonNull
    public DocumentReference getReference() {
        return new DocumentReference(this.zzmnc, this.zzmnd);
    }

    private final <T> T zzd(String string, Class<T> clazz) {
        zzbp.zzb((Object)string, (Object)"Provided field must not be null.");
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        if (!clazz.isInstance(object)) {
            String string2 = clazz.getName();
            throw new RuntimeException(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Field '").append(string).append("' is not a ").append(string2).toString());
        }
        return clazz.cast(object);
    }

    private final Object zza(zzehg zzehg2) {
        if (zzehg2 instanceof zzehl) {
            return this.zza((zzehl)zzehg2);
        }
        if (zzehg2 instanceof zzehc) {
            zzehc zzehc2 = (zzehc)zzehg2;
            ArrayList<Object> arrayList = new ArrayList<Object>(zzehc2.zzcdb().size());
            for (zzehg zzehg3 : zzehc2.zzcdb()) {
                arrayList.add(zzehg3.zzbhp());
            }
            return arrayList;
        }
        if (zzehg2 instanceof zzehm) {
            zzegb zzegb2;
            zzegf zzegf2 = (zzegf)((zzehg)((zzehm)zzehg2)).zzbhp();
            zzegb zzegb3 = ((zzehm)zzehg2).zzbyw();
            if (!zzegb3.equals(zzegb2 = this.zzmnd.zzbyw())) {
                zzekl.zzb("DocumentSnapshot", String.format("Document %s contains a document reference within a different database (%s/%s) which is not supported. It will be treated as a reference in the current database (%s/%s) instead.", zzegf2.zzbzm(), zzegb3.getProjectId(), zzegb3.zzcbo(), zzegb2.getProjectId(), zzegb2.zzcbo()), new Object[0]);
            }
            return new DocumentReference(zzegf2, this.zzmnd);
        }
        return zzehg2.zzbhp();
    }

    private final Map<String, Object> zza(zzehl zzehl2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : zzehl2.zzcdg()) {
            hashMap.put((String)entry.getKey(), this.zza((zzehg)entry.getValue()));
        }
        return hashMap;
    }
}

