/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzebm;
import com.google.android.gms.internal.zzebn;
import com.google.android.gms.internal.zzebs;
import com.google.android.gms.internal.zzeca;
import com.google.android.gms.internal.zzeda;
import com.google.android.gms.internal.zzegb;
import com.google.android.gms.internal.zzegm;
import com.google.android.gms.internal.zzejp;
import com.google.android.gms.internal.zzekl;
import com.google.android.gms.internal.zzekn;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.zze;
import com.google.firebase.firestore.zzk;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class FirebaseFirestore {
    private static final Map<String, FirebaseFirestore> zzmno = new HashMap<String, FirebaseFirestore>();
    private final Context zzahz;
    private final zzegb zzmnp;
    private final String zzlyh;
    private final zzebm zzmnq;
    private final zzejp zzmnr;
    private final FirebaseApp zzlrk;
    private FirebaseFirestoreSettings zzmns;
    private zzeca zzmnt;
    private zzk zzmnu;

    @NonNull
    public static FirebaseFirestore getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return FirebaseFirestore.zze(firebaseApp, "(default)");
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseFirestore.zze(firebaseApp, "(default)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static FirebaseFirestore zze(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        zzbp.zzb((Object)firebaseApp, (Object)"Provided FirebaseApp must not be null.");
        zzbp.zzb((Object)string, (Object)"Provided database must not be null.");
        Object object = firebaseApp.getName();
        String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append("|").append(string).toString();
        object = zzmno;
        synchronized (object) {
            FirebaseFirestore firebaseFirestore = zzmno.get(string2);
            if (firebaseFirestore == null) {
                String string3 = firebaseApp.getOptions().getProjectId();
                if (string3 == null) {
                    throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
                }
                zzegb zzegb2 = zzegb.zzbj(string3, string);
                zzejp zzejp2 = new zzejp();
                zzebn zzebn2 = new zzebn(firebaseApp);
                try {
                    ProviderInstaller.installIfNeeded((Context)firebaseApp.getApplicationContext());
                }
                catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException throwable) {
                    zzekl.zzb("Firestore", "Failed to update ssl context", new Object[0]);
                }
                String string4 = firebaseApp.getName();
                firebaseFirestore = new FirebaseFirestore(firebaseApp.getApplicationContext(), zzegb2, string4, zzebn2, zzejp2, firebaseApp);
                zzmno.put(string2, firebaseFirestore);
            }
            return firebaseFirestore;
        }
    }

    private FirebaseFirestore(Context context, zzegb zzegb2, String string, zzebm zzebm2, zzejp zzejp2, @Nullable FirebaseApp firebaseApp) {
        this.zzahz = (Context)zzbp.zzu((Object)context);
        this.zzmnp = (zzegb)zzbp.zzu((Object)((zzegb)zzbp.zzu((Object)zzegb2)));
        this.zzmnu = new zzk(zzegb2);
        this.zzlyh = (String)zzbp.zzu((Object)string);
        this.zzmnq = (zzebm)zzbp.zzu((Object)zzebm2);
        this.zzmnr = (zzejp)zzbp.zzu((Object)zzejp2);
        this.zzlrk = firebaseApp;
        this.zzmns = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.zzmns;
    }

    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings firebaseFirestoreSettings) {
        zzbp.zzb((Object)firebaseFirestoreSettings, (Object)"Provided settings must not be null.");
        if (this.zzmnt != null && !this.zzmns.equals(firebaseFirestoreSettings)) {
            throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
        }
        this.zzmns = firebaseFirestoreSettings;
    }

    private final void zzbyu() {
        if (this.zzmnt == null) {
            zzebs zzebs2 = new zzebs(this.zzmnp, this.zzlyh, this.zzmns.getHost(), this.zzmns.isSslEnabled());
            this.zzmnt = new zzeca(this.zzahz, zzebs2, this.zzmns.isPersistenceEnabled(), this.zzmnq, this.zzmnr);
        }
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zzlrk;
    }

    @NonNull
    public CollectionReference collection(@NonNull String string) {
        zzbp.zzb((Object)string, (Object)"Provided collection path must not be null.");
        this.zzbyu();
        return new CollectionReference(zzegm.zzqp(string), this);
    }

    @NonNull
    public DocumentReference document(@NonNull String string) {
        zzbp.zzb((Object)string, (Object)"Provided document path must not be null.");
        this.zzbyu();
        return DocumentReference.zza(zzegm.zzqp(string), this);
    }

    @NonNull
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> function) {
        zzbp.zzb(function, (Object)"Provided transaction update function must not be null.");
        Executor executor = zzeda.zzcae();
        Transaction.Function<TResult> function2 = function;
        FirebaseFirestore firebaseFirestore = this;
        firebaseFirestore.zzbyu();
        zze zze2 = new zze(firebaseFirestore, executor, function2);
        return firebaseFirestore.zzmnt.zza(zze2, 5);
    }

    @NonNull
    public WriteBatch batch() {
        this.zzbyu();
        return new WriteBatch(this);
    }

    public static void setLoggingEnabled(boolean bl) {
        if (bl) {
            zzekl.zzhj(zzekn.zznej);
            return;
        }
        zzekl.zzhj(zzekn.zznek);
    }

    final zzeca zzbyv() {
        return this.zzmnt;
    }

    final zzegb zzbyw() {
        return this.zzmnp;
    }

    final zzk zzbyx() {
        return this.zzmnu;
    }

    final void zza(DocumentReference documentReference) {
        zzbp.zzb((Object)documentReference, (Object)"Provided DocumentReference must not be null.");
        if (documentReference.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Firestore instance.");
        }
    }
}

