/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdgi;
import com.google.android.gms.internal.zzerq;
import com.google.android.gms.internal.zzers;
import com.google.android.gms.internal.zzeta;
import com.google.common.base.Preconditions;
import io.grpc.NameResolverProvider;
import io.grpc.internal.CensusStatsModule;
import io.grpc.internal.CensusTracingModule;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.OverrideAuthorityNameResolverFactory;
import io.grpc.internal.SharedResourcePool;
import io.grpc.zza;
import io.grpc.zzah;
import io.grpc.zzak;
import io.grpc.zzav;
import io.grpc.zzbb;
import io.grpc.zzbc;
import io.grpc.zzbu;
import io.grpc.zzbv;
import io.grpc.zzbw;
import io.grpc.zzby;
import io.grpc.zzl;
import io.grpc.zzv;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends zzbc<T> {
    private static final String DIRECT_ADDRESS_SCHEME = "directaddress";
    static final long IDLE_MODE_MAX_TIMEOUT_DAYS = 30L;
    static final long IDLE_MODE_DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    static final long IDLE_MODE_MIN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final ObjectPool<? extends Executor> DEFAULT_EXECUTOR_POOL = SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    private static final zzbv DEFAULT_NAME_RESOLVER_FACTORY = NameResolverProvider.asFactory();
    private static final zzav DEFAULT_LOAD_BALANCER_FACTORY = zzby.zzcyn();
    private static final zzah DEFAULT_DECOMPRESSOR_REGISTRY = zzah.zzcxv();
    private static final zzv DEFAULT_COMPRESSOR_REGISTRY = zzv.zzcxj();
    ObjectPool<? extends Executor> executorPool = DEFAULT_EXECUTOR_POOL;
    private final List<zzl> interceptors = new ArrayList<zzl>();
    private zzbv nameResolverFactory = DEFAULT_NAME_RESOLVER_FACTORY;
    final String target;
    private final SocketAddress directServerAddress;
    String userAgent;
    String authorityOverride;
    zzav loadBalancerFactory = DEFAULT_LOAD_BALANCER_FACTORY;
    zzah decompressorRegistry = DEFAULT_DECOMPRESSOR_REGISTRY;
    zzv compressorRegistry = DEFAULT_COMPRESSOR_REGISTRY;
    long idleTimeoutMillis = IDLE_MODE_DEFAULT_TIMEOUT_MILLIS;
    private int maxInboundMessageSize = 0x400000;
    private boolean enableStatsTagPropagation;
    private boolean enableTracing;
    private zzers statsFactory;

    @Override
    public T maxInboundMessageSize(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"negative max");
        this.maxInboundMessageSize = n;
        return this.thisT();
    }

    protected final int maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    protected AbstractManagedChannelImplBuilder(String string) {
        this.target = (String)Preconditions.checkNotNull((Object)string, (Object)"target");
        this.directServerAddress = null;
    }

    static String makeTargetStringForDirectAddress(SocketAddress socketAddress) {
        try {
            String string = String.valueOf(socketAddress);
            return new URI(DIRECT_ADDRESS_SCHEME, "", new StringBuilder(1 + String.valueOf(string).length()).append("/").append(string).toString(), null).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    protected AbstractManagedChannelImplBuilder(SocketAddress socketAddress, String string) {
        this.target = AbstractManagedChannelImplBuilder.makeTargetStringForDirectAddress(socketAddress);
        this.directServerAddress = socketAddress;
        this.nameResolverFactory = new DirectAddressNameResolverFactory(socketAddress, string);
    }

    @Override
    public final T directExecutor() {
        return (T)((AbstractManagedChannelImplBuilder)((zzbc)this).executor(zzdgi.zzbjt()));
    }

    @Override
    public final T executor(Executor executor) {
        this.executorPool = executor != null ? new FixedObjectPool<Executor>(executor) : DEFAULT_EXECUTOR_POOL;
        return this.thisT();
    }

    @Override
    public final T intercept(List<zzl> list) {
        this.interceptors.addAll(list);
        return this.thisT();
    }

    @Override
    public final T intercept(zzl ... zzlArray) {
        return (T)((AbstractManagedChannelImplBuilder)((zzbc)this).intercept(Arrays.asList(zzlArray)));
    }

    @Override
    public final T nameResolverFactory(zzbv zzbv2) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of NameResolverFactory", (Object)this.directServerAddress);
        this.nameResolverFactory = zzbv2 != null ? zzbv2 : DEFAULT_NAME_RESOLVER_FACTORY;
        return this.thisT();
    }

    @Override
    public final T loadBalancerFactory(zzav zzav2) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of LoadBalancer.Factory", (Object)this.directServerAddress);
        this.loadBalancerFactory = zzav2 != null ? zzav2 : DEFAULT_LOAD_BALANCER_FACTORY;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(zzah zzah2) {
        this.decompressorRegistry = zzah2 != null ? zzah2 : DEFAULT_DECOMPRESSOR_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(zzv zzv2) {
        this.compressorRegistry = zzv2 != null ? zzv2 : DEFAULT_COMPRESSOR_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T userAgent(String string) {
        this.userAgent = string;
        return this.thisT();
    }

    @Override
    public final T overrideAuthority(String string) {
        this.authorityOverride = this.checkAuthority(string);
        return this.thisT();
    }

    @Override
    public final T idleTimeout(long l, TimeUnit timeUnit) {
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (String)"idle timeout is %s, but must be positive", (long)l);
        this.idleTimeoutMillis = timeUnit.toDays(l) >= 30L ? -1L : Math.max(timeUnit.toMillis(l), IDLE_MODE_MIN_TIMEOUT_MILLIS);
        return this.thisT();
    }

    protected final T statsContextFactory(zzers zzers2) {
        this.statsFactory = zzers2;
        return this.thisT();
    }

    protected boolean recordsStats() {
        return true;
    }

    final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    protected String checkAuthority(String string) {
        return GrpcUtil.checkAuthority(string);
    }

    @Deprecated
    public void setEnableStatsTagPropagation(boolean bl) {
        this.enableStatsTagPropagation = bl;
    }

    @Deprecated
    public void setEnableTracing(boolean bl) {
        this.enableTracing = bl;
    }

    @Override
    public zzbb build() {
        return new ManagedChannelImpl(this, this.buildTransportFactory(), new ExponentialBackoffPolicy.Provider(), SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR), GrpcUtil.STOPWATCH_SUPPLIER, this.getEffectiveInterceptors());
    }

    private List<zzl> getEffectiveInterceptors() {
        Object object;
        ArrayList<zzl> arrayList = new ArrayList<zzl>(this.interceptors);
        if (this.recordsStats() && (object = this.statsFactory != null ? this.statsFactory : zzerq.zzcrl()) != null) {
            CensusStatsModule censusStatsModule = new CensusStatsModule((zzers)object, GrpcUtil.STOPWATCH_SUPPLIER, this.enableStatsTagPropagation);
            arrayList.add(0, censusStatsModule.getClientInterceptor());
        }
        if (this.enableTracing) {
            object = new CensusTracingModule(zzeta.zzcrv(), zzeta.zzcrw());
            arrayList.add(0, ((CensusTracingModule)object).getClientInterceptor());
        }
        return arrayList;
    }

    protected abstract ClientTransportFactory buildTransportFactory();

    protected zza getNameResolverParams() {
        return zza.zzoyf;
    }

    zzbv getNameResolverFactory() {
        if (this.authorityOverride == null) {
            return this.nameResolverFactory;
        }
        return new OverrideAuthorityNameResolverFactory(this.nameResolverFactory, this.authorityOverride);
    }

    private T thisT() {
        return (T)this;
    }

    static class DirectAddressNameResolverFactory
    extends zzbv {
        final SocketAddress address;
        final String authority;

        DirectAddressNameResolverFactory(SocketAddress socketAddress, String string) {
            this.address = socketAddress;
            this.authority = string;
        }

        @Override
        public zzbu newNameResolver(URI uRI, zza zza2) {
            return new zzbu(){

                @Override
                public String getServiceAuthority() {
                    return DirectAddressNameResolverFactory.this.authority;
                }

                @Override
                public void start(zzbw zzbw2) {
                    zzbw2.onAddresses(Collections.singletonList(new zzak(DirectAddressNameResolverFactory.this.address)), zza.zzoyf);
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return AbstractManagedChannelImplBuilder.DIRECT_ADDRESS_SCHEME;
        }
    }
}

